package com.plusmpm.ini;

import java.io.InputStream;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;

public class PCMConfigSource implements ConfigSource
{
    
    public static final String PLUGIN_KEY = "com.suncode.plugin-plus-directory-monitor";
    
    private ConfigurationFileService configFileService;
    private String fileId;
    
    public PCMConfigSource( ConfigurationFileService configFileService, String fileId )
    {
        this.configFileService = configFileService;
        this.fileId = fileId;
    }
    
    @Override
    public String getSourcePath()
    {
        return fileId;
    }

    @Override
    public boolean exists()
    {
        return configFileService.doesFileExist( PLUGIN_KEY, fileId );
    }

    @Override
    public boolean canWrite()
    {
        return exists();
    }

    @Override
    public InputStream load() throws Exception
    {
        return configFileService.readFile( PLUGIN_KEY, fileId );
    }

    @Override
    public void save( InputStream inputStream ) throws Exception
    {
        configFileService.saveFile( PLUGIN_KEY, fileId, inputStream );
    }

}
