package com.plusmpm.ini;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;

public class FileConfigSource implements ConfigSource
{    
    private String fileName;
    
    public FileConfigSource(String fileName)
    {
        this.fileName = fileName;
    }

    @Override
    public String getSourcePath()
    {
        return fileName;
    }

    @Override
    public boolean exists()
    {
        File file = new File( fileName );
        return file.exists() && file.isFile();
    }

    @Override
    public boolean canWrite()
    {
        File file = new File( fileName );
        return file.canWrite();
    }

    @Override
    public InputStream load() throws Exception
    {
        return new FileInputStream( fileName );
    }

    @Override
    public void save( InputStream inputStream ) throws Exception
    {
        try ( FileOutputStream outputStream = new FileOutputStream( fileName ) ){
            IOUtils.copy( inputStream, outputStream );
        }
    }

}
