package com.plusmpm.directorymonitor.document;

import com.plusmpm.directorymonitor.module.DocumentUploadListener;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Optional;

@Slf4j
@Component
public class DocumentUploadListenerRegistry
{

    private String registeringPluginKey;
    private String registeringKey;

    private DocumentUploadListener documentUploadListener;

    public void registerListener( String pluginKey, String key, DocumentUploadListener documentUploadListener )
    {
        if ( this.documentUploadListener != null )
        {
            log.warn( "Plugin {} tried to register document upload listener "
                          + "while {} has already done it.",
                      pluginKey, this.registeringPluginKey
            );
            return;
        }

        registeringPluginKey = pluginKey;
        registeringKey = key;
        this.documentUploadListener = documentUploadListener;
    }

    public void unregisterListener( String pluginKey, String key )
    {
        if ( registeringPluginKey.equals( pluginKey ) && registeringKey.equals( key ) )
        {
            registeringPluginKey = null;
            registeringKey = null;
            documentUploadListener = null;
        }
    }

    public Optional<DocumentUploadListener> getDocumentUploadListener()
    {
        return Optional.ofNullable( documentUploadListener );
    }

}
