package com.plusmpm.directorymonitor;

import java.awt.event.KeyEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Event;
import java.awt.BorderLayout;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.KeyStroke;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JFrame;
import javax.swing.JDialog;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import java.awt.CardLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JWindow;
import javax.swing.JInternalFrame;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;
import javax.swing.JTextField;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import java.awt.Font;
import java.awt.Color;

public class MainWindow
{

    private JFrame jFrame = null; // @jve:decl-index=0:visual-constraint="0,0"

    private JMenuBar jJMenuBar = null;

    private JMenu fileMenu = null;

    private JMenu editMenu = null;

    private JMenu helpMenu = null;

    private JMenuItem exitMenuItem = null;

    private JMenuItem aboutMenuItem = null;

    private JMenuItem cutMenuItem = null;

    private JMenuItem copyMenuItem = null;

    private JMenuItem pasteMenuItem = null;

    private JMenuItem saveMenuItem = null;

    private JDialog aboutDialog = null; // @jve:decl-index=0:visual-constraint="674,0"

    private JPanel aboutContentPane = null;

    private JLabel aboutVersionLabel = null;

    private JPanel jContentPane = null;

    private JList jListShare = null;

    private JButton jButtonAdd = null;

    private JButton jButtonRemove = null;

    private JTabbedPane jTabbedPane = null;

    private JButton jButtonApply = null;

    private JButton jButtonOk = null;

    private JButton jButtonCancel = null;

    private JPanel jPanelMainSetting = null;

    private JPanel jPanelIndexes = null;

    private JTextField jTextFieldShareId = null;

    private JLabel jLabelShareId = null;

    private JTextField jTextFieldSharePath = null;

    private JLabel jLabelSharePath = null;

    private JCheckBox jCheckBoxSearchSubDirectory = null;

    private JCheckBox jCheckBoxDeleteFiles = null;

    private JCheckBox jCheckBoxCopyFiles = null;

    private JTextField jTextFieldDestinationPath = null;

    private JLabel jLabelDestinationPath = null;

    private JCheckBox jCheckBoxCheckAtTime = null;

    private JTextField jTextFieldCheckAtTime = null;

    private JLabel jLabelCheckAtTime = null;

    private JCheckBox jCheckBoxCheckPeriodic = null;

    private JTextField jTextFieldPeriod = null;

    private JLabel jLabelPeriod = null;

    private JComboBox jComboBoxArchiveClass = null;

    private JLabel jLabelArchiveClass = null;

    private JLabel jLabelIndexList = null;

    private JList jListIndexes = null;

    private JLabel jLabelSettings = null;

    private JLabel jLabelIndexType = null;

    private JComboBox jComboBoxIndexType = null;

    private JLabel jLabelParam1 = null;

    private JTextField jTextFieldParam1 = null;

    private JLabel jLabelParam2 = null;

    private JTextField jTextFieldParam2 = null;

    private JLabel jLabelParam3 = null;

    private JTextField jTextFieldParam3 = null;

    /**
     * This method initializes jFrame
     * 
     * @return javax.swing.JFrame
     */
    protected JFrame getJFrame()
    {
        if ( jFrame == null )
        {
            jFrame = new JFrame();
            jFrame.setDefaultCloseOperation( JFrame.DISPOSE_ON_CLOSE );
            jFrame.setSize( new Dimension( 640, 480 ) );
            jFrame.setResizable( true );
            jFrame.setPreferredSize( new Dimension( 640, 480 ) );
            jFrame.setJMenuBar( getJJMenuBar() );
            jFrame.setContentPane( getJContentPane() );
            jFrame.setSize( 300, 200 );
            jFrame.setTitle( "PlusDirectoryMonitor" );
        }
        return jFrame;
    }

    /**
     * This method initializes jJMenuBar
     * 
     * @return javax.swing.JMenuBar
     */
    private JMenuBar getJJMenuBar()
    {
        if ( jJMenuBar == null )
        {
            jJMenuBar = new JMenuBar();
            jJMenuBar.add( getFileMenu() );
            jJMenuBar.add( getEditMenu() );
            jJMenuBar.add( getHelpMenu() );
        }
        return jJMenuBar;
    }

    /**
     * This method initializes jMenu
     * 
     * @return javax.swing.JMenu
     */
    private JMenu getFileMenu()
    {
        if ( fileMenu == null )
        {
            fileMenu = new JMenu();
            fileMenu.setText( "File" );
            fileMenu.add( getSaveMenuItem() );
            fileMenu.add( getExitMenuItem() );
        }
        return fileMenu;
    }

    /**
     * This method initializes jMenu
     * 
     * @return javax.swing.JMenu
     */
    private JMenu getEditMenu()
    {
        if ( editMenu == null )
        {
            editMenu = new JMenu();
            editMenu.setText( "Edit" );
            editMenu.add( getCutMenuItem() );
            editMenu.add( getCopyMenuItem() );
            editMenu.add( getPasteMenuItem() );
        }
        return editMenu;
    }

    /**
     * This method initializes jMenu
     * 
     * @return javax.swing.JMenu
     */
    private JMenu getHelpMenu()
    {
        if ( helpMenu == null )
        {
            helpMenu = new JMenu();
            helpMenu.setText( "Help" );
            helpMenu.add( getAboutMenuItem() );
        }
        return helpMenu;
    }

    /**
     * This method initializes jMenuItem
     * 
     * @return javax.swing.JMenuItem
     */
    private JMenuItem getExitMenuItem()
    {
        if ( exitMenuItem == null )
        {
            exitMenuItem = new JMenuItem();
            exitMenuItem.setText( "Exit" );
            exitMenuItem.addActionListener( new ActionListener()
            {
                public void actionPerformed( ActionEvent e )
                {
                    jFrame.dispose();
                }
            } );
        }
        return exitMenuItem;
    }

    /**
     * This method initializes jMenuItem
     * 
     * @return javax.swing.JMenuItem
     */
    private JMenuItem getAboutMenuItem()
    {
        if ( aboutMenuItem == null )
        {
            aboutMenuItem = new JMenuItem();
            aboutMenuItem.setText( "About" );
            aboutMenuItem.addActionListener( new ActionListener()
            {
                public void actionPerformed( ActionEvent e )
                {
                    JDialog aboutDialog = getAboutDialog();
                    aboutDialog.pack();
                    Point loc = getJFrame().getLocation();
                    loc.translate( 20, 20 );
                    aboutDialog.setLocation( loc );
                    aboutDialog.setVisible( true );
                }
            } );
        }
        return aboutMenuItem;
    }

    /**
     * This method initializes aboutDialog
     * 
     * @return javax.swing.JDialog
     */
    private JDialog getAboutDialog()
    {
        if ( aboutDialog == null )
        {
            aboutDialog = new JDialog( getJFrame(), true );
            aboutDialog.setTitle( "About" );
            aboutDialog.setSize( new Dimension( 209, 129 ) );
            aboutDialog.setContentPane( getAboutContentPane() );
        }
        return aboutDialog;
    }

    /**
     * This method initializes aboutContentPane
     * 
     * @return javax.swing.JPanel
     */
    private JPanel getAboutContentPane()
    {
        if ( aboutContentPane == null )
        {
            aboutContentPane = new JPanel();
            aboutContentPane.setLayout( new BorderLayout() );
            aboutContentPane.add( getAboutVersionLabel(), BorderLayout.CENTER );
        }
        return aboutContentPane;
    }

    /**
     * This method initializes aboutVersionLabel
     * 
     * @return javax.swing.JLabel
     */
    private JLabel getAboutVersionLabel()
    {
        if ( aboutVersionLabel == null )
        {
            aboutVersionLabel = new JLabel();
            aboutVersionLabel.setText( "<html><center><br>PlusDirectoryMonitor<br>Version 1.0<br>&nbsp;&nbsp;(c) Copyright Plus MPM 2007&nbsp;&nbsp;<br>&nbsp;</center></html>" );
            aboutVersionLabel.setHorizontalAlignment( SwingConstants.CENTER );
        }
        return aboutVersionLabel;
    }

    /**
     * This method initializes jMenuItem
     * 
     * @return javax.swing.JMenuItem
     */
    private JMenuItem getCutMenuItem()
    {
        if ( cutMenuItem == null )
        {
            cutMenuItem = new JMenuItem();
            cutMenuItem.setText( "Cut" );
            cutMenuItem.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_X, Event.CTRL_MASK, true ) );
        }
        return cutMenuItem;
    }

    /**
     * This method initializes jMenuItem
     * 
     * @return javax.swing.JMenuItem
     */
    private JMenuItem getCopyMenuItem()
    {
        if ( copyMenuItem == null )
        {
            copyMenuItem = new JMenuItem();
            copyMenuItem.setText( "Copy" );
            copyMenuItem.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_C, Event.CTRL_MASK, true ) );
        }
        return copyMenuItem;
    }

    /**
     * This method initializes jMenuItem
     * 
     * @return javax.swing.JMenuItem
     */
    private JMenuItem getPasteMenuItem()
    {
        if ( pasteMenuItem == null )
        {
            pasteMenuItem = new JMenuItem();
            pasteMenuItem.setText( "Paste" );
            pasteMenuItem.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_V, Event.CTRL_MASK, true ) );
        }
        return pasteMenuItem;
    }

    /**
     * This method initializes jMenuItem
     * 
     * @return javax.swing.JMenuItem
     */
    private JMenuItem getSaveMenuItem()
    {
        if ( saveMenuItem == null )
        {
            saveMenuItem = new JMenuItem();
            saveMenuItem.setText( "Save" );
            saveMenuItem.setAccelerator( KeyStroke.getKeyStroke( KeyEvent.VK_S, Event.CTRL_MASK, true ) );
        }
        return saveMenuItem;
    }

    /**
     * This method initializes jContentPane
     * 
     * @return javax.swing.JPanel
     */
    private JPanel getJContentPane()
    {
        if ( jContentPane == null )
        {
            jContentPane = new JPanel();
            jContentPane.setLayout( null );
            jContentPane.add( getJListShare(), null );
            jContentPane.add( getJButtonAdd(), null );
            jContentPane.add( getJButtonRemove(), null );
            jContentPane.add( getJTabbedPane(), null );
            jContentPane.add( getJButtonApply(), null );
            jContentPane.add( getJButtonOk(), null );
            jContentPane.add( getJButtonCancel(), null );
        }
        return jContentPane;
    }

    /**
     * This method initializes jListShare
     * 
     * @return javax.swing.JList
     */
    private JList getJListShare()
    {
        if ( jListShare == null )
        {
            jListShare = new JList();
            jListShare.setBounds( new Rectangle( 10, 10, 241, 381 ) );
        }
        return jListShare;
    }

    /**
     * This method initializes jButtonAdd
     * 
     * @return javax.swing.JButton
     */
    private JButton getJButtonAdd()
    {
        if ( jButtonAdd == null )
        {
            jButtonAdd = new JButton();
            jButtonAdd.setBounds( new Rectangle( 10, 400, 81, 21 ) );
            jButtonAdd.setText( "Dodaj" );
            jButtonAdd.addActionListener( new java.awt.event.ActionListener()
            {
                public void actionPerformed( java.awt.event.ActionEvent e )
                {
                    //
                }
            } );
        }
        return jButtonAdd;
    }

    /**
     * This method initializes jButtonRemove
     * 
     * @return javax.swing.JButton
     */
    private JButton getJButtonRemove()
    {
        if ( jButtonRemove == null )
        {
            jButtonRemove = new JButton();
            jButtonRemove.setBounds( new Rectangle( 110, 400, 81, 21 ) );
            jButtonRemove.setText( "Usu�" );
        }
        return jButtonRemove;
    }

    /**
     * This method initializes jTabbedPane
     * 
     * @return javax.swing.JTabbedPane
     */
    private JTabbedPane getJTabbedPane()
    {
        if ( jTabbedPane == null )
        {
            jTabbedPane = new JTabbedPane();
            jTabbedPane.setBounds( new Rectangle( 260, 10, 361, 381 ) );
            jTabbedPane.addTab( "Katalog", null, getJPanelMainSetting(), null );
            jTabbedPane.addTab( "Klasy i indeksy", null, getJPanelIndexes(), null );
        }
        return jTabbedPane;
    }

    /**
     * This method initializes jButtonApply
     * 
     * @return javax.swing.JButton
     */
    private JButton getJButtonApply()
    {
        if ( jButtonApply == null )
        {
            jButtonApply = new JButton();
            jButtonApply.setBounds( new Rectangle( 330, 400, 91, 21 ) );
            jButtonApply.setText( "Zastosuj" );
        }
        return jButtonApply;
    }

    /**
     * This method initializes jButtonOk
     * 
     * @return javax.swing.JButton
     */
    private JButton getJButtonOk()
    {
        if ( jButtonOk == null )
        {
            jButtonOk = new JButton();
            jButtonOk.setBounds( new Rectangle( 440, 400, 81, 21 ) );
            jButtonOk.setText( "Ok" );
        }
        return jButtonOk;
    }

    /**
     * This method initializes jButtonCancel
     * 
     * @return javax.swing.JButton
     */
    private JButton getJButtonCancel()
    {
        if ( jButtonCancel == null )
        {
            jButtonCancel = new JButton();
            jButtonCancel.setBounds( new Rectangle( 540, 400, 81, 21 ) );
            jButtonCancel.setText( "Anuluj" );
        }
        return jButtonCancel;
    }

    /**
     * This method initializes jPanelMainSetting
     * 
     * @return javax.swing.JPanel
     */
    private JPanel getJPanelMainSetting()
    {
        if ( jPanelMainSetting == null )
        {
            jLabelPeriod = new JLabel();
            jLabelPeriod.setBounds( new Rectangle( 10, 290, 111, 21 ) );
            jLabelPeriod.setText( "Okres [s]" );
            jLabelCheckAtTime = new JLabel();
            jLabelCheckAtTime.setBounds( new Rectangle( 10, 230, 111, 21 ) );
            jLabelCheckAtTime.setText( "Godzina " );
            jLabelDestinationPath = new JLabel();
            jLabelDestinationPath.setBounds( new Rectangle( 10, 170, 111, 21 ) );
            jLabelDestinationPath.setText( "Katalog docelowy" );
            jLabelSharePath = new JLabel();
            jLabelSharePath.setBounds( new Rectangle( 10, 50, 111, 21 ) );
            jLabelSharePath.setText( "Katalog" );
            jLabelShareId = new JLabel();
            jLabelShareId.setBounds( new Rectangle( 10, 20, 111, 21 ) );
            jLabelShareId.setText( "Nazwa" );
            jPanelMainSetting = new JPanel();
            jPanelMainSetting.setLayout( null );
            jPanelMainSetting.setBorder( BorderFactory.createTitledBorder( null, "Ustawienia katalogu", TitledBorder.DEFAULT_JUSTIFICATION,
                                                                           TitledBorder.DEFAULT_POSITION, new Font( "Dialog", Font.BOLD, 12 ),
                                                                           new Color( 51, 51, 51 ) ) );
            jPanelMainSetting.add( getJTextFieldShareId(), null );
            jPanelMainSetting.add( jLabelShareId, null );
            jPanelMainSetting.add( getJTextFieldSharePath(), null );
            jPanelMainSetting.add( jLabelSharePath, null );
            jPanelMainSetting.add( getJCheckBoxSearchSubDirectory(), null );
            jPanelMainSetting.add( getJCheckBoxDeleteFiles(), null );
            jPanelMainSetting.add( getJCheckBoxCopyFiles(), null );
            jPanelMainSetting.add( getJTextFieldDestinationPath(), null );
            jPanelMainSetting.add( jLabelDestinationPath, null );
            jPanelMainSetting.add( getJCheckBoxCheckAtTime(), null );
            jPanelMainSetting.add( getJTextFieldCheckAtTime(), null );
            jPanelMainSetting.add( jLabelCheckAtTime, null );
            jPanelMainSetting.add( getJCheckBoxCheckPeriodic(), null );
            jPanelMainSetting.add( getJTextFieldPeriod(), null );
            jPanelMainSetting.add( jLabelPeriod, null );
        }
        return jPanelMainSetting;
    }

    /**
     * This method initializes jPanelIndexes
     * 
     * @return javax.swing.JPanel
     */
    private JPanel getJPanelIndexes()
    {
        if ( jPanelIndexes == null )
        {
            jLabelParam3 = new JLabel();
            jLabelParam3.setBounds( new Rectangle( 160, 260, 181, 21 ) );
            jLabelParam3.setText( "JLabel" );
            jLabelParam2 = new JLabel();
            jLabelParam2.setBounds( new Rectangle( 160, 200, 181, 21 ) );
            jLabelParam2.setText( "JLabel" );
            jLabelParam1 = new JLabel();
            jLabelParam1.setBounds( new Rectangle( 160, 140, 181, 21 ) );
            jLabelParam1.setText( "JLabel" );
            jLabelIndexType = new JLabel();
            jLabelIndexType.setBounds( new Rectangle( 160, 80, 181, 21 ) );
            jLabelIndexType.setText( "Typ indeksu" );
            jLabelSettings = new JLabel();
            jLabelSettings.setBounds( new Rectangle( 160, 50, 181, 21 ) );
            jLabelSettings.setText( "Ustawienia indeksu" );
            jLabelIndexList = new JLabel();
            jLabelIndexList.setBounds( new Rectangle( 10, 50, 141, 21 ) );
            jLabelIndexList.setText( "Indeksy" );
            jLabelArchiveClass = new JLabel();
            jLabelArchiveClass.setBounds( new Rectangle( 10, 20, 111, 21 ) );
            jLabelArchiveClass.setText( "Klasa archiwum" );
            jPanelIndexes = new JPanel();
            jPanelIndexes.setLayout( null );
            jPanelIndexes.setBorder( BorderFactory.createTitledBorder( null, "Ustawienia klas i indeks�w", TitledBorder.DEFAULT_JUSTIFICATION,
                                                                       TitledBorder.DEFAULT_POSITION, new Font( "Dialog", Font.BOLD, 12 ),
                                                                       new Color( 51, 51, 51 ) ) );
            jPanelIndexes.add( getJComboBoxArchiveClass(), null );
            jPanelIndexes.add( jLabelArchiveClass, null );
            jPanelIndexes.add( jLabelIndexList, null );
            jPanelIndexes.add( getJListIndexes(), null );
            jPanelIndexes.add( jLabelSettings, null );
            jPanelIndexes.add( jLabelIndexType, null );
            jPanelIndexes.add( getJComboBoxIndexType(), null );
            jPanelIndexes.add( jLabelParam1, null );
            jPanelIndexes.add( getJTextFieldParam1(), null );
            jPanelIndexes.add( jLabelParam2, null );
            jPanelIndexes.add( getJTextFieldParam2(), null );
            jPanelIndexes.add( jLabelParam3, null );
            jPanelIndexes.add( getJTextFieldParam3(), null );
        }
        return jPanelIndexes;
    }

    /**
     * This method initializes jTextFieldShareId
     * 
     * @return javax.swing.JTextField
     */
    private JTextField getJTextFieldShareId()
    {
        if ( jTextFieldShareId == null )
        {
            jTextFieldShareId = new JTextField();
            jTextFieldShareId.setBounds( new Rectangle( 130, 20, 211, 21 ) );
        }
        return jTextFieldShareId;
    }

    /**
     * This method initializes jTextFieldSharePath
     * 
     * @return javax.swing.JTextField
     */
    private JTextField getJTextFieldSharePath()
    {
        if ( jTextFieldSharePath == null )
        {
            jTextFieldSharePath = new JTextField();
            jTextFieldSharePath.setBounds( new Rectangle( 130, 50, 211, 21 ) );
        }
        return jTextFieldSharePath;
    }

    /**
     * This method initializes jCheckBoxSearchSubDirectory
     * 
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getJCheckBoxSearchSubDirectory()
    {
        if ( jCheckBoxSearchSubDirectory == null )
        {
            jCheckBoxSearchSubDirectory = new JCheckBox();
            jCheckBoxSearchSubDirectory.setBounds( new Rectangle( 10, 80, 201, 21 ) );
            jCheckBoxSearchSubDirectory.setText( "Przetwarzaj podkatalogi" );
        }
        return jCheckBoxSearchSubDirectory;
    }

    /**
     * This method initializes jCheckBoxDeleteFiles
     * 
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getJCheckBoxDeleteFiles()
    {
        if ( jCheckBoxDeleteFiles == null )
        {
            jCheckBoxDeleteFiles = new JCheckBox();
            jCheckBoxDeleteFiles.setBounds( new Rectangle( 10, 110, 201, 21 ) );
            jCheckBoxDeleteFiles.setText( "Usuwaj przetworzone pliki" );
        }
        return jCheckBoxDeleteFiles;
    }

    /**
     * This method initializes jCheckBoxCopyFiles
     * 
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getJCheckBoxCopyFiles()
    {
        if ( jCheckBoxCopyFiles == null )
        {
            jCheckBoxCopyFiles = new JCheckBox();
            jCheckBoxCopyFiles.setBounds( new Rectangle( 10, 140, 201, 21 ) );
            jCheckBoxCopyFiles.setText( "Kopiuj przetworzone pliki" );
        }
        return jCheckBoxCopyFiles;
    }

    /**
     * This method initializes jTextFieldDestinationPath
     * 
     * @return javax.swing.JTextField
     */
    private JTextField getJTextFieldDestinationPath()
    {
        if ( jTextFieldDestinationPath == null )
        {
            jTextFieldDestinationPath = new JTextField();
            jTextFieldDestinationPath.setBounds( new Rectangle( 130, 170, 211, 21 ) );
        }
        return jTextFieldDestinationPath;
    }

    /**
     * This method initializes jCheckBoxCheckAtTime
     * 
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getJCheckBoxCheckAtTime()
    {
        if ( jCheckBoxCheckAtTime == null )
        {
            jCheckBoxCheckAtTime = new JCheckBox();
            jCheckBoxCheckAtTime.setBounds( new Rectangle( 10, 200, 221, 21 ) );
            jCheckBoxCheckAtTime.setText( "Przetwarzaj o okre�lonej godzinie" );
        }
        return jCheckBoxCheckAtTime;
    }

    /**
     * This method initializes jTextFieldCheckAtTime
     * 
     * @return javax.swing.JTextField
     */
    private JTextField getJTextFieldCheckAtTime()
    {
        if ( jTextFieldCheckAtTime == null )
        {
            jTextFieldCheckAtTime = new JTextField();
            jTextFieldCheckAtTime.setBounds( new Rectangle( 130, 230, 211, 21 ) );
        }
        return jTextFieldCheckAtTime;
    }

    /**
     * This method initializes jCheckBoxCheckPeriodic
     * 
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getJCheckBoxCheckPeriodic()
    {
        if ( jCheckBoxCheckPeriodic == null )
        {
            jCheckBoxCheckPeriodic = new JCheckBox();
            jCheckBoxCheckPeriodic.setBounds( new Rectangle( 10, 260, 201, 21 ) );
            jCheckBoxCheckPeriodic.setText( "Przetwarzaj okresowo" );
        }
        return jCheckBoxCheckPeriodic;
    }

    /**
     * This method initializes jTextFieldPeriod
     * 
     * @return javax.swing.JTextField
     */
    private JTextField getJTextFieldPeriod()
    {
        if ( jTextFieldPeriod == null )
        {
            jTextFieldPeriod = new JTextField();
            jTextFieldPeriod.setBounds( new Rectangle( 130, 290, 211, 21 ) );
        }
        return jTextFieldPeriod;
    }

    /**
     * This method initializes jComboBoxArchiveClass
     * 
     * @return javax.swing.JComboBox
     */
    private JComboBox getJComboBoxArchiveClass()
    {
        if ( jComboBoxArchiveClass == null )
        {
            jComboBoxArchiveClass = new JComboBox();
            jComboBoxArchiveClass.setBounds( new Rectangle( 130, 20, 211, 21 ) );
        }
        return jComboBoxArchiveClass;
    }

    /**
     * This method initializes jListIndexes
     * 
     * @return javax.swing.JList
     */
    private JList getJListIndexes()
    {
        if ( jListIndexes == null )
        {
            jListIndexes = new JList();
            jListIndexes.setBounds( new Rectangle( 10, 80, 141, 261 ) );
        }
        return jListIndexes;
    }

    /**
     * This method initializes jComboBoxIndexType
     * 
     * @return javax.swing.JComboBox
     */
    private JComboBox getJComboBoxIndexType()
    {
        if ( jComboBoxIndexType == null )
        {
            jComboBoxIndexType = new JComboBox();
            jComboBoxIndexType.setBounds( new Rectangle( 160, 110, 181, 21 ) );
        }
        return jComboBoxIndexType;
    }

    /**
     * This method initializes jTextFieldParam1
     * 
     * @return javax.swing.JTextField
     */
    private JTextField getJTextFieldParam1()
    {
        if ( jTextFieldParam1 == null )
        {
            jTextFieldParam1 = new JTextField();
            jTextFieldParam1.setBounds( new Rectangle( 160, 170, 181, 21 ) );
        }
        return jTextFieldParam1;
    }

    /**
     * This method initializes jTextFieldParam2
     * 
     * @return javax.swing.JTextField
     */
    private JTextField getJTextFieldParam2()
    {
        if ( jTextFieldParam2 == null )
        {
            jTextFieldParam2 = new JTextField();
            jTextFieldParam2.setBounds( new Rectangle( 160, 230, 181, 21 ) );
        }
        return jTextFieldParam2;
    }

    /**
     * This method initializes jTextFieldParam3
     * 
     * @return javax.swing.JTextField
     */
    private JTextField getJTextFieldParam3()
    {
        if ( jTextFieldParam3 == null )
        {
            jTextFieldParam3 = new JTextField();
            jTextFieldParam3.setBounds( new Rectangle( 160, 290, 181, 21 ) );
        }
        return jTextFieldParam3;
    }

    /**
     * Launches this application
     */
    public static void main( String[] args )
    {
        SwingUtilities.invokeLater( new Runnable()
        {
            public void run()
            {
                MainWindow application = new MainWindow();
                application.getJFrame().setVisible( true );
            }
        } );
    }

}
