package com.plusmpm.directorymonitor;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

import com.plusmpm.directorymonitor.exceptions.DuplicateShareIdException;
import com.suncode.plugin.wrapper.DirectoryMonitorPluginContext;
import org.apache.log4j.Logger;

import com.plusmpm.ini.ConfigSource;
import com.plusmpm.ini.FileConfigSource;
import com.plusmpm.ini.INIFile;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.ServiceFactory;

/**
 * @author Piotr Gabka
 */
public class DirectoryMonitor
{
    private static Logger log = Logger.getLogger( DirectoryMonitor.class );

    private TrayIcon trayIcon = null;

    private static String sMonitorIcon = "/images/com/plusmpm/images/Find16.gif";

    private static String sConfigDirectory = File.separator.concat( "PlusMPM" );

    private static String sConfigFile = File.separator.concat( "DirectoryMonitor.ini" );

    // Prefix dla sekcji przetwarzania katalogow
    private static String sArchPrefix = "Arch";

    // ustawienia w sekcji setting pliku ini
    private static String sSettingsKey = "Settings";

    private static String sProcessOnce = "ProcessOnce";

    private static String sProcessAtStartup = "ProcessAtStartup";

    private static String sShowInfoMessages = "ShowInfoMessages";

    private static String sUserProp = "Login";

    private static String sPasswordProp = "Password";

    private static String sActive = "Active";

    private static String sTrue = "true";

    private static String sFalse = "false";

    private static String sAccessWithWebService = "AccessWithWebService";

    private Boolean bAccessWithWebService;
    
    private Boolean bIsStandaloneApp;

    private String sUser;

    private String sPassword;

    // ustawienia w sekcji WebService
    private static String sWebServiceKey = "WebService";

    private static String sWSDLURL = "WSDL_URL";

    private static String sNamespace = "Namespace";

    private static String sServiceName = "ServiceName";

    private Map<String, Map<String, String>> mmINIFile = null;

    private Map<String, DirectoryShare> mDirectoryShares = null;

    private final DirectoryMonitorPluginContext nullablePluginContext;

    public DirectoryMonitor()
    {
        this(false);
    }

    public DirectoryMonitor( Boolean bIsStandaloneApp )
    {
        this( bIsStandaloneApp, null );
    }

    public DirectoryMonitor( Boolean bIsStandaloneApp,
                             DirectoryMonitorPluginContext nullablePluginContext )
    {
        this.bIsStandaloneApp = bIsStandaloneApp;
        this.nullablePluginContext = nullablePluginContext;
    }
    
    private void SettingWindow()
    {
        SwingUtilities.invokeLater( new Runnable()
        {
            public void run()
            {
                MainWindow application = new MainWindow();
                application.getJFrame().setVisible( true );
            }
        } );
    }

    private Map<String, Map<String, String>> SetDefaultSetting()
    {
        Map<String, Map<String, String>> mmConfig = null;
        try
        {
            log.info( "Starting SetDefaultSetting" );
            mmConfig = new LinkedHashMap<String, Map<String, String>>();
            Map<String, String> mSetting = new LinkedHashMap<String, String>();
            Map<String, String> mWebService = new LinkedHashMap<String, String>();
            mSetting.put( sProcessAtStartup, sFalse );
            mSetting.put( sShowInfoMessages, sTrue );
            mSetting.put( sUser, "" );
            mSetting.put( sPassword, "" );
            mmConfig.put( sSettingsKey, mSetting );

            // Ustawienie parametrow WebService
            mWebService.put( "WSDL_URL", "http://localhost:8080/PlusWorkflow/services/" );
            mWebService.put( "Namespace", "http://services.plusmpm.com" );
            mWebService.put( "ServiceName", "ReleaseService" );

            return mmConfig;
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
            return mmConfig;
        }
    }

    private File GetINIFile( String sFile )
    {
        File fFile = null;
        try
        {
            fFile = new File( sFile );
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
        }
        if ( fFile.exists() )
            return fFile;
        else
            return null;
    }

    private File GetINIFile()
    {
        File fFile = null;
        String sFile = null;
        try
        {
            log.info( "Starting GetINIFIle" );
            sFile = System.getenv( "LOCALAPPDATA" );
            sFile += sConfigDirectory + sConfigFile;
            fFile = new File( sFile );

            if ( !fFile.exists() )
            {
                sFile = System.getenv( "ProgramData" );
                sFile += sConfigDirectory + sConfigFile;
                fFile = new File( sFile );
            }
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
        }
        if ( fFile.exists() )
        {
            log.info( "INIFile: " + sFile );
            return fFile;
        }
        else
        {
            log.warn( "INIFile not found!" );
            return null;
        }
    }

    /**
     * Laduje plik INI i sprawdza czy wymagane pola nie sa puste
     * 
     * @param sINIFile sciezka do pliku INI
     * @return Mapa zawierajaca sekcje z mapami pol
     */
    private Map<String, Map<String, String>> ReadINIFile( ConfigSource configSource, Map<String, Map<String, String>> mmINIFile )
    {
        log.info( "Starting ReadINIFile" );
        String sourcePath = configSource.getSourcePath();
        try
        {
            INIFile oINIFile = null;
            if ( configSource.exists() )
            {
                oINIFile = new INIFile( configSource );
                String[] asSections = oINIFile.getAllSectionNames();
                for ( int i = 0; i < asSections.length; i++ )
                {
                    String asProp[] = oINIFile.getPropertyNames( asSections[i] );
                    Map<String, String> mSection = new LinkedHashMap<String, String>();
                    for ( int j = 0; j < asProp.length; j++ )
                        mSection.put( asProp[j], oINIFile.getStringProperty( asSections[i], asProp[j] ) );
                    mmINIFile.put( asSections[i], mSection );
                    log.trace( asSections[i] + " - " + mSection );
                }

            }
            else
            {
                log.fatal( "!!! Can not find INI file: " + sourcePath + " !!!" );
                // System.exit(1);
            }
        }
        catch ( Exception e )
        {
            log.error( "! ! Error while loading INI file ! !", e );
            // System.exit(2);
        }
        log.info( "*** File " + sourcePath + " loaded ***" );

        return mmINIFile;
    }

    private File WriteINIFile( Map<String, Map<String, String>> mmINIFile )
    {
        log.info( "Starting WriteINIFile" );
        File fFile = null;
        try
        {
            String sFile = null;
            sFile = System.getenv( "LOCALAPPDATA" );
            sFile += sConfigDirectory;
            fFile = new File( sFile );

            if ( !fFile.exists() )
            {
                // if (fFile.canWrite())
                {
                    fFile.mkdir();
                    sFile += sConfigFile;
                    fFile = new File( sFile );
                    // if (fFile.canWrite())
                    {
                        try
                        {
                            fFile.createNewFile();
                        }
                        catch ( IOException e )
                        {
                        	log.error(e.getLocalizedMessage(), e);
                            //e.printStackTrace();
                        }
                        return WriteINIFile( mmINIFile, new FileConfigSource( fFile.getAbsolutePath() ) ) != null ? fFile : null;
                    }
                }
            }
            else
            {
                sFile += sConfigFile;
                fFile = new File( sFile );
                if ( fFile.exists() )
                    return WriteINIFile( mmINIFile, new FileConfigSource( fFile.getAbsolutePath() ) ) != null ? fFile : null;
                else if ( fFile.canWrite() )
                {
                    try
                    {
                        fFile.createNewFile();
                    }
                    catch ( IOException e )
                    {
                    	log.error(e.getLocalizedMessage(), e);
                        //e.printStackTrace();
                    }
                    return WriteINIFile( mmINIFile, new FileConfigSource( fFile.getAbsolutePath() ) ) != null ? fFile : null;
                }
            }

            sFile = System.getenv( "ProgramData" );
            sFile += sConfigDirectory;
            fFile = new File( sFile );

            if ( !fFile.exists() )
            {
                // if (fFile.canWrite())
                {
                    fFile.mkdir();
                    sFile += sConfigFile;
                    fFile = new File( sFile );
                    // if (fFile.canWrite())
                    {
                        try
                        {
                            fFile.createNewFile();
                        }
                        catch ( IOException e )
                        {
                        	log.error(e.getLocalizedMessage(), e);
                            //e.printStackTrace();
                        }
                        return WriteINIFile( mmINIFile, new FileConfigSource( fFile.getAbsolutePath() ) ) != null ? fFile : null;
                    }
                }
            }
            else
            {
                sFile += sConfigFile;
                fFile = new File( sFile );
                if ( fFile.exists() )
                    return WriteINIFile( mmINIFile, new FileConfigSource( fFile.getAbsolutePath() ) ) != null ? fFile : null;
                else if ( fFile.canWrite() )
                {
                    try
                    {
                        fFile.createNewFile();
                    }
                    catch ( IOException e )
                    {
                    	log.error(e.getLocalizedMessage(), e);
                        //e.printStackTrace();
                    }
                    return WriteINIFile( mmINIFile, new FileConfigSource( fFile.getAbsolutePath() ) ) != null ? fFile : null;
                }
            }
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
        }
        return fFile;
    }

    private ConfigSource WriteINIFile( Map<String, Map<String, String>> mmINIFile, ConfigSource configSource )
    {
        log.info( "Write INI File: " + configSource.getSourcePath() );
        try
        {
            if ( configSource.exists() && configSource.canWrite() )
            {
                INIFile oINIFile = new INIFile( configSource );
                Iterator<Map.Entry<String, Map<String, String>>> oIt = mmINIFile.entrySet().iterator();
                while ( oIt.hasNext() )
                {
                    Map.Entry<String, Map<String, String>> oPairs = (Map.Entry<String, Map<String, String>>) oIt.next();
                    String sSection = (String) oPairs.getKey();
                    oINIFile.addSection( sSection, null );
                    Map<String, String> mSection = new LinkedHashMap<String, String>( (LinkedHashMap<String, String>) oPairs.getValue() );
                    Iterator<Map.Entry<String, String>> oIt2 = mSection.entrySet().iterator();
                    while ( oIt2.hasNext() )
                    {
                        Map.Entry<String, String> oPairs2 = (Map.Entry<String, String>) oIt2.next();
                        oINIFile.setStringProperty( sSection, (String) oPairs2.getKey(), (String) oPairs2.getValue(), null );
                    }
                }
                oINIFile.save();
                return configSource;
            }
            else
                return null;
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
            return null;
        }
    }

    // przetwarza katalog i ewentualnie podkatalogi i dodaje pliki do archiwum
    private Map<String, DirectoryShare> CreateDirectoryShares( Map<String, Map<String, String>> mmConfig, TrayIcon trayIcon, boolean bDisplayTrayIcon )
    {
        log.info( "Starting CreateDirectoryShares" );
        Map<String, DirectoryShare> mDirectoryShares = null;
        try
        {
            mDirectoryShares = new LinkedHashMap<String, DirectoryShare>();
            Iterator<Map.Entry<String, Map<String, String>>> oIt = mmConfig.entrySet().iterator();
            DirectoryShare oDir = null;

            // parametr okresliający czy przetwarzanie ma być uruchomione tylko raz, czy też wielkorotnie przy pomocy
            // timerów
            boolean bSetTimer = false;
            if ( ( (String) ( (Map<String, String>) mmINIFile.get( sSettingsKey ) ).get( sProcessOnce ) ).compareToIgnoreCase( sFalse ) == 0 )
            {
                bSetTimer = true;
            }

            while ( oIt.hasNext() )
            {
                Map.Entry<String, Map<String, String>> oPairs = (Map.Entry<String, Map<String, String>>) oIt.next();
                if ( ( (String) oPairs.getKey() ).startsWith( sArchPrefix ) )
                {
                    // sprawdzenie czy ustawiona wlasnosc udzialu Active = true
                    if ( ( (String) ( (Map<String, String>) ( oPairs.getValue() ) ).get( sActive ) ).compareToIgnoreCase( sTrue ) == 0 )
                    {
                        oDir = new DirectoryShare( (Map<String, String>) oPairs.getValue(), sUser, sPassword,
                                                   bDisplayTrayIcon, bSetTimer, bAccessWithWebService,
                                                   nullablePluginContext );
                        // przekazanie ikonki w trey do wyswietalani informacji
                        oDir.setOTrayIcon( trayIcon );
                        if ( ( (String) ( (Map<String, String>) mmConfig.get( sSettingsKey ) ).get( sShowInfoMessages ) ).compareToIgnoreCase( sTrue ) == 0 )
                            oDir.setBShowInfo( true );
                        else
                            oDir.setBShowInfo( false );

                        if ( mDirectoryShares.containsKey( oDir.getSShareId() ) )
                        {
                            throw new DuplicateShareIdException(
                                String.format( "Duplicate ShareID param: %s. Skipping directory: %s", oDir.getSShareId(), oDir.getSSharePath() ) );
                        }

                        mDirectoryShares.put( oDir.getSShareId(), oDir );
                        log.info( "DirectoryShare " + oDir.getSShareId() + " has been initialized" );
                    }
                }
            }
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
        }
        return mDirectoryShares;
    }

    private void ProcessDirectoryShares( Map<String, DirectoryShare> mDirectoryShares )
    {
        log.info( "Starting ProcessDirectoryShares" );
        try
        {
            Iterator<Map.Entry<String, DirectoryShare>> oIt = mDirectoryShares.entrySet().iterator();
            DirectoryShare oDir = null;
            while ( oIt.hasNext() )
            {
                Map.Entry<String, DirectoryShare> oPairs = (Map.Entry<String, DirectoryShare>) oIt.next();
                oDir = (DirectoryShare) oPairs.getValue();
                oDir.ProcessDirectory();
            }
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
        }

    }

    private boolean CheckAndSetLogin(ConfigSource configSource)
    {
        log.info( "Starting CheckAndSetLogin" );
        try
        {
            if (bAccessWithWebService) {
                log.info( "Check with webservice" );
                ArchiveTools oArchTools = new ArchiveTools( nullablePluginContext, true );

                String sKey = "ihwkcnwoa;chowH^";
                byte[] bRawKey = sKey.getBytes();

                // proba logowania z danymi z pliku
                sUser = (String) ((Map<?, ?>) mmINIFile.get(sSettingsKey)).get(sUserProp);
                sPassword = (String) ((Map<?, ?>) mmINIFile.get(sSettingsKey)).get(sPasswordProp);
                // jesli udane logowanie to zaszyfrowanie user i password w pliku
                if (oArchTools.LoginToArchive(sUser, sPassword)) {
                    log.info("Login successful with raw data");
                    String sRawUser = "";
                    sRawUser = DirectoryMonitorTools.Encrypt(sUser, bRawKey);

                    String sRawPassword = "";
                    sRawPassword = DirectoryMonitorTools.Encrypt(sPassword, bRawKey);

                    Map<String, String> mSet = new LinkedHashMap<String, String>((Map<String, String>) mmINIFile.get(sSettingsKey));

                    mSet.put(sUserProp, sRawUser);
                    mSet.put(sPasswordProp, sRawPassword);

                    mmINIFile.put(sSettingsKey, mSet);
                    WriteINIFile(mmINIFile, configSource);
                    return true;
                }

                // w przeciwnym przypadku sprawdzenie czy user i password sa zaszyfrowane
                else {
                    String sTempUser = null;
                    String sTempPassword = null;

                    sTempUser = DirectoryMonitorTools.Decrypt(sUser, bRawKey);
                    sTempPassword = DirectoryMonitorTools.Decrypt(sPassword, bRawKey);

                    // jezeli uda sie zalogowac
                    if (oArchTools.LoginToArchive(sTempUser, sTempPassword)) {
                        log.info("Login succesful with encrypted data");
                        sUser = sTempUser;
                        sPassword = sTempPassword;
                        return true;
                    } else {
                        log.warn("Login unsuccesful");
                        return false;
                    }
                }
            }
            else {
                log.info( "Check with API" );
                UserService us = ServiceFactory.getUserService();

                String sKey = "ihwkcnwoa;chowH^";
                byte[] bRawKey = sKey.getBytes();

                // proba sprawdzenia uzytkownika danymi z pliku
                sUser = (String) ((Map<?, ?>) mmINIFile.get(sSettingsKey)).get(sUserProp);
                
                // jesli udane sprawdzenie to udane "logowanie"
                if ( us.getUser( sUser ) != null) {
                    log.info("User check successful with raw data");
                    return true;
                }

                // w przeciwnym przypadku sprawdzenie czy user jest zaszyfrowany
                else {
                    String sTempUser = null;

                    sTempUser = DirectoryMonitorTools.Decrypt(sUser, bRawKey);

                    // jezeli uda sie sprawdzic
                    if ( us.getUser( sTempUser ) != null ) {
                        log.info("User check succesful with encrypted data");
                        sUser = sTempUser;
                        return true;
                    } else {
                        log.warn("User check unsuccesful");
                        return false;
                    }
                }
            }
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
            return false;
        }
    }

    private void SetWebServiceParam()
    {
        log.info( "Starting SetWebServiceParam" );
        try
        {
            Map<String, String> mWebService = new LinkedHashMap<String, String>( mmINIFile.get( sWebServiceKey ) );
            ArchiveTools.wsdlURL = mWebService.get( sWSDLURL ) + mWebService.get( sServiceName ) + "?wsdl";
            ArchiveTools.wsdlURL2 = mWebService.get( sWSDLURL ) + mWebService.get( sServiceName );
            ArchiveTools.serviceName = mWebService.get( sServiceName );
            ArchiveTools.namespace = mWebService.get( sNamespace );
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
        }
    }

    public static void main( String[] args )
    {
        try
        {
            log.info( "PlusDirectoryMonitor - starting program" );
            // Utworzenie instancji obiektu
            DirectoryMonitor oDirectoryMonitor = new DirectoryMonitor( true );
            // Jezeli podano parametr dotyczacy wyswietlania ikony w traju
            if ( args.length > 1 )
                // Jezeli ma byc wyswietlana ikona w treju to drugi argument "true"
                if ( args[1].compareToIgnoreCase( "true" ) == 0 )
                {
                    log.info( "DisplayTrayIcon = true" );
                    oDirectoryMonitor.startup( args[0], true );
                }
                else
                {
                    log.info( "DisplayTrayIcon = false" );
                    oDirectoryMonitor.startup( args[0], false );
                }
            else if ( args.length > 0 )
            {
                log.info( "INIFile: " + args[0] );
                oDirectoryMonitor.startup( args[0], true );
            }
            else
            {
                log.info( "Nie podano pliku ini" );
                oDirectoryMonitor.startup( (String) null, true );
            }
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
        }
    }

    public void startup (String sIniFilePath)
    {
    	startup(sIniFilePath, false);
    }
    
    public void startup( String sIniFilePath, boolean bDisplayTrayIcon )
    {
        startup( new FileConfigSource( sIniFilePath ), bDisplayTrayIcon );
    }
    
    public void startup( ConfigSource configSource, boolean bDisplayTrayIcon )
    {
        try
        {
        	//ustawienie na timeout webserwisow na 1h
        	System.setProperty("sun.rmi.transport.tcp.responseTimeout", "3600000");
        	System.setProperty("sun.rmi.transport.connectionTimeout", "3600000");
        	System.setProperty("sun.net.client.defaultConnectTimeout", "3600000");
        	System.setProperty("sun.net.client.defaultReadTimeout", "3600000");
        	
            // Wstepna konfigurcja logow
            // BasicConfigurator.configure();

            mmINIFile = new LinkedHashMap<String, Map<String, String>>();
            
            if ( configSource instanceof FileConfigSource )
            {
                // Pobranie pliku konfiguracyjnego
                File fINIFile = null;
                String configSourcePath = configSource.getSourcePath();
                
                // z parametru wywolania
                if ( configSourcePath != null && configSourcePath.length() > 0 )
                {
                    fINIFile = GetINIFile( configSourcePath );
                    if ( fINIFile == null )
                        fINIFile = GetINIFile();
                }
                // lub z systemu
                else
                {
                    fINIFile = GetINIFile();
                }
                
                // jezeli nieudane pobranie to tworzy nowy ze standardowymi ustawieniami
                if ( fINIFile == null )
                {
                    mmINIFile = SetDefaultSetting();
                    
                    fINIFile = WriteINIFile( mmINIFile );
                }
                
                configSource = new FileConfigSource( fINIFile.getAbsolutePath() );
            }

            log.info("***** Strarting PlusDirectoryMonitor *****");

//            Properties oProp = System.getProperties();
//            log.info("Properties:");
//            for (Entry<Object, Object> oEnt : oProp.entrySet() )
//            {
//            	log.info(oEnt.getKey() + " : " + oEnt.getValue());
//            }
            // Odczytanie pliku
            mmINIFile = ReadINIFile( configSource, mmINIFile );

            // Ustawienie parametrow webservice
            // Parametry przypisane do zmiennych statycznych obiektu ArchiveTools dlatego nie mozna na jednej JVM
            // uruchomic poloczen z kilkoma systemami PlusWorkflow
            SetWebServiceParam();

            // Obsluga trayu jesli wspomagany przez system
            if ( SystemTray.isSupported() && bDisplayTrayIcon )
            {
                log.info( "Tray initialization" );
                // System.out.println("TEST3");
                SystemTray tray = SystemTray.getSystemTray();
                URL imageURL = DirectoryMonitor.class.getResource( sMonitorIcon );
                Image image = null;
                if ( imageURL != null )
                { // image found
                    image = ( new ImageIcon( imageURL, "" ).getImage() );
                }
                else
                { // no image found
                  // System.err.println( "Resource not found: " + sMonitorIcon );
                    log.error( "Resource not found: " + sMonitorIcon );
                }

                ActionListener exitListener = new ActionListener()
                {
                    public void actionPerformed( ActionEvent e )
                    {
                        // System.out.println("Exiting...");
                        // System.exit( 0 );
                    }
                };

                ActionListener SettingListener = new ActionListener()
                {
                    public void actionPerformed( ActionEvent e )
                    {
                        SettingWindow();
                    }
                };

                ActionListener actionListener = new ActionListener()
                {
                    public void actionPerformed( ActionEvent e )
                    {
                        ProcessDirectoryShares( mDirectoryShares );
                    }
                };

                PopupMenu popup = new PopupMenu();

                MenuItem ActionItem = new MenuItem( "Wykonaj przetwarzanie" );
                ActionItem.addActionListener( actionListener );
                popup.add( ActionItem );

                MenuItem SettingItem = new MenuItem( "Ustawienia..." );
                SettingItem.addActionListener( SettingListener );
                // popup.add(SettingItem);

                popup.addSeparator();

                MenuItem defaultItem = new MenuItem( "Zakończ" );
                defaultItem.addActionListener( exitListener );
                popup.add( defaultItem );

                trayIcon = new TrayIcon( image, "PlusDirectoryMonitor", popup );
                trayIcon.setImageAutoSize( true );
                trayIcon.addActionListener( actionListener );

                try
                {
                    tray.add( trayIcon );
                }
                catch ( AWTException e )
                {
                    // System.err.println( "TrayIcon could not be added." );
                    log.error( "TrayIcon could not be added.", e );
                }
            }
            else
            {
                if ( !SystemTray.isSupported() )
                    log.warn( "System Tray is not supported" );
                // System.out.println("TEST4");
                // System Tray is not supported
            }
            
            // sprawdzenie czy do przesylania plików do archiwum wykorzystywac API lub wykonywac je webservice'm
            // domyslnie wykorzystywane jest API, gdy aplikacja jest wtyczka
            // jezeli aplikacja dziala jako samodzielna, to wymuszane jest korzystywanie z webservice
            bAccessWithWebService = false;
            if ( bIsStandaloneApp )
            {
                bAccessWithWebService = true;
            }
            else if (((Map<String, String>) mmINIFile.get(sSettingsKey)).containsKey(sAccessWithWebService))
            {
                bAccessWithWebService = ((String) ((Map<String, String>) mmINIFile.get(sSettingsKey))
                                .get(sAccessWithWebService))
                                .compareToIgnoreCase(sTrue) == 0;
            }
            
            // sprawdzenie czy poprawny user i password i ewentualne zaszyfrowanie danych w pliku
            if ( CheckAndSetLogin(configSource) ) {

                // System.out.println("TEST5");
                // Utworzenie i zainicjowanie obiektow zwiazanych z przetwarzaniem klas
                mDirectoryShares = CreateDirectoryShares(mmINIFile, trayIcon, bDisplayTrayIcon);
                // System.out.println("TEST6");
                // przetwarzanie przy starcie programu
                if (((String) ((Map<String, String>) mmINIFile.get(sSettingsKey)).get(sProcessAtStartup)).compareToIgnoreCase(sTrue) == 0)
                    ProcessDirectoryShares(mDirectoryShares);
                // System.out.println("TEST7");
                // Jeżeli ustawione ProcessOnce to kończymy program po ewentualnym jednorazowym przetworzeniu
                // if ( ( (String) ( (Map<String, String>) mmINIFile.get( sSettingsKey ) ).get( sProcessOnce )
                // ).compareToIgnoreCase( sTrue ) == 0 )
                // System.exit( 0 );
            }
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
        }
    }
    
}