package com.plusmpm.directorymonitor;

import com.plusmpm.directorymonitor.ws.ArrayOfString;
import com.plusmpm.directorymonitor.ws.ReleaseService;
import com.plusmpm.directorymonitor.ws.ReleaseServicePortType;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.sun.xml.ws.client.BindingProviderProperties;
import com.suncode.plugin.wrapper.DirectoryMonitorPluginContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.ServiceFactory;
import jakarta.xml.ws.BindingProvider;
import org.apache.log4j.Logger;

import javax.xml.namespace.QName;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class ArchiveTools
{
    private static Logger log = Logger.getLogger( ArchiveTools.class );

    private String sUser;

    public static String wsdlURL = "http://localhost:8080/PlusWorkflow/services/ReleaseService?wsdl";

    public static String wsdlURL2 = "http://localhost:8080/PlusWorkflow/services/ReleaseService";

    public static String namespace = "http://services.plusmpm.com";

    public static String serviceName = "ReleaseService";

    private final DirectoryMonitorPluginContext nullablePluginContext;

    private boolean accessWithWebService;

    private ReleaseServicePortType releaseServicePortType = null;

    public ArchiveTools( DirectoryMonitorPluginContext nullablePluginContext,
                         boolean accessWithWebService )
    {
        this.nullablePluginContext = nullablePluginContext;
        this.accessWithWebService = accessWithWebService;

        if ( accessWithWebService )
        {
            QName serviceQN = new QName( namespace, serviceName );
            try
            {
                doInPluginContextClassLoader( () -> {
                    ReleaseService releaseService = new ReleaseService( new URL( wsdlURL ), serviceQN );
                    this.releaseServicePortType = releaseService.getReleaseServiceHttpPort();

                    BindingProvider bindingProvider = (BindingProvider) this.releaseServicePortType;
                    bindingProvider.getRequestContext().put( BindingProviderProperties.REQUEST_TIMEOUT, 3_600_000 );
                    bindingProvider.getRequestContext().put( BindingProviderProperties.CONNECT_TIMEOUT, 3_600_000 );

                    return null;
                } );
            }
            catch ( Exception e )
            {
                throw new RuntimeException( "Failed to create web service", e );
            }
        }
    }

    public String[] GetClasses()
    {
        try
        {
            return releaseServicePortType.getArchiveDocClass( sUser )
                .getString()
                .toArray( new String[0] );
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
            // System.out.println( e.getLocalizedMessage() );
            // e.printStackTrace();
            return null;
        }
    }

    public String[] GetIndexes( String sClass )
    {
        try
        {
            return releaseServicePortType.getArchiveDocClassIndecies( sUser, sClass )
                .getString()
                .toArray( new String[0] );
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
            // System.out.println( e.getLocalizedMessage() );
            // e.printStackTrace();
            return null;
        }
    }

    public boolean IfFileExist( String sClass, Map<String, String> mIndexesValue )
    {

        if ( sClass.compareToIgnoreCase( "Klasa 1" ) == 0 )
        {
            if ( mIndexesValue.get( "Index 1" ).compareToIgnoreCase( "1.tif" ) == 0 )
                return true;
        }
        else if ( sClass.compareToIgnoreCase( "Klasa 2" ) == 0 )
        {
            if ( mIndexesValue.get( "Index 1" ).compareToIgnoreCase( "1.tif" ) == 0 )
                return true;
        }
        return false;
    }

    public boolean LoginToArchive( String sUser, String sPassword )
    {
        try
        {
            if ( accessWithWebService )
            {
                log.info("LoginToArchive with webservices: " + wsdlURL + " 2: " + wsdlURL2);

                boolean bResult = releaseServicePortType.loginInSystem( sUser, sPassword );

                if ( bResult )
                {
                    this.sUser = sUser;
                }
                else
                {
                    this.sUser = null;
                }
                return bResult;
            }
            else
            {
                log.info( "LoginToArchive with API" );
                
                UserService us = ServiceFactory.getUserService();
                
                if ( us.getUser( sUser ) != null )
                {
                    this.sUser = sUser;
                    return true;
                }
                else
                {
                    this.sUser = null;
                    return false;
                }
            }
        }
        catch ( Exception e )
        {
            // log.error( e.getLocalizedMessage(), e );
            log.error( "Nieudane logowanie do systemu na użytkownika: " + sUser, e );
            // System.out.println( e.getLocalizedMessage() );
            // e.printStackTrace();
            this.sUser = null;
            return false;
        }
    }

    public int AddFileToArchiveApi(String sClass, String[] asIndexes, File fFile, String sSaveAsNewVersion)
    {
        try (FileInputStream oFileStream = new FileInputStream(fFile)) {
            log.info("AddFileToArchiveApi");
            log.info("Klasa: " + sClass + " User: " + sUser + " SaveAsNewVersion: " + sSaveAsNewVersion + " File: " + fFile.getName());
            if (sSaveAsNewVersion == null)
                sSaveAsNewVersion = "false";

            Boolean bSaveAsNewVersion = Boolean.parseBoolean(sSaveAsNewVersion);
            DocumentService documentService = ServiceFactory.getDocumentService();
            long nClassID = Long.parseLong(sClass);

            Map<Long, Object> idx = new HashMap<Long, Object>();
            for (String sIndex : asIndexes) {
                int separatorIndex = sIndex.indexOf(";");

                if (separatorIndex != -1)
                {
                    long nIndexId = Long.parseLong(sIndex.substring(0, separatorIndex));
                    String sIndexValue = sIndex.substring(separatorIndex + 1);

                    idx.put(nIndexId, sIndexValue);
                }
                else
                {
                    idx.put(Long.parseLong(sIndex), "");
                }
            }
            DocumentDefinition definition = new DocumentDefinition();
            definition.setDocumentClassId(nClassID);
            definition.setFileName(fFile.getName());
            definition.setUserName(sUser);
            definition.setIndexes(idx);
            definition.setInputStream(oFileStream);
            definition.setSaveAsNewVersion(bSaveAsNewVersion);
            definition.setExactIndexesCheck( false );

            if ( nullablePluginContext != null )
            {
                nullablePluginContext.getDocumentUploadListenerRegistry()
                    .getDocumentUploadListener()
                    .ifPresent( documentUploadListener -> {
                        log.info( "Wywoływanie modułu listenera na wysyłany dokument" );
                        documentUploadListener.onDocumentUpload( definition );
                    } );
            }

            log.info("Dodawanie dokumentu");

            AddDocumentResultMeta oMetaResult = documentService.addDocumentWithMetaResult(definition);
            WfDocument oWfDocument = oMetaResult.getDocument();
            bSaveAsNewVersion = oMetaResult.getSavedAsNewVersion();

            if (oWfDocument != null) {
                log.info("Udane dodawanie dokumentu " + (bSaveAsNewVersion ? "jako nowa wersja" : "jako nowy dokument"));
            }
            else {
                log.error("Błąd przy dodawaniu dokumentu");
                return -1;
            }

            DocumentClassActionService documentClassActionService = ServiceFactory.getDocumentClassActionService();
            try {
                documentClassActionService.executeArchiveActions(oWfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE, bSaveAsNewVersion);
            }
            catch ( Exception e ) {
                try
                {
                    documentService.deleteDocument(oWfDocument);
                }
                catch ( Exception suppressing )
                {
                    suppressing.addSuppressed( e );
                    log.error( "Wystąpił błąd przy usuwaniu pliku po błędnym wywołaniu akcji na klasie dokumentów", suppressing );
                    throw suppressing;
                }
                throw e;
            }

            return 0;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), e);
            return -1;
        }
    }

    public int AddFileToArchive( String sClass, String[] asIndexes, File fFile, String sSaveAsNewVersion )
    {
        if ( accessWithWebService )
        {
            return AddFileToArchiveWS( sClass, asIndexes, fFile, sSaveAsNewVersion );
        }
        else
        {
            return AddFileToArchiveApi( sClass, asIndexes, fFile, sSaveAsNewVersion );
        }
    }

    public int AddFileToArchiveWS( String sClass, String[] asIndexes, File fFile, final String sSaveAsNewVersion )
    {
        Integer nResult = -1;
        try
        {
            String sFile = fFile.getName();

            // zamiana apostrofow w nazwia pliku
            sFile = sFile.replace( "'", "_" );
            // Long nSize = fFile.getTotalSpace();
            // String sSize = nSize.toString();

            FileInputStream inStream = new FileInputStream( fFile );
            Long nStreamSize = (long) inStream.available();
            String sSize = nStreamSize.toString();

            byte aFile[] = new byte[nStreamSize.intValue()];
            for ( int i = 0; i < nStreamSize; i++ )
            {
                aFile[i] = (byte) inStream.read();
            }
            inStream.close();
            // System.out.println( "Invoke SaveDocumentInArchive: User=" + sUser + "; Class=" + sClass + "; File=" +
            // sFile + "; sSize=" + sSize + ";" );
            log.info( "Invoke SaveDocumentInArchive: User=" + sUser + "; Class=" + sClass + "; File=" + sFile + "; sSize=" + sSize + ";" );

            Integer nFileId = releaseServicePortType.saveDocumentInArchive( sUser, sClass, sFile, sSize, null, null, null, aFile );

            // jezeli udalo sie zapisac to dodjemy indeksy
            if ( nFileId > 0 )
            {
                // System.out.println( "******** sUser: " + sUser + " sClass: " + sClass + " FileId: " +
                // nFileId.toString() );
                // jezeli nie podano czy zapisac jako nowa wersje lub jest ustawiona inna wartosc niz true to ustawiamy
                // na false
                boolean saveAsNewVersion = true;
                if ( sSaveAsNewVersion == null || sSaveAsNewVersion.compareToIgnoreCase( "true" ) != 0 )
                {
                    saveAsNewVersion = false;
                }
                log.info( "******** sUser: " + sUser + " sClass: " + sClass + " FileId: " + nFileId + " NewVersion: " + saveAsNewVersion );
                for ( int i = 0; i < asIndexes.length; i++ )
                {
                    // System.out.println( asIndexes[i] );
                    log.info( asIndexes[i] );
                }

                ArrayOfString indexes = new ArrayOfString();
                indexes.getString().addAll( Arrays.asList( asIndexes ) );

                nResult = releaseServicePortType.saveIndeciesInArchive1( sUser, sClass, nFileId.toString(), indexes, saveAsNewVersion );
            }
            return nResult;
        }
        catch ( Exception e )
        {
            log.error( e.getLocalizedMessage(), e );
            // System.out.println( e.getLocalizedMessage() );
            // e.printStackTrace();
        }
        return -1;
    }

    /*
    Metoda jakarta.xml.ws.spi.ServiceLoaderUtil.firstByServiceLoader próbuje znaleźć implementacje
    interfejsu jakarta.xml.ws.spi.Provider, lecz czyta ją kontekstowym classloaderem (czyli systemowym).

    Należy użyć wtyczkowego classloadera, by implementacja została prawidłowo wykryta.
     */
    private <T> T doInPluginContextClassLoader( Callable<T> supplier )
        throws Exception
    {
        ClassLoader prevContextClassLoader = Thread.currentThread().getContextClassLoader();

        try {
            Thread.currentThread().setContextClassLoader( this.getClass().getClassLoader() );
            return supplier.call();
        }
        finally
        {
            Thread.currentThread().setContextClassLoader( prevContextClassLoader );
        }
    }

}