package com.plusmpm.directorymonitor.module;

import com.plusmpm.directorymonitor.document.DocumentUploadListenerRegistry;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.support.module.ModuleHelper;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class DirectoryMonitorRegisterModule
    extends ModuleSupport<Void>
{

    private String documentUploadListenerClassName;

    @Autowired
    private DocumentUploadListenerRegistry documentUploadListenerRegistry;

    @Override
    protected void initModule()
        throws PluginsException
    {
        ModuleDefinition definition = getDefinition();
        documentUploadListenerClassName = ModuleHelper.getAttribute( "document-upload-listener", definition, true );
    }

    @Override
    public void enable()
        throws PluginsException
    {
        Plugin plugin = getPlugin();
        ModuleDefinition definition = getDefinition();

        if ( documentUploadListenerClassName != null )
        {
            DocumentUploadListener documentUploadListener = instantiateImplementation(
                DocumentUploadListener.class, documentUploadListenerClassName
            );

            documentUploadListenerRegistry.registerListener( plugin.getKey(), definition.getKey(), documentUploadListener );
        }
    }

    @Override
    public void disable()
        throws PluginsException
    {
        Plugin plugin = getPlugin();
        ModuleDefinition definition = getDefinition();

        if ( documentUploadListenerClassName != null )
        {
            documentUploadListenerRegistry.unregisterListener( plugin.getKey(), definition.getKey() );
        }
    }

    @SuppressWarnings( "unchecked" )
    private <T> T instantiateImplementation( Class<T> targetClass, String implClassName )
        throws PluginsException
    {
        if ( StringUtils.isEmpty( implClassName ) )
        {
            return null;
        }

        try
        {
            Class<?> clazz = getPlugin().getClassLoader().loadClass( implClassName );
            if ( !targetClass.isAssignableFrom( clazz ) )
            {
                throw new PluginsException( "Class " + implClassName + " must implement " + clazz.getName() + " interface" );
            }

            return (T) getPlugin().getContext().getAutowireCapableBeanFactory()
                .createBean( clazz );
        }
        catch ( ClassNotFoundException ex )
        {
            throw new PluginsException( "Can't load class: " + implClassName, ex );
        }
    }

}
