package com.plusmpm.directorymonitor;

import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

import com.plusmpm.ini.INIFile;

public class Index // extends DefaultHandler
{
	private static Logger log = Logger.getLogger( Index.class );

	protected String sIndexId;

	protected String sName;

	protected String sType;

	protected boolean bAllowEmpty;

	// typy indeksow
	protected static String sPATH_SEGMENT = "PathSegment";

	protected static String sFILE_SEGMENT = "FileSegment";

	protected static String sDATE = "Date";

	protected static String sFILE_DATE = "FileDate";

	protected static String sSTRING = "ConstantString";

	protected static String sFILE_NAME = "FileName";

	protected static String sEXTENTION = "Extention";

	protected static String sFILE_NAME_WITH_EXTENSION = "FileNameWithExtension";

	protected static String sVOID = "Void";

	protected static String sSQL = "SQL";

	protected static String sINI = "INI";

	/**
	 * Rodzaj indeksu, ktory pobiera informacje z kodow 2D.
	 */
	protected static String sBarcode2D = "Barcode2D";

	protected static String sINI_File = "INIFile";

	protected static String sXML_FILE = "XMLFile";

	protected File fFile;

	protected File fXMLFile;

	// ConstantString
	protected String sIndexString;

	// parametry opcjonalne
	protected int nPathSegment;

	protected int nFileSegment;

	protected String sRegExp;

	protected String sFileSeparator;

	protected String sMask;

	protected String sSQLName;

	protected String sSQLScheme;

	protected String sEncoding;

	protected String sDecoding;
	
	protected String sMustBeEqual;

	/**
	 * Pelna sciezka do katalogu, w ktorym znajduja sie pliki xml, zawierajace informacje o kodach 2D w odpowiadajacych
	 * im plikach.
	 */
	protected String sBarcode_XML_Path;

	/**
	 * Numer kodu 2D z pliku xml. Kody sa numerowane w od 1, od lewego gornego naroznika strony. Jezeli nie podano
	 * numeru, to zostanie ustawiony na 1.
	 */
	protected String sBarcode_Nr;

	/**
	 * Jezeli jest true, to pliki xml beda usuwane po przetwarzaniu.
	 */
	protected String sBarcode_XML_FileDelete;

	/**
	 * Jezeli jest true, to pliki xml beda kopiowane po przetwarzaniu do katalogu wskazanego w XMLBackupPath.
	 */
	protected String sBarcode_XML_FileBackup;

	/**
	 * Pelna sciezka do katalogu, w ktorym beda umieszczane kopie przetworzonych plikow xml.
	 */
	protected String sBarcode_XML_BackupPath;

	// Sciezka do tagu, lacznie z ograniczeniami na atrybutech, ktory wskazuje na tag wartosci indeksu
	protected String sXMLValueTag;

	// Ścieżka do tagu służąca jako wyznacznik pustych wartości dla sXMLValueTag,
	// gdy wybrany jest MultiValue
	protected String sXMLValueDelimiterTag;

	// Domyślna wartość dla pustych wartości sXMLValueTag wyznaczonych przez sXMLValueDelimiterTag
	// gdy wybrany jest MultiValue
	protected String sXMLDefaultDelimitedValue;

	// Nazwa atrybutu z ktorego pobierana jest wartosc indeksu - parametr opcjonalny
	protected String sXMLValueAttribute;

	// Czy ma nastąpić ignorowanie przestrzeni nazw przy odczycie wartości z pliku XML
	protected String sXMLValueIgnoreNamespaces;

	// Zmienna określa czy wartosc indeksu moze przyjmowac wiele wartosci (zmienna tabelaryczna) czy tylko jedna
	protected boolean bMultiValue;

	// Nazwa sekcji w pliku INI w której znajduje sie parametr do pobrania do wartosci indeksu
	protected String sINISection;

	// Nazwa parametru w pliku INI zawierajacego wartosc parametru
	protected String sINIParameter;

	// //parametry DB
	// protected String sSQLStatement;
	// protected String sDBUser;
	// protected String sDBPassword;
	// protected String sDBURL;
	// protected String sJDBCDriver;

	// Wartosc indeksu postaci 'nr indeksu;wartosc'
	protected String sIndexValue;

	// Wartosc indeksu bez numeru indeksu
	protected String sIndexValue2;

	// wartosc indeksu okreslona z bazy danych (ustawiana zewnetrzne)
	protected String sIndexSQLValue;
	
	protected Boolean bIndexEqual = true;
	// Wartosci pozostalych indeksow potrzebne w przypadku odwolania w zapytaniu sql
	// protected Vector vIndexes;

	// // Zmienna okreslajacy czy obecnie odczytywany xml to plik xml (wartosc true) czy tez wartosc ze string
	// sXMLValueTag (wartosc false)
	// private boolean bReadingXMLFile;
	//
	// //Mapa zawierająca tagi xmla. Dla kazdegu tagu przechowywana jest mapa jego atrybutów
	// private LinkedHashMap <String,Map<String,String>> mXMLValueTag = new LinkedHashMap <String,Map<String,String>>();
	//
	// Iterator<Map.Entry<String,Map<String,String>>> oXMLValueTagIterator;
	//
	// Map.Entry<String, Map<String,String>> oCurrentTag;
	// Map.Entry<String, Map<String,String>> oPreviousTag;
	//
	// //Zmienna okreslajaca czy pobrac wartosc przez funkcje characters i przypisac do zmiennej sIndexValue
	// boolean bGetXMLElement;

	public String getSType()
	{
		return sType;
	}

	public void setSType( String type )
	{
		sType = type;
	}

	public int getNPathSegment()
	{
		return nPathSegment;
	}

	public void setNPathSegment( int pathSegment )
	{
		nPathSegment = pathSegment;
	}

	public int getNFileSegment()
	{
		return nFileSegment;
	}

	public void setNFileSegment( int fileSegment )
	{
		nFileSegment = fileSegment;
	}

	public String getSFileSeparator()
	{
		return sFileSeparator;
	}

	public void setSFileSeparator( String fileSeparator )
	{
		sFileSeparator = fileSeparator;
	}

	public String getSMask()
	{
		return sMask;
	}

	public void setSMask( String mask )
	{
		sMask = mask;
	}

	static public String decodeJavaUTF8String( String sText )
	{
		sText = sText.replaceAll( "[/][2][6][1]", "ą" );
		sText = sText.replaceAll( "[/][2][6][3]", "ć" );
		sText = sText.replaceAll( "[/][2][8][1]", "ę" );
		sText = sText.replaceAll( "[/][3][2][2]", "ł" );
		sText = sText.replaceAll( "[/][3][2][4]", "ń" );
		sText = sText.replaceAll( "[/][2][4][3]", "ó" );
		sText = sText.replaceAll( "[/][3][4][7]", "ś" );
		sText = sText.replaceAll( "[/][3][7][8]", "ź" );
		sText = sText.replaceAll( "[/][3][8][0]", "ż" );
		sText = sText.replaceAll( "[/][2][6][0]", "Ą" );
		sText = sText.replaceAll( "[/][2][6][2]", "Ć" );
		sText = sText.replaceAll( "[/][2][8][0]", "Ę" );
		sText = sText.replaceAll( "[/][3][2][1]", "Ł" );
		sText = sText.replaceAll( "[/][3][2][3]", "Ń" );
		sText = sText.replaceAll( "[/][2][1][1]", "Ó" );
		sText = sText.replaceAll( "[/][3][4][6]", "Ś" );
		sText = sText.replaceAll( "[/][3][7][7]", "Ź" );
		sText = sText.replaceAll( "[/][3][7][9]", "Ż" );

		return sText;
	}

	static public String encodeJavaUTF8String( String sText )
	{
		sText = sText.replaceAll( "ą", "/261" );
		sText = sText.replaceAll( "ć", "/263" );
		sText = sText.replaceAll( "ę", "/281" );
		sText = sText.replaceAll( "ł", "/322" );
		sText = sText.replaceAll( "ń", "/324" );
		sText = sText.replaceAll( "ó", "/243" );
		sText = sText.replaceAll( "ś", "/347" );
		sText = sText.replaceAll( "ź", "/378" );
		sText = sText.replaceAll( "ż", "/380" );
		sText = sText.replaceAll( "Ą", "/260" );
		sText = sText.replaceAll( "Ć", "/262" );
		sText = sText.replaceAll( "Ę", "/280" );
		sText = sText.replaceAll( "Ł", "/321" );
		sText = sText.replaceAll( "Ń", "/323" );
		sText = sText.replaceAll( "Ó", "/211" );
		sText = sText.replaceAll( "Ś", "/346" );
		sText = sText.replaceAll( "Ź", "/377" );
		sText = sText.replaceAll( "Ż", "/379" );

		return sText;
	}

	/**
	 * Laduje plik INI i sprawdza czy wymagane pola nie sa puste
	 * 
	 * @param sINIFile sciezka do pliku INI
	 * @return Mapa zawierajaca sekcje z mapami pol
	 */
	private Map ReadINIFile( String sINIFile, Map mmINIFile )
	{
		log.info( "*** Loading INI File ***" );
		// Map mmINIFile = new HashMap();
		try
		{
			File f = new File( sINIFile );
			INIFile oINIFile = null;
			if ( f.exists() )
			{
				oINIFile = new INIFile( sINIFile );

				String[] asSections = oINIFile.getAllSectionNames();
				for ( int i = 0; i < asSections.length; i++ )
				{
					String asProp[] = oINIFile.getPropertyNames( asSections[i] );
					Map mSection = new LinkedHashMap();
					for ( int j = 0; j < asProp.length; j++ )
						mSection.put( asProp[j], oINIFile.getStringProperty( asSections[i], asProp[j] ) );
					mmINIFile.put( asSections[i], mSection );
				}
			}
			else
			{
				log.error( "!!! Can not find INI file: " + sINIFile + " !!!" );
				// System.exit(1);
			}
		}
		catch ( Exception e )
		{
			log.error( "! ! Error while loading INI file ! !" );
			log.error( e.getLocalizedMessage(), e );
			// System.exit(2);
		}
		log.info( "*** File " + sINIFile + " loaded ***" );
		return mmINIFile;
	}

	/**
	 * KROTKI OPIS...
	 * 
	 * @author Maciej Kucharski 2009-03-27
	 */
	public void SetIndexValue()
	{
		try
		{
			sIndexValue = "";
			if ( sType != null )
			{
				if ( fFile != null && sType.compareToIgnoreCase( sPATH_SEGMENT ) == 0 )
				{
					String sFile = fFile.getAbsolutePath();
					String asFileMembers[] = sFile.split( "\\".concat( File.separator ) );
					// nPathSegment numerowany od 1!
					if ( nPathSegment > 0 && nPathSegment <= asFileMembers.length - 1 )
						sIndexValue = asFileMembers[nPathSegment - 1];
				}
				else if ( fFile != null && sType.compareToIgnoreCase( sFILE_SEGMENT ) == 0 )
				{
					// pominiecie rozszezenia pliku
					String sTemp = fFile.getName();
					String asTemp[] = sTemp.split( "\\." );
					String sFile = "";
					for ( int i = 0; i < asTemp.length - 1; i++ )
					{
						sFile += asTemp[i];
					}

					String asFileMembers[] = sFile.split( sFileSeparator );
					// nPathSegment numerowany od 1!
					if ( nFileSegment > 0 && nFileSegment <= asFileMembers.length )
						sIndexValue = asFileMembers[nFileSegment - 1];
				}
				else if ( sType.compareToIgnoreCase( sDATE ) == 0 )
				{
					Calendar oNow = Calendar.getInstance();
					Date oDate = new Date();
					oNow.setTime( oDate );
					String sMonth;
					String sDate;
					String sYear;

					if ( oNow.get( oNow.DATE ) < 10 )
						sDate = "0" + oNow.get( oNow.DATE );
					else
						sDate = "" + oNow.get( oNow.DATE );

					/* Miesiace numerowane od 0! */
					int nMonth = oNow.get( oNow.MONTH ) + 1;
					if ( nMonth < 10 )
						sMonth = "0" + nMonth;
					else
						sMonth = "" + nMonth;

					sYear = "" + oNow.get( oNow.YEAR );
					sYear = sYear.substring( 2 );

					sIndexValue = sYear + "/" + sMonth + "/" + sDate;
				}
				else if ( fFile != null && sType.compareToIgnoreCase( sFILE_DATE ) == 0 )
				{
					Date oDate = new Date( fFile.lastModified() );
					// rok od 1900 i miesiac od 0!
					sIndexValue = ( (int) oDate.getYear() + 1900 ) + "/" + ( (int) oDate.getMonth() + 1 ) + "/" + oDate.getDate();
				}
				else if ( sType.compareToIgnoreCase( sSTRING ) == 0 )
				{
					sIndexValue = sIndexString;
				}
				else if ( fFile != null && sType.compareToIgnoreCase( sFILE_NAME ) == 0 )
				{
					String sTemp = fFile.getName();
					String asTemp[] = sTemp.split( "\\." );
					sIndexValue = "";
					for ( int i = 0; i < asTemp.length - 1; i++ )
					{
						sIndexValue += asTemp[i] + ".";						
					}
					sIndexValue = sIndexValue.substring(0, sIndexValue.length()-1);
				}
				else if ( fFile != null && sType.compareToIgnoreCase( sEXTENTION ) == 0 )
				{
					String sTemp = fFile.getName();
					String asTemp[] = sTemp.split( "\\." );
					if ( asTemp.length > 1 )
						sIndexValue = asTemp[asTemp.length - 1];
					else
						sIndexValue = "";
				}
				else if ( fFile != null && sType.compareToIgnoreCase( sFILE_NAME_WITH_EXTENSION ) == 0 )
				{
					sIndexValue = fFile.getName();
				}
				else if ( sType.compareToIgnoreCase( sVOID ) == 0 )
				{
					sIndexValue = "";
				}

				else if ( sType.compareToIgnoreCase( sBarcode2D ) == 0 )
				{
					// sXML_Path - pelna sciezka do katalogu z plikami xml opisujacymi kody 2D
					// sBarcode_Nr - numer kodu na stronie, od 1 do ilosci kodow
					// fFile - przetwarzany plik

					// jezeli podana sciezka nie konczy sie separatorem to go dodaje
					if ( sBarcode_XML_Path.endsWith( File.separator ) == false )
						sBarcode_XML_Path = sBarcode_XML_Path.concat( File.separator );

					// jezeli nie podano ktory kod to bedzie pobrany pierwszy
					if ( sBarcode_Nr == null || Integer.parseInt( sBarcode_Nr ) < 1 )
						sBarcode_Nr = "1";

					// zamieniam numer kodu 2D na Integer
					Integer nBarcode_Nr = Integer.parseInt( sBarcode_Nr );

					// wyciagam nazwe przetwarzanego pliku bez rozszerzenia
					String sFileName = fFile.getName();
					sFileName = sFileName.substring( 0, sFileName.length() - 3 );

					// obiekt reprezentujacy plik xml z informacjami o kodach 2D
					File fBarcodeXMLFile = new File( sBarcode_XML_Path.concat( sFileName.concat( "xml" ) ) );

					if ( fBarcodeXMLFile.exists() == true )
					{
						try
						{
							XMLDecoder xmlDecoder =
									new XMLDecoder( new BufferedInputStream( new FileInputStream( fBarcodeXMLFile.getAbsolutePath() ) ) );
							Object codesMapObject = xmlDecoder.readObject();

							if ( codesMapObject instanceof Map<?, ?> )
							{
								@SuppressWarnings( "unchecked" )
								Map<Integer, String> codesMap = (Map<Integer, String>) codesMapObject;
								if ( codesMap.containsKey( nBarcode_Nr ) )
									sIndexValue = codesMap.get( nBarcode_Nr );
							}

							// backup pliku xml po przetworzeniu
							if ( this.sBarcode_XML_FileBackup.compareToIgnoreCase( "true" ) == 0 )
							{
								FileChannel in = null;
								FileChannel out = null;
								ByteBuffer byteBuffer = null;

								try
								{
									File fXMLBackupDir = new File( this.sBarcode_XML_BackupPath );

									if ( fXMLBackupDir.exists() == true && fXMLBackupDir.isDirectory() == true )
									{
										File fXMLBackupFile =
												new File( fXMLBackupDir.getAbsolutePath().concat( File.separator ).concat( fBarcodeXMLFile.getName() ) );

										in = new FileInputStream( fBarcodeXMLFile.getAbsolutePath() ).getChannel();
										out = new FileOutputStream( fXMLBackupFile.getAbsolutePath() ).getChannel();

										byteBuffer = ByteBuffer.allocate( 1024 );
										while ( in.read( byteBuffer ) != -1 )
										{
											byteBuffer.flip();
											out.write( byteBuffer );
											byteBuffer.clear();
										}
									}
								}

								catch ( Exception e )
								{
									log.error(e.getLocalizedMessage(), e);
									//e.printStackTrace( System.out );
									throw e;
								}
								finally
								{
									if ( in != null )
										in.close();

									if ( out != null )
										out.close();
								}
							}

							// usuniecie pliku xml po przetworzeniu
							if ( this.sBarcode_XML_FileDelete.compareToIgnoreCase( "true" ) == 0 )
							{
								try
								{
									fBarcodeXMLFile.delete();
								}
								catch ( Exception e )
								{
									log.error(e.getLocalizedMessage(), e);
									//e.printStackTrace( System.out );
									throw e;
								}
							}
						}
						catch ( Exception e )
						{
							//e.printStackTrace( System.out );
							log.error(e.getLocalizedMessage(), e);
						}
					}
				}

				else if ( fFile != null && sType.compareToIgnoreCase( sINI_File ) == 0 )
				{
					log.info( "Typ indeksu: INI" );
					String sFilePath = fFile.getAbsolutePath();
					sFilePath += fFile.getName();
					String sINIFile = "";
					String asTemp[] = sFilePath.split( "\\." );
					for ( int i = 0; i < asTemp.length - 1; i++ )
					{
						sINIFile += asTemp[i];
					}
					sINIFile += "\\.txt";
					Map mmINIFile = null;
					mmINIFile = ReadINIFile( sINIFile, mmINIFile );
					Map mIndex = new LinkedHashMap();
					mIndex = (LinkedHashMap) mmINIFile.get( "wlasnosci" );
					sIndexValue = (String) mIndex.get( sIndexId );
				}

				else if ( sType.compareToIgnoreCase( sSQL ) == 0 )
				{
					// w przypadku zapytania wartosc ustawiania przez DirectoryShare
					sIndexValue = sIndexValue2;
				}
				// Obsługa dla indeksow z pliku xml
				else if ( sType.compareToIgnoreCase( sXML_FILE ) == 0 )
				{
					log.trace( "Plik xml: " + fXMLFile.getAbsolutePath() + " Tag: " + sXMLValueTag + " Attribute: " + sXMLValueAttribute );

					Vector<String> xmlValuesCandidates = getIndexValueCandidatesFromXmlFile();
					if ( !xmlValuesCandidates.isEmpty() )
					{
						sIndexValue = xmlValuesCandidates.get( 0 );
					}
					else
					{
						sIndexValue = "";
					}

					// jesli nie podano RegExp dopasowanie wszystkiego
					if ( sRegExp == null || sRegExp.compareToIgnoreCase( "" ) == 0 )
						sRegExp = "(.*)(?:.*)";

					log.trace("MultiValue RegExp: " + sRegExp);
					log.trace("PartIndexValue: " + sIndexValue);
					// dopasowanie wyrazenia regularnego
					Pattern myPattern = Pattern.compile( sRegExp, Pattern.CANON_EQ | Pattern.DOTALL);
					Matcher myMatcher = myPattern.matcher( sIndexValue );
					// jezeli znalazl dopasowanie
					if ( myMatcher.find() )
					{
						if ( myMatcher.groupCount() > 0 )
							sIndexValue = myMatcher.group( 1 );
						else
							sIndexValue = myMatcher.group();
					}
					else
						sIndexValue = "";

					// Dopasowanie maski
					if ( sMask != null && sRegExp.compareToIgnoreCase( "" ) != 0 )
						sIndexValue = myMatcher.replaceAll( sMask );

					if ( bMultiValue )
					{
						for ( int i = 1; i < xmlValuesCandidates.size(); i++ )
						{
							String sTempValue = xmlValuesCandidates.get(i);
							log.trace("PartIndexValue: " + sTempValue);
							myPattern = Pattern.compile( sRegExp, Pattern.CANON_EQ | Pattern.DOTALL);
							myMatcher = myPattern.matcher( sTempValue);
							// jezeli znalazl dopasowanie
							if ( myMatcher.find() )
							{
								if ( myMatcher.groupCount() > 0 )
									sTempValue = myMatcher.group( 1 );
								else
									sTempValue = myMatcher.group();
							}
							else
								sTempValue = "";

							// Dopasowanie maski
							if ( sMask != null && sRegExp.compareToIgnoreCase( "" ) != 0 )
								sTempValue = myMatcher.replaceAll( sMask );


							sIndexValue += ";" + sTempValue;
						}
					}
					log.trace("sIndexValue after RegExp: " + sIndexValue);
					// sIndexValue = "";
					//
					// //Ustawienie XMLReader
					// XMLReader oXMLReader = XMLReaderFactory.createXMLReader();
					// oXMLReader.setContentHandler(this);
					//
					// //odczyt formatu xml ze zmiennej sXMLValueTag
					// bReadingXMLFile = false;
					// oXMLReader.parse(new InputSource(sXMLValueTag));
					//
					// //Odczyt z plik xml
					// bReadingXMLFile = true;
					// bGetXMLElement = false;
					// oXMLValueTagIterator = mXMLValueTag.entrySet().iterator();
					// oCurrentTag = oXMLValueTagIterator.next();
					// oPreviousTag = null;
					//
					// FileReader oFileReader = new FileReader(fXMLFile);
					// oXMLReader.parse(new InputSource(oFileReader));
				}

				// przekodowanie znakow
				log.trace( "Encoding: " + sEncoding + " Decoding: " + sDecoding );
				if ( sEncoding != null && !sEncoding.isEmpty() && sDecoding != null && !sDecoding.isEmpty() )
				{
					Charset charsetEncoding = Charset.forName( sEncoding );
					Charset charsetDecoding = Charset.forName( sDecoding );
					CharsetDecoder decoder = charsetDecoding.newDecoder();
					CharsetEncoder encoder = charsetEncoding.newEncoder();
					try
					{
						// Convert a string to ISO-LATIN-1 bytes in a ByteBuffer
						// The new ByteBuffer is ready to be read.
						ByteBuffer bbuf = encoder.encode( CharBuffer.wrap( sIndexValue ) );

						// Convert ISO-LATIN-1 bytes in a ByteBuffer to a character ByteBuffer and then to a string.
						// The new ByteBuffer is ready to be read.
						CharBuffer cbuf = decoder.decode( bbuf );
						sIndexValue = cbuf.toString();
					}
					catch ( Exception e )
					{
						log.error( e.getLocalizedMessage(), e );
					}
					log.trace( "Decoding: " + sDecoding + " Value: " + sIndexValue );
				}

				//dopasowanie wyrazenia regularnego
				if (!sType.equalsIgnoreCase(sXML_FILE))
				{
					// jesli nie podano RegExp dopasowanie wszystkiego
					if ( sRegExp == null || sRegExp.compareToIgnoreCase( "" ) == 0 )
						sRegExp = "(.*)(?:.*)";

					// dopasowanie wyrazenia regularnego
					log.trace("RegExp: " + sRegExp + " sIndexValue: " + sIndexValue);
					Pattern myPattern = Pattern.compile( sRegExp, Pattern.CANON_EQ | Pattern.DOTALL);
					Matcher myMatcher = myPattern.matcher( sIndexValue );
					// jezeli znalazl dopasowanie
					if ( myMatcher.find() )
					{
						if ( myMatcher.groupCount() > 0 )
							sIndexValue = myMatcher.group( 1 );
						else
							sIndexValue = myMatcher.group();
					}
					else
						sIndexValue = "";

					// Dopasowanie maski
					if ( sMask != null && sRegExp.compareToIgnoreCase( "" ) != 0 )
						sIndexValue = myMatcher.replaceAll( sMask );
					log.trace("sIndexValue after RegExp: " + sIndexValue);
				}
				// System.out.println("Przed zamiana: " + sIndexValue);
				
				//Sprawdzenie czy wartosc indeksu nie jest rowna IndexMustBeEqual
				if (sMustBeEqual != null && !sMustBeEqual.isEmpty() && !sMustBeEqual.equalsIgnoreCase(sIndexValue))
				{
					log.info("Index: " + sIndexValue + " nie pasuje do wymaganej wartosci: " + sMustBeEqual + " Plik pomijany.");
					bIndexEqual = false;
				}
				// podmiana apostrofow
				sIndexValue = sIndexValue.replace( "'", "_" );

				// System.out.println("Po zamianie: " + sIndexValue);

				sIndexValue2 = sIndexValue;
				// dodanie idIndeksu na poczatku i ; potem wartosc indeksu
				if ( sIndexId != null )
				{
					sIndexValue = sIndexId + ";" + sIndexValue;
				}
				// sIndexValue = encodeJavaUTF8String( sIndexValue );

				log.info( "Index: " + sIndexValue );
			}
		}
		catch ( Exception e )
		{
			log.error( e.getLocalizedMessage(), e );
		}
	}

	private Vector<String> getIndexValueCandidatesFromXmlFile()
	{
		DirectoryMonitorTools oDirMT = new DirectoryMonitorTools();

		boolean ignoredNamespaces = Boolean.parseBoolean( sXMLValueIgnoreNamespaces );

		if ( StringUtils.isNotBlank( sXMLValueDelimiterTag ) )
		{
			String defaultValue = StringUtils.defaultString( sXMLDefaultDelimitedValue );

			if ( StringUtils.isNotBlank( sXMLValueAttribute ) )
			{
				return oDirMT.GetXMLAttributesWithDelimiter(
					fXMLFile.getAbsolutePath(), ignoredNamespaces,
					sXMLValueDelimiterTag, sXMLValueTag, sXMLValueAttribute,
					defaultValue
				);
			}

			return oDirMT.GetXMLTagsWithDelimiter(
				fXMLFile.getAbsolutePath(), ignoredNamespaces,
				sXMLValueDelimiterTag, sXMLValueTag,
				defaultValue
			);

		}

		if ( StringUtils.isNotBlank( sXMLValueAttribute ) )
		{
			return oDirMT.GetXMLAttributes(
				fXMLFile.getAbsolutePath(), ignoredNamespaces,
				sXMLValueTag, sXMLValueAttribute
			);
		}

		return oDirMT.GetXMLTags(
			fXMLFile.getAbsolutePath(), ignoredNamespaces,
			sXMLValueTag
		);
	}

	// public void startDocument()
	// {
	//
	// }
	//
	// public void endDocument()
	// {
	//
	// }
	//
	// public void startElement(String sURI, String sName, String sQName, Attributes oAtts)
	// {
	// //odczyt ze zmiennej sXMLValueTag
	// if (bReadingXMLFile == false)
	// {
	// Map <String,String> oAttsMap = new HashMap<String,String>();
	// for (int i = 0; i< oAtts.getLength(); i++)
	// {
	// oAttsMap.put(oAtts.getQName(i), oAtts.getValue(i));
	// }
	// mXMLValueTag.put(sQName, oAttsMap);
	// }
	// else
	// {
	// //jezeli obecny tag jest rowny temu znalezionemu w pliku xml
	// if(oCurrentTag.getKey().compareToIgnoreCase(sQName) == 0)
	// {
	// if (oXMLValueTagIterator.hasNext())
	// {
	// oPreviousTag = oCurrentTag;
	// oCurrentTag = oXMLValueTagIterator.next();
	// }
	// else if(sXMLValueAttribute == null || sXMLValueAttribute.compareToIgnoreCase("") == 0)
	// {
	// bGetXMLElement = true;
	// }
	// else
	// {
	// sIndexValue = oAtts.getValue(sXMLValueAttribute);
	// }
	// }
	// }
	// }
	//
	// public void endElement(String sURI, String sName, String sQName, Attributes atts)
	// {
	// //jezeli zamkniety tag poprzedni to cofamy o jeden ustawienia tagow
	// if (oPreviousTag != null && oPreviousTag.getKey().compareToIgnoreCase(sQName) == 0)
	// {
	// Map.Entry<String, Map<String,String>> oTempTag = null;
	// oCurrentTag = oPreviousTag;
	//
	// oXMLValueTagIterator = mXMLValueTag.entrySet().iterator();
	// while (oXMLValueTagIterator.hasNext())
	// {
	// oPreviousTag = oTempTag;
	// oTempTag = oXMLValueTagIterator.next();
	// if (oTempTag.getKey().compareToIgnoreCase(oCurrentTag.getKey()) == 0)
	// {
	// break;
	// }
	// }
	// }
	// }
	//
	// public void characters (char ch[], int start, int length)
	// {
	// if (bGetXMLElement == true)
	// {
	// sIndexValue = ch.toString();
	// bGetXMLElement = false;
	// }
	// }

	public Index( String indexId, String name, String type, boolean AllowEmpty, int pathMember, int fileMember, String separator, String indexString,
				  String regExp, String mask, String SQLName, String SQLScheme, String sXML_Path, String sBarcode_Nr, String sXML_BackupPath,
				  String sXML_FileBackup, String sXML_FileDelete, String sXMLValueTag, String sXMLValueAttribute, String sXMLValueIgnoreNamespaces,
				  String sXMLValueDelimiterTag, String sXMLDefaultDelimitedValue, String sINISection, String sINIParameter, boolean MultiValue,
				  String sEncoding, String sDecoding, String sMustBeEqual )
	{
		super();
		log.trace( "Starting Index constructor" );
		sIndexId = indexId;
		sName = name;
		sType = type;
		this.bAllowEmpty = AllowEmpty;
		nPathSegment = pathMember;
		nFileSegment = fileMember;
		sFileSeparator = separator;
		sIndexString = indexString;
		sRegExp = regExp;
		sMask = mask;
		sSQLName = SQLName;
		sSQLScheme = SQLScheme;
		this.sBarcode_XML_Path = sXML_Path;
		this.sBarcode_Nr = sBarcode_Nr;
		this.sBarcode_XML_BackupPath = sXML_BackupPath;
		this.sBarcode_XML_FileBackup = sXML_FileBackup;
		this.sBarcode_XML_FileDelete = sXML_FileDelete;
		this.sXMLValueTag = sXMLValueTag;
		this.sXMLValueAttribute = sXMLValueAttribute;
		this.sXMLValueIgnoreNamespaces = sXMLValueIgnoreNamespaces;
		this.sXMLValueDelimiterTag = sXMLValueDelimiterTag;
		this.sXMLDefaultDelimitedValue = sXMLDefaultDelimitedValue;
		this.sINISection = sINISection;
		this.sINIParameter = sINIParameter;
		this.bMultiValue = MultiValue;
		this.sEncoding = sEncoding;
		this.sDecoding = sDecoding;
		this.sMustBeEqual = sMustBeEqual;
		// this.bReadingXMLFile = false;

		// vIndexes = indexes;
		// sSQLStatement = statement;
		// sDBUser = user;
		// sDBPassword = password;
		// sDBURL = url;
		// sJDBCDriver = driver;
	}

	public String GetIndexValue()
	{
		fFile = null;
		fXMLFile = null;
		SetIndexValue();
		return sIndexValue;
	}

	public String GetIndexValue( File f )
	{
		fFile = f;
		fXMLFile = null;
		SetIndexValue();
		return sIndexValue;
	}

	public String GetIndexValue( File f, File fXML )
	{
		fFile = f;
		fXMLFile = fXML;
		SetIndexValue();
		return sIndexValue;
	}

	public String getSIndexId()
	{
		return sIndexId;
	}

	public void setSIndexId( String indexId )
	{
		sIndexId = indexId;
	}

	public File getFFile()
	{
		return fFile;
	}

	public void setFFile( File file )
	{
		fFile = file;
	}

	public String getSIndexString()
	{
		return sIndexString;
	}

	public void setSIndexString( String indexString )
	{
		sIndexString = indexString;
	}

	public String getSRegExp()
	{
		return sRegExp;
	}

	public void setSRegExp( String regExp )
	{
		sRegExp = regExp;
	}

	public String getSName()
	{
		return sName;
	}

	public void setSName( String name )
	{
		sName = name;
	}
	
	public Boolean getIndexEqual()
	{
		return bIndexEqual;
	}
	
	public void resetIndexEqual()
	{
		bIndexEqual = true;
	}
}