package com.plusmpm.directorymonitor;

import java.awt.TrayIcon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.suncode.plugin.wrapper.DirectoryMonitorPluginContext;
import org.apache.log4j.Logger;

import com.plusmpm.directorymonitor.utils.ClassUtils;

public class DirectoryShare
extends TimerTask
{
	private static Logger log = Logger.getLogger( DirectoryShare.class );

	private String sShareId;

	private String sSharePath;
	
    private String sSortFilesBy;
    
    private String sSortFilesDirection;

	private boolean bSearchSubDirectory;

	private String sRawFileDestinationPath;

	private boolean bDeleteRawFiles;

	private boolean bCopyRawFiles;

	private String sXMLFileDestinationPath;

	private boolean bDeleteXMLFiles;

	private boolean bCopyXMLFiles;

	private boolean bCheckAtTime;

	private boolean bCheckPeriodic;

	private boolean bShowInfo;

	private boolean bShowErr;

	private boolean bAccessWithWebService;

	private Calendar oProcessTime;

	private int nPeriod;

	private int nProcessFilesUnmodifiedBy;

	private String sArchiveClass;

	private Vector vIndexes;

	private Vector vDB;

	private ArchiveTools oArchiveTools;

	private TrayIcon oTrayIcon;

	private Timer oTimer;

	private String sFileType;

	private String sFileRegExp;

	private String sFileNameRegExp;

	private String sRawFileRegExp;

	private String sRawFileMask;

	private String sXMLRawFileTag;

	private String sXMLRawFileAttribute;

	private String sXMLRawFileIgnoreNamespaces;

	private String sSaveAsNewVersion;

	private String sRawFileOnError;

	private String sRawFileErrorDirectory;

	private String sXMLFileOnError;

	private String sXMLFileErrorDirectory;

	// liczba powtorzen w przypadku nieudanego usuwania pliku
	private int nReDel = 10;

	// klucze z pliku INI
	private static String sShareIdKey = "ShareId";

	private static String sSharePathKey = "SharePath";
	
    private static String sSortFilesByKey = "SortFilesBy";

    private static String sSortFilesDirectionKey = "SortFilesDirection";

	private static String sRawFileDestinationPathKey = "RawFileDestinationPath";

	private static String sRawFileOnErrorKey = "RawFileOnError";

	private static String sRawFileErrorDirectoryKey = "RawFileErrorDirectory";

	private static String sXMLFileOnErrorKey = "XMLFileOnError";

	private static String sXMLFileErrorDirectoryKey = "XMLFileErrorDirectory";

	private static String sSearchSubDirectoryKey = "SearchSubDirectory";

	private static String sDeleteRawFilesKey = "DeleteRawFiles";

	private static String sCopyRawFilesKey = "CopyRawFiles";

	private static String sXMLRawFileTagKey = "XMLRawFileTag";

	private static String sXMLRawFileAttributeKey = "XMLRawFileAttribute";

	private static String sXMLRawFileIgnoreNamespacesKey = "XMLRawFileIgnoreNamespaces";

	private static String sXMLFileDestinationPathKey = "XMLFileDestinationPath";

	private static String sDeleteXMLFilesKey = "DeleteXMLFiles";

	private static String sCopyXMLFilesKey = "CopyXMLFiles";

	private static String sINIRawFileSectionKey = "INIRawFileSection";

	private static String sINIRawFileParameterKey = "INIRawFileParameter";

	private static String sINIFileDestinationPathKey = "XMLFileDestinationPath";

	private static String sDeleteINIFilesKey = "DeleteXMLFiles";

	private static String sCopyINIFilesKey = "CopyXMLFiles";

	private static String sCheckAtTimeKey = "CheckAtTime";

	private static String sCheckPeriodicKey = "CheckPeriodic";

	private static String sProcessTimeKey = "ProcessTime";

	private static String sPeriodKey = "Period";

	private static String sArchiveClassKey = "ArchiveClass";

	private static String sProcessFilesUnmodifiedByKey = "ProcessFilesUnmodifiedBy";

	// dane do pobierania z bazy danych
	private static String sSQLQueryKey = "SQLQuery";

	private static String sDBUserKey = "DBUser";

	private static String sDBPasswordKey = "DBPassword";

	private static String sDBURLKey = "DBURL";

	private static String sJDBCDriverKey = "JDBCDriver";

	private static String sAllOccurenceKey = "AllOccurence";

	private static String sFileTypeKey = "FileType";

	private static String sFileRegExpKey = "FileRegExp";

	private static String sFileNameRegExpKey = "FileNameRegExp";

	private static String sRawFileRegExpKey = "RawFileRegExp";

	private static String sRawFileMaskKey = "RawFileMask";

	private static String sSaveAsNewVersionKey = "SaveAsNewVersion";

	private static String sIndexKey = "Index";

	private static String sIndexId = "Id";

	private static String sIndexName = "Name";

	private static String sIndexType = "Type";

	private static String sIndexMustBeEqual = "MustBeEqual";

	private static String sIndexAllowEmpty = "AllowEmpty";

	private static String sIndexMultiValue = "MultiValue";

	private static String sIndexRegExp = "RegExp";

	private static String sIndexMask = "Mask";

	private static String sIndexString = "ConstantString";

	private static String sIndexPathSegment = "PathSegment";

	private static String sIndexFileSegment = "FileSegment";

	private static String sIndexFileSeparator = "FileSeparator";

	private static String sIndexEncoding = "Encoding";

	private static String sIndexDecoding = "Decoding";

	/**
	 * Wlasnosc indeksu typu Barcode2D: Pelna sciezka do katalogu, w ktorym znajduja sie pliki xml, zawierajace
	 * informacje o kodach 2D w odpowiadajacych im plikach.
	 */
	private static String sIndexBarcodeXMLPath = "XMLPath";

	/**
	 * Wlasnosc indeksu typu Barcode2D: Numer kodu 2D z pliku xml. Kody sa numerowane w od 1, od lewego gornego
	 * naroznika strony. Jezeli nie podano numeru, to zostanie ustawiony na 1.
	 */
	private static String sIndexBarcodeNr = "BarcodeNr";

	/**
	 * Wlasnosc indeksu typu Barcode2D: Jezeli jest true, to pliki xml beda usuwane po przetwarzaniu.
	 */
	private static String sIndexBarcodeXMLFileDelete = "XMLFileDelete";

	/**
	 * Wlasnosc indeksu typu Barcode2D: Jezeli jest true, to pliki xml beda kopiowane po przetwarzaniu do katalogu
	 * wskazanego w XMLBackupPath.
	 */
	private static String sIndexBarcodeXMLFileCopy = "XMLFileCopy";

	/**
	 * Wlasnosc indeksu typu Barcode2D: Pelna sciezka do katalogu, w ktorym beda umieszczane kopie przetworzonych plikow
	 * xml.
	 */
	private static String sIndexBarcodeXMLDestinationPath = "XMLDestinationPath";

	private static String sIndexSQLName = "SQLName";

	private static String sIndexSQLScheme = "SQLScheme";

	private static String sIndexXMLValueTag = "ValueTag";

	private static String sIndexXMLValueAttribute = "ValueAttribute";

	private static String sIndexXMLValueIgnoreNamespaces = "ValueIgnoreNamespaces";

	private static String sIndexXMLValueDelimiterTag = "ValueDelimiterTag";

	private static String sIndexXMLDefaultDelimitedValue = "DefaultDelimitedValue";

	private static String sIndexINISection = "INISection";

	private static String sIndexINIParameter = "INIParameter";

	// private static String sIndexSQLQuery = "SQLQuery";
	// private static String sIndexDBUser = "DBUser";
	// private static String sIndexDBPassword = "DBPassword";
	// private static String sIndexDBURL = "DBURL";
	// private static String sIndexJDBCDriver = "JDBCDriver";

	// tresci wiadomosci wyswietlanych w treyu
	private static String sInfoMessageTitle = "Udane przetwarzanie";

	private static String sInfoMessagePrefix = "Plik:\n";

	private static String sInfoMessageSufix = "\nzostał‚ dodany do archiwum";

	private static String sErrMessageCopyTitle = "Nieudane kopiowanie";

	private static String sErrMessageCopyPrefix = "Błąd przy kopiowaniu pliku:\n";

	private static String sErrMessageCopySufix = "";

	private static String sErrMessageDeleteTitle = "Nieudane usuwanie";

	private static String sErrMessageDeletePrefix = "Błąd przy usuwaniu pliku:\n";

	private static String sErrMessageDeleteSufix = "";

	private static String sErrMessageTitle = "Nieudane przetwarzanie";

	private static String sErrMessagePrefix = "Błąd przy przetwarzaniu pliku:\n";

	private static String sErrMessageSufix = "";

	private static String sErrMessageMkDirTitle = "Nieudane tworzenie katalogu";

	private static String sErrMessageMkDirPrefix = "Błąd przy tworzeniu katalogu:\n";

	private static String sErrMessageMkDirSufix = "";

	private static String sErrMessageAddFileTitle = "Nieudane dodanie pliku do archiwum";

	private static String sErrMessageAddFilePrefix = "Błąd przy dodawaniu pliku do archiwum:\n";

	private static String sErrMessageAddFileSufix = "";

	// kody bledow
	private static int nSUCCEED = 0;

	private static int nERR_WHILE_DELETE = 1;

	private static int nERR_WHILE_COPY = 2;

	private static int nERR_WHILE_MKDIR = 3;

	private static int nUNKNOWN_ERR = 10;

	// konstruktory
	public DirectoryShare( String sUser, String sPassword, DirectoryMonitorPluginContext nullablePluginContext )
	{
		super();
		log.info( "DirectoryShare constuctor" );
		InitVar( sUser, sPassword, true, true, nullablePluginContext );
	}

	public DirectoryShare( Map mConfig, String sUser, String sPassword,
						   boolean bDisplayTrayIcon, boolean bSetTimer, boolean AccessWithWebService,
						   DirectoryMonitorPluginContext nullablePluginContext )
	{
		super();
		log.trace( "DirectoryShare constuctor with config" );
		InitVar( sUser, sPassword, bDisplayTrayIcon, AccessWithWebService, nullablePluginContext );
		SetVar( mConfig );
		if ( bSetTimer )
		{
			SetTimer();
		}
	}

	public String getSShareId()
	{
		return sShareId;
	}

	public void setSShareId( String shareId )
	{
		sShareId = shareId;
	}

	public String getSSharePath()
	{
		return sSharePath;
	}

	public void setSSharePath( String sharePath )
	{
		sSharePath = sharePath;
	}
	
    public String getSSortFilesBy()
    {
        return sSortFilesBy;
    }
    
    public void setSSortFilesBy( String sortFilesBy )
    {
        sSortFilesBy = sortFilesBy;
    }
    
    public String getSSortFilesDirection()
    {
        return sSortFilesDirection;
    }
    
    public void setSSortFilesDirection( String sortFilesDirection )
    {
        sSortFilesDirection = sortFilesDirection;
    }

	public boolean isBSearchSubDirectory()
	{
		return bSearchSubDirectory;
	}

	public void setBSearchSubDirectory( boolean searchSubDirectory )
	{
		bSearchSubDirectory = searchSubDirectory;
	}

	public boolean isBDeleteRawFiles()
	{
		return bDeleteRawFiles;
	}

	public void setBDeleteRawFiles( boolean deleteFiles )
	{
		bDeleteRawFiles = deleteFiles;
	}

	public boolean isBCheckAtTime()
	{
		return bCheckAtTime;
	}

	public void setBCheckAtTime( boolean checkAtTime )
	{
		bCheckAtTime = checkAtTime;
	}

	public boolean isBCheckPeriodic()
	{
		return bCheckPeriodic;
	}

	public void setBCheckPeriodic( boolean checkPeriodic )
	{
		bCheckPeriodic = checkPeriodic;
	}

	public Calendar getOProcessTime()
	{
		return oProcessTime;
	}

	public void setOProcessTime( Calendar time )
	{
		oProcessTime = time;
	}

	public int getNPeriod()
	{
		return nPeriod;
	}

	public void setNPeriod( int period )
	{
		nPeriod = period;
	}

	public String getSArchiveClass()
	{
		return sArchiveClass;
	}

	public void setSArchiveClass( String archiveClass )
	{
		sArchiveClass = archiveClass;
	}

	public ArchiveTools getOArchiveTools()
	{
		return oArchiveTools;
	}

	public void setOArchiveTools( ArchiveTools archiveTools )
	{
		oArchiveTools = archiveTools;
	}

	public String getSRawFileOnError()
	{
		return sRawFileOnError;
	}

	public void setSRawFileErrorDirectory( String Path )
	{
		sRawFileErrorDirectory = Path;
	}

	public String getSRawFileErrorDirectory()
	{
		return sRawFileErrorDirectory;
	}

	public void setSRawFileOnError( String sOnError )
	{
		sRawFileOnError = sOnError;
	}

	public String getSXMLFileOnError()
	{
		return sXMLFileOnError;
	}

	public void setSXMLFileOnError( String sOnError )
	{
		sXMLFileOnError = sOnError;
	}

	public String getSXMLFileErrorDirectory()
	{
		return sXMLFileErrorDirectory;
	}

	public void setSXMLFileErrorDirectory( String sErrorDirectory )
	{
		sXMLFileErrorDirectory = sErrorDirectory;
	}

	public String getSRawFileDestinationPath()
	{
		return sRawFileDestinationPath;
	}

	public void setSRawFileDestinationPath( String destinationPath )
	{
		sRawFileDestinationPath = destinationPath;
	}

	public boolean isBCopyRawFiles()
	{
		return bCopyRawFiles;
	}

	public void setBCopyRawFiles( boolean copyRawFiles )
	{
		bCopyRawFiles = copyRawFiles;
	}

	public TrayIcon getOTrayIcon()
	{
		return oTrayIcon;
	}

	public void setOTrayIcon( TrayIcon trayIcon )
	{
		oTrayIcon = trayIcon;
	}

	public boolean isBShowInfo()
	{
		return bShowInfo;
	}

	public void setBShowInfo( boolean showInfo )
	{
		bShowInfo = showInfo;
	}

	public boolean isBShowErr()
	{
		return bShowErr;
	}

	public void setBShowErr( boolean showErr )
	{
		bShowErr = showErr;
	}

	public void setBAccessWithWebService( boolean accessWithWebService )
	{
		bAccessWithWebService = accessWithWebService;
	}

	public void InitVar( String sUser, String sPassword, boolean bDisplayTrayIcon, boolean AccessWithWebService,
						 DirectoryMonitorPluginContext nullablePluginContext )
	{
		log.trace( "Starting InitVar" );
		try
		{
			sShareId = null;
			sSharePath = null;
            sSortFilesBy = null;
            sSortFilesDirection = null;
			sArchiveClass = null;
			sRawFileDestinationPath = null;
			sRawFileOnError = "";
			sRawFileErrorDirectory = "";
			sXMLFileOnError = "";
			sXMLFileErrorDirectory = "";

			bSearchSubDirectory = false;
			bDeleteRawFiles = false;
			bCheckAtTime = false;
			bCheckPeriodic = false;
			bCopyRawFiles = false;
			bShowInfo = bDisplayTrayIcon;
			bShowErr = bDisplayTrayIcon;
			nPeriod = 0;
			nProcessFilesUnmodifiedBy = 0;
			oProcessTime = null;

			sFileType = null;
			sFileRegExp = null;
			sFileNameRegExp = null;
			sRawFileRegExp = null;
			sRawFileMask = null;

			sXMLRawFileTag = null;
			sXMLRawFileAttribute = null;

			sSaveAsNewVersion = null;

			sXMLFileDestinationPath = null;
			bCopyXMLFiles = false;
			bDeleteXMLFiles = false;

			bAccessWithWebService = AccessWithWebService;

			oArchiveTools = new ArchiveTools( nullablePluginContext, bAccessWithWebService );
			oArchiveTools.LoginToArchive( sUser, sPassword );

			vIndexes = new Vector();

			// oTimer = new Timer();
		}
		catch ( Exception e )
		{
			log.error( e.getLocalizedMessage(), e );
		}
	}

	public void SetVar( Map mConfig )
	{
		try
		{
			log.trace( "Starting SetVar" );
			if ( mConfig.containsKey( sShareIdKey ) )
				sShareId = (String) mConfig.get( sShareIdKey );

			if ( mConfig.containsKey( sSharePathKey ) )
				sSharePath = (String) mConfig.get( sSharePathKey );
			
	        if ( mConfig.containsKey( sSortFilesByKey ) )
                sSortFilesBy = (String) mConfig.get( sSortFilesByKey );
	        
	        if ( mConfig.containsKey( sSortFilesDirectionKey ) )
                sSortFilesDirection = (String) mConfig.get( sSortFilesDirectionKey );

			if ( mConfig.containsKey( sArchiveClassKey ) )
				sArchiveClass = (String) mConfig.get( sArchiveClassKey );

			if ( mConfig.containsKey( sFileTypeKey ) )
				sFileType = (String) mConfig.get( sFileTypeKey );

			if ( mConfig.containsKey( sFileRegExpKey ) )
				sFileRegExp = (String) mConfig.get( sFileRegExpKey );

			if ( mConfig.containsKey( sFileNameRegExpKey ) )
				sFileNameRegExp = (String) mConfig.get( sFileNameRegExpKey );

			if ( mConfig.containsKey( sRawFileRegExpKey ) )
				sRawFileRegExp = (String) mConfig.get( sRawFileRegExpKey );

			if ( mConfig.containsKey( sRawFileOnErrorKey ) )
				sRawFileOnError = (String) mConfig.get( sRawFileOnErrorKey );

			if ( mConfig.containsKey( sRawFileErrorDirectoryKey ) )
				sRawFileErrorDirectory = (String) mConfig.get( sRawFileErrorDirectoryKey );

			if ( mConfig.containsKey( sXMLFileOnErrorKey ) )
				sXMLFileOnError = (String) mConfig.get( sXMLFileOnErrorKey );

			if ( mConfig.containsKey( sXMLFileErrorDirectoryKey ) )
				sXMLFileErrorDirectory = (String) mConfig.get( sXMLFileErrorDirectoryKey );

			if ( mConfig.containsKey( sRawFileMaskKey ) )
				sRawFileMask = (String) mConfig.get( sRawFileMaskKey );

			if ( mConfig.containsKey( sRawFileDestinationPathKey ) )
				sRawFileDestinationPath = (String) mConfig.get( sRawFileDestinationPathKey );

			if ( mConfig.containsKey( sSearchSubDirectoryKey ) )
				if ( ( (String) mConfig.get( sSearchSubDirectoryKey ) ).compareToIgnoreCase( "true" ) == 0 )
					bSearchSubDirectory = true;
				else
					bSearchSubDirectory = false;

			if ( mConfig.containsKey( sXMLRawFileTagKey ) )
				sXMLRawFileTag = (String) mConfig.get( sXMLRawFileTagKey );

			if ( mConfig.containsKey( sXMLRawFileAttributeKey ) )
				sXMLRawFileAttribute = (String) mConfig.get( sXMLRawFileAttributeKey );

			if ( mConfig.containsKey( sXMLRawFileIgnoreNamespacesKey ) )
				sXMLRawFileIgnoreNamespaces = (String) mConfig.get( sXMLRawFileIgnoreNamespacesKey );

			if ( mConfig.containsKey( sDeleteRawFilesKey ) )
				if ( ( (String) mConfig.get( sDeleteRawFilesKey ) ).compareToIgnoreCase( "true" ) == 0 )
					bDeleteRawFiles = true;
				else
					bDeleteRawFiles = false;

			if ( mConfig.containsKey( sCheckAtTimeKey ) )
				if ( ( (String) mConfig.get( sCheckAtTimeKey ) ).compareToIgnoreCase( "true" ) == 0 )
					bCheckAtTime = true;
				else
					bCheckAtTime = false;

			if ( mConfig.containsKey( sCheckPeriodicKey ) )
				if ( ( (String) mConfig.get( sCheckPeriodicKey ) ).compareToIgnoreCase( "true" ) == 0 )
					bCheckPeriodic = true;
				else
					bCheckPeriodic = false;

			if ( mConfig.containsKey( sCopyRawFilesKey ) )
				if ( ( (String) mConfig.get( sCopyRawFilesKey ) ).compareToIgnoreCase( "true" ) == 0 )
					bCopyRawFiles = true;
				else
					bCopyRawFiles = false;

			if ( mConfig.containsKey( sXMLFileDestinationPathKey ) )
				sXMLFileDestinationPath = (String) mConfig.get( sXMLFileDestinationPathKey );

			if ( mConfig.containsKey( sCopyXMLFilesKey ) )
				if ( ( (String) mConfig.get( sCopyXMLFilesKey ) ).compareToIgnoreCase( "true" ) == 0 )
					bCopyXMLFiles = true;
				else
					bCopyXMLFiles = false;

			if ( mConfig.containsKey( sDeleteXMLFilesKey ) )
				if ( ( (String) mConfig.get( sDeleteXMLFilesKey ) ).compareToIgnoreCase( "true" ) == 0 )
					bDeleteXMLFiles = true;
				else
					bDeleteXMLFiles = false;

			if ( mConfig.containsKey( sPeriodKey ) )
				nPeriod = new Integer( (String) mConfig.get( sPeriodKey ) ).intValue();

			if ( mConfig.containsKey( sProcessFilesUnmodifiedByKey ) )
				nProcessFilesUnmodifiedBy = new Integer( (String) mConfig.get( sProcessFilesUnmodifiedByKey ) ).intValue();
			else
				nProcessFilesUnmodifiedBy = 0;

			if ( mConfig.containsKey( sSaveAsNewVersionKey ) )
				sSaveAsNewVersion = (String) mConfig.get( sSaveAsNewVersionKey );

			if ( mConfig.containsKey( sProcessTimeKey ) )
			{
				String sProcessTime = (String) mConfig.get( sProcessTimeKey );
				Calendar oNow = Calendar.getInstance();
				oProcessTime = Calendar.getInstance();

				if ( sProcessTime != null )
				{
					String saDTime[] = sProcessTime.split( ":" );
					if ( saDTime.length == 2 )
					{
						Integer nHour = new Integer( saDTime[0] );
						Integer nMinutes = new Integer( saDTime[1] );
						oProcessTime.set( Calendar.HOUR_OF_DAY, nHour.intValue() );
						oProcessTime.set( Calendar.MINUTE, nMinutes.intValue() );
						if ( oProcessTime.before( oNow ) )
						{
							oProcessTime.add( Calendar.DATE, 1 );
						}
					}
				}
			}

			// Obsluga bazy danych

			int nDBIndex = 1;
			// vector zawierajacy mapy opisujace polaczenia i zapytania do bazy danych
			vDB = new Vector();

			while ( mConfig.containsKey( sDBURLKey + nDBIndex ) )
			{
				Map mDBMap = new LinkedHashMap();
				Vector vSQLNames = new Vector();
				mDBMap.put( "SQLNames", vSQLNames );
				Vector vIndexNumbers = new Vector();
				mDBMap.put( "IndexNumbers", vIndexNumbers );
				mDBMap.put( sDBURLKey, (String) mConfig.get( sDBURLKey + nDBIndex ) );
				if ( mConfig.containsKey( sSQLQueryKey + nDBIndex ) )
					mDBMap.put( sSQLQueryKey, (String) mConfig.get( sSQLQueryKey + nDBIndex ) );
				else
				{
					nDBIndex++;
					break;
				}
				if ( mConfig.containsKey( sDBUserKey + nDBIndex ) )
					mDBMap.put( sDBUserKey, (String) mConfig.get( sDBUserKey + nDBIndex ) );
				else
				{
					nDBIndex++;
					break;
				}
				if ( mConfig.containsKey( sDBPasswordKey + nDBIndex ) )
					mDBMap.put( sDBPasswordKey, (String) mConfig.get( sDBPasswordKey + nDBIndex ) );
				else
				{
					nDBIndex++;
					break;
				}
				// pole nie obowiazkowe
				if ( mConfig.containsKey( sJDBCDriverKey + nDBIndex ) )
					mDBMap.put( sJDBCDriverKey, (String) mConfig.get( sJDBCDriverKey + nDBIndex ) );
				if ( mConfig.containsKey( sAllOccurenceKey + nDBIndex ) )
					mDBMap.put( sAllOccurenceKey, (String) mConfig.get( sAllOccurenceKey + nDBIndex ) );
				else
				{
					mDBMap.put( sAllOccurenceKey, "false" );
				}
				vDB.add( mDBMap );
				nDBIndex++;
			}

			// Pobranie z mapy indeksow i utowrzenie dla nich obiektow wraz z ustawieniem parametrow
			int nIndex = 1;

			vIndexes = new Vector();
			while ( mConfig.containsKey( sIndexKey + nIndex + "_" + sIndexType ) )
			{
				String sRegExp = null;
				String sMask = null;
				String sConst = null;
				String sSeparator = null;
				String sEncoding = null;
				String sDecoding = null;

				String sSQLName = null;
				String sSQLScheme = null;

				String sBarcode_Nr = null;
				String sBarcode_XML_Path = null;
				String sBarcode_XML_BackupPath = null;
				String sBarcode_XML_FileBackup = null;
				String sBarcode_XML_FileDelete = null;

				// Parametry dla plikow xml
				String sXMLValueTag = null;
				String sXMLValueAttribute = null;
				String sXMLValueIgnoreNamespaces = null;
				String sXMLValueDelimiterTag = null;
				String sXMLDefaultDelimitedValue = null;

				// Parametry dla plikow ini
				String sINISection = null;
				String sINIParameter = null;

				String sId = null;
				String sName = null;

				boolean bAllowEmpty = true;
				boolean bMultiValue = true;
				int nPathSegment = -1;
				int nFileSegment = -1;

				String sMustBeEqual = null;

				// String sStatement = null;
				// String sUser = null;
				// String sPassword = null;
				// String sURL = null;
				// String sDriver = null;

				String sIndexPrefix = sIndexKey + nIndex + "_";

				if ( mConfig.containsKey( sIndexPrefix + sIndexRegExp ) )
					sRegExp = (String) mConfig.get( sIndexPrefix + sIndexRegExp );

				if ( mConfig.containsKey( sIndexPrefix + sIndexMask ) )
					sMask = (String) mConfig.get( sIndexPrefix + sIndexMask );

				if ( mConfig.containsKey( sIndexPrefix + sIndexString ) )
					sConst = (String) mConfig.get( sIndexPrefix + sIndexString );

				if ( mConfig.containsKey( sIndexPrefix + sIndexPathSegment ) )
					nPathSegment = new Integer( (String) mConfig.get( sIndexPrefix + sIndexPathSegment ) ).intValue();

				if ( mConfig.containsKey( sIndexPrefix + sIndexFileSegment ) )
					nFileSegment = new Integer( (String) mConfig.get( sIndexPrefix + sIndexFileSegment ) ).intValue();

				if ( mConfig.containsKey( sIndexPrefix + sIndexFileSeparator ) )
					sSeparator = (String) mConfig.get( sIndexPrefix + sIndexFileSeparator );

				if ( mConfig.containsKey( sIndexPrefix + sIndexSQLName ) )
					sSQLName = (String) mConfig.get( sIndexPrefix + sIndexSQLName );

				if ( mConfig.containsKey( sIndexPrefix + sIndexSQLScheme ) )
					sSQLScheme = (String) mConfig.get( sIndexPrefix + sIndexSQLScheme );

				if ( mConfig.containsKey( sIndexPrefix + sIndexBarcodeXMLPath ) )
					sBarcode_XML_Path = (String) mConfig.get( sIndexPrefix + sIndexBarcodeXMLPath );

				if ( mConfig.containsKey( sIndexPrefix + sIndexBarcodeNr ) )
					sBarcode_Nr = (String) mConfig.get( sIndexPrefix + sIndexBarcodeNr );

				if ( mConfig.containsKey( sIndexPrefix + sIndexBarcodeXMLDestinationPath ) )
					sBarcode_XML_BackupPath = (String) mConfig.get( sIndexPrefix + sIndexBarcodeXMLDestinationPath );

				if ( mConfig.containsKey( sIndexPrefix + sIndexBarcodeXMLFileCopy ) )
					sBarcode_XML_FileBackup = (String) mConfig.get( sIndexPrefix + sIndexBarcodeXMLFileCopy );

				if ( mConfig.containsKey( sIndexPrefix + sIndexBarcodeXMLFileDelete ) )
					sBarcode_XML_FileDelete = (String) mConfig.get( sIndexPrefix + sIndexBarcodeXMLFileDelete );

				if ( mConfig.containsKey( sIndexPrefix + sIndexXMLValueTag ) )
					sXMLValueTag = (String) mConfig.get( sIndexPrefix + sIndexXMLValueTag );

				if ( mConfig.containsKey( sIndexPrefix + sIndexXMLValueAttribute ) )
					sXMLValueAttribute = (String) mConfig.get( sIndexPrefix + sIndexXMLValueAttribute );

				if ( mConfig.containsKey( sIndexPrefix + sIndexXMLValueIgnoreNamespaces ) )
					sXMLValueIgnoreNamespaces = (String) mConfig.get( sIndexPrefix + sIndexXMLValueIgnoreNamespaces );

				if ( mConfig.containsKey( sIndexPrefix + sIndexXMLValueDelimiterTag ) )
					sXMLValueDelimiterTag = (String) mConfig.get( sIndexPrefix + sIndexXMLValueDelimiterTag );

				if ( mConfig.containsKey( sIndexPrefix + sIndexXMLDefaultDelimitedValue ) )
					sXMLDefaultDelimitedValue = (String) mConfig.get( sIndexPrefix + sIndexXMLDefaultDelimitedValue );

				if ( mConfig.containsKey( sIndexPrefix + sIndexINISection ) )
					sINISection = (String) mConfig.get( sIndexPrefix + sIndexINISection );

				if ( mConfig.containsKey( sIndexPrefix + sIndexINIParameter ) )
					sINIParameter = (String) mConfig.get( sIndexPrefix + sIndexINIParameter );

				if ( mConfig.containsKey( sIndexPrefix + sIndexEncoding ) )
					sEncoding = (String) mConfig.get( sIndexPrefix + sIndexEncoding );

				if ( mConfig.containsKey( sIndexPrefix + sIndexDecoding ) )
					sDecoding = (String) mConfig.get( sIndexPrefix + sIndexDecoding );

				if ( mConfig.containsKey( sIndexPrefix + sIndexAllowEmpty ) )
				{
					String sAllowEmpty = (String) mConfig.get( sIndexPrefix + sIndexAllowEmpty );
					if ( sAllowEmpty.compareToIgnoreCase( "false" ) == 0 )
					{
						bAllowEmpty = false;
					}
					else
					{
						bAllowEmpty = true;
					}
				}

				if ( mConfig.containsKey( sIndexPrefix + sIndexMultiValue ) )
				{
					String sMultiValue = (String) mConfig.get( sIndexPrefix + sIndexMultiValue );
					if ( sMultiValue.compareToIgnoreCase( "true" ) == 0 )
					{
						bMultiValue = true;
					}
					else
					{
						bMultiValue = false;
					}
				}
				if ( mConfig.containsKey( sIndexPrefix + sIndexMustBeEqual ) )
					sMustBeEqual = (String) mConfig.get( sIndexPrefix + sIndexMustBeEqual );


				// nieaktualne //jesli nie ma id indeksu nie dodajemy
				if ( mConfig.containsKey( sIndexPrefix + sIndexId ) )
					sId = (String) mConfig.get( sIndexPrefix + sIndexId );
				// else
				// sId = "";
				// continue;

				if ( mConfig.containsKey( sIndexPrefix + sIndexName ) )
					sName = (String) mConfig.get( sIndexPrefix + sIndexName );

				Index oIndex = new Index(
					sId, sName, (String) mConfig.get( sIndexPrefix + sIndexType ), bAllowEmpty, nPathSegment, nFileSegment, sSeparator,
					sConst, sRegExp, sMask, sSQLName, sSQLScheme, sBarcode_XML_Path, sBarcode_Nr, sBarcode_XML_BackupPath,
					sBarcode_XML_FileBackup, sBarcode_XML_FileDelete, sXMLValueTag, sXMLValueAttribute, sXMLValueIgnoreNamespaces,
					sXMLValueDelimiterTag, sXMLDefaultDelimitedValue, sINISection, sINIParameter, bMultiValue, sEncoding, sDecoding, sMustBeEqual
				);
				vIndexes.add( oIndex );
				nIndex++;
			}
		}
		catch ( Exception e )
		{
			log.error( e.getLocalizedMessage(), e );
		}
	}

	public Map GetVar()
	{
		Map mConfig = null;
		try
		{
			mConfig = new LinkedHashMap();
			mConfig.put( sShareIdKey, sShareId );
			mConfig.put( sSharePathKey, sSharePath );
            mConfig.put( sSortFilesByKey, sSortFilesBy );
            mConfig.put( sSortFilesDirectionKey, sSortFilesDirection );
			mConfig.put( sRawFileDestinationPathKey, sRawFileDestinationPath );
			mConfig.put( sSearchSubDirectoryKey, bSearchSubDirectory );
			mConfig.put( sDeleteRawFilesKey, bDeleteRawFiles );
			mConfig.put( sCopyRawFilesKey, bCopyRawFiles );
			mConfig.put( sCheckAtTimeKey, bCheckAtTime );
			mConfig.put( sXMLFileDestinationPathKey, sXMLFileDestinationPath );
			mConfig.put( sDeleteXMLFilesKey, bDeleteXMLFiles );
			mConfig.put( sCopyXMLFilesKey, bCopyXMLFiles );
			mConfig.put( sCheckPeriodicKey, bCheckPeriodic );
			mConfig.put( sProcessTimeKey, oProcessTime );
			mConfig.put( sPeriodKey, nPeriod );
			mConfig.put( sArchiveClassKey, sArchiveClass );
			mConfig.put( sRawFileOnErrorKey, sRawFileOnError );
			mConfig.put( sRawFileErrorDirectoryKey, sRawFileErrorDirectory );
			mConfig.put( sXMLFileOnErrorKey, sXMLFileOnError );
			mConfig.put( sXMLFileErrorDirectoryKey, sXMLFileErrorDirectory );

			for ( int i = 0; i < vIndexes.size(); i++ )
			{
				Index oIndex = (Index) vIndexes.get( i );
				String sIndexPrefix = sIndexKey + i + "_";
				// jezeli istnieje index id i typ to dodanie, jesli nie to niedodawany
				if ( oIndex.getSIndexId() == null || oIndex.getSType() == null )
					continue;

				mConfig.put( sIndexPrefix + sIndexId, oIndex.getSIndexId() );
				mConfig.put( sIndexPrefix + sIndexType, oIndex.getSType() );

				if ( oIndex.getSName() != null )
					mConfig.put( sIndexPrefix + sIndexName, oIndex.getSName() );

				if ( oIndex.getNPathSegment() > 0 )
					mConfig.put( sIndexPrefix + sIndexPathSegment, oIndex.getNPathSegment() );
				if ( oIndex.getSIndexString() != null )
					mConfig.put( sIndexPrefix + sIndexString, oIndex.getSIndexString() );
				if ( oIndex.getSRegExp() != null )
					mConfig.put( sIndexPrefix + sIndexRegExp, oIndex.getSRegExp() );
				if ( oIndex.getSFileSeparator() != null )
					mConfig.put( sIndexPrefix + sIndexFileSeparator, oIndex.getSFileSeparator() );
				if ( oIndex.getNFileSegment() > 0 )
					mConfig.put( sIndexPrefix + sIndexFileSegment, oIndex.getNFileSegment() );
				if ( oIndex.getSMask() != null )
					mConfig.put( sIndexPrefix + sIndexMask, oIndex.getSMask() );

			}
		}
		catch ( Exception e )
		{
			log.error( e.getLocalizedMessage(), e );
		}
		return mConfig;
	}

	public void SetTimer()
	{
		try
		{
			oTimer = new Timer();
			// oTimer.cancel();
			// oTimer.purge();
			// wywolanie raz dziennie
			if ( bCheckAtTime )
				oTimer.scheduleAtFixedRate( this, oProcessTime.getTime(), 1000 * 60 * 60 * 24 );
			// wywolanie co okreslony czas
			if ( bCheckPeriodic )
				oTimer.schedule( this, nPeriod, nPeriod );
		}
		catch ( Exception e )
		{
			log.error( e.getLocalizedMessage(), e );
		}
	}

	public int AddFileToArchive( File fRawFile, File fXMLFile )
	{
		int nResult = -1;
		try
		{
			log.info( "Starting AddFileToArchive - RawFile: " + fRawFile.getAbsolutePath() );
			if ( fRawFile.exists() )
			{
				String asIndexValues[] = new String[vIndexes.size()];
				boolean bSQL = false;
				for ( int i = 0; i < vIndexes.size(); i++ )
				{
					if ( ( (String) ( (Index) vIndexes.get( i ) ).getSType() ).compareToIgnoreCase( "SQL" ) == 0 )
					{
						Integer nScheme = new Integer( ( (Index) vIndexes.get( i ) ).sSQLScheme );
						String sSQLName = ( (Index) vIndexes.get( i ) ).sSQLName;
						Map mDB = (Map) vDB.get( nScheme - 1 );

						Vector vNames = (Vector) mDB.get( "SQLNames" );
						vNames.add( sSQLName );
						mDB.put( "SQLNames", vNames );

						Vector vIndexNumbers = (Vector) mDB.get( "IndexNumbers" );
						vIndexNumbers.add( new Integer( i ) );
						mDB.put( "IndexNumbers", vIndexNumbers );

						vDB.set( nScheme.intValue() - 1, mDB );
						bSQL = true;

						// dodanie domyslnej wartosci pustej
						//Index oIndex = (Index) vIndexes.get( i );
						//oIndex.sIndexValue2 = "";
						//asIndexValues[i] = ( (Index) vIndexes.get( i ) ).GetIndexValue( fRawFile, fXMLFile );
						//if (!( (Index) vIndexes.get( i ) ).getIndexEqual())
						//{
						//	log.info("Niepasujacy indeks. Plik " + fRawFile.getAbsolutePath() + " nie przetwarzany.");
						//	( (Index) vIndexes.get( i ) ).resetIndexEqual();
						//	return -2;
						//}
					}
					else
					{
						asIndexValues[i] = ( (Index) vIndexes.get( i ) ).GetIndexValue( fRawFile, fXMLFile );
						if (!( (Index) vIndexes.get( i ) ).getIndexEqual())
						{
							log.info("Niepasujacy indeks. Plik " + fRawFile.getAbsolutePath() + " nie przetwarzany.");
							( (Index) vIndexes.get( i ) ).resetIndexEqual();
							return -2;
						}
					}
				}
				if ( !bSQL )
				{
					return oArchiveTools.AddFileToArchive( sArchiveClass, asIndexValues, fRawFile, sSaveAsNewVersion );
				}
				// return 0;

				// obsluga zapytan do baz danych
				else
				{
					boolean bAllOccurence = false;
					for ( int i = 0; i < vDB.size(); i++ )
					{
						Map mDBMap = (Map) vDB.get( i );

						// jezeli ma byc dodanie wszystich wystapien z zapytania to robimy to na koncu
						if ( ( (String) mDBMap.get( sAllOccurenceKey ) ).compareToIgnoreCase( "true" ) == 0 )
						{
							bAllOccurence = true;
							continue;
						}
						String sJDBCDriver = (String) mDBMap.get( sJDBCDriverKey );
						String sDBURL = (String) mDBMap.get( sDBURLKey );
						String sDBUser = (String) mDBMap.get( sDBUserKey );
						String sDBPassword = (String) mDBMap.get( sDBPasswordKey );
						String sQuery = (String) mDBMap.get( sSQLQueryKey );
						Vector vSQLNames = (Vector) mDBMap.get( "SQLNames" );
						Vector vIndexNumbers = (Vector) mDBMap.get( "IndexNumbers" );

						Connection con = null;
						Statement stmt = null;
						try
						{
							if ( sJDBCDriver != null && sJDBCDriver.compareToIgnoreCase( "" ) != 0 )
								Class.forName( sJDBCDriver, true, ClassUtils.getDefaultClassLoader() );
							con = DriverManager.getConnection( sDBURL, sDBUser, sDBPassword );
							stmt = con.createStatement();

							// String sQuery = sSQLQuery;

							// zamiania wartosci $Index w zapytaniu na rzeczywista wartosc indekus
							int nStart = sQuery.indexOf( "'$Index" );
							int nEnd;

							while ( nStart > 0 )
							{
								nEnd = sQuery.indexOf( "'", nStart + 1 );
								if ( nEnd > 0 )
								{
									String sIndex = sQuery.substring( nStart, nEnd );
									sIndex = sIndex.replace( "'$Index", "" );
									sIndex = sIndex.replace( "'", "" );
									Integer nIndex = new Integer( sIndex );
									if ( nIndex > 0 )
									{
										sQuery =
												sQuery.replace( sQuery.substring( nStart, nEnd + 1 ), ( (Index) vIndexes.get( nIndex - 1 ) ).sIndexValue2 );
									}
								}
								nStart = sQuery.indexOf( "'$Index" );
							}

							log.info( "sQuery: " + sQuery );
							ResultSet rs = stmt.executeQuery( sQuery );
							boolean isRowPresent = rs.next();
							for ( int j = 0; j < vSQLNames.size(); j++ )
							{
								String sIndexValue = "";
								if ( isRowPresent )
								{
									String sName = (String) vSQLNames.get( j );
									// System.out.println("sName: " + sName);
									Object oIndexValue = rs.getObject( sName );
									if ( oIndexValue == null )
									{
										oIndexValue = "";
									}
									sIndexValue = oIndexValue.toString();
									char[] acIndex = sIndexValue.toCharArray();
									// zastapienie znakow specjalnych
									for ( int k = 0; k < acIndex.length; k++ )
									{
										if ( acIndex[k] < 32 )
											acIndex[k] = '?';
									}
									sIndexValue = String.valueOf( acIndex );
								}
								else
								{
									log.warn( "Brak rekordów w bazie danych. Indeks przyjmuje pusta wartoscia." );
								}
								int nIndexNumber = (Integer) vIndexNumbers.get( j );
								Index oIndex = (Index) vIndexes.get( nIndexNumber );
								oIndex.sIndexValue2 = sIndexValue;
								asIndexValues[nIndexNumber] = ( (Index) vIndexes.get( nIndexNumber ) ).GetIndexValue( fRawFile, fXMLFile );
								if (!( (Index) vIndexes.get( nIndexNumber ) ).getIndexEqual())
								{
									log.info("Niepasujacy indeks. Plik " + fRawFile.getAbsolutePath() + " nie przetwarzany.");
									( (Index) vIndexes.get( nIndexNumber ) ).resetIndexEqual();
									stmt.close();
									con.close();
									return -2;
								}

							}

							stmt.close();
							con.close();
						}
						catch ( Exception e )
						{
							log.error( e.getLocalizedMessage(), e );
							stmt.close();
							con.close();
							// wyczyszczenie vIndexNumbers i vSQLNames
							for ( int j = 0; j < vDB.size(); j++ )
							{
								( (Vector) ( (Map) vDB.get( j ) ).get( "IndexNumbers" ) ).clear();
								( (Vector) ( (Map) vDB.get( j ) ).get( "SQLNames" ) ).clear();
							}

							return -1;
							// sIndexValue = "";
						}
					}
					// obsluga wstawiania ideksow dla wszystkich wystapien w zapytaniu
					if ( bAllOccurence )
					{

						// wyszukiwane tylko pierwsze wystapienie 'AllOccurance = true' pozostale ignorowane
						for ( int i = 0; i < vDB.size(); i++ )
						{
							Map mDBMap = (Map) vDB.get( i );

							if ( ( (String) mDBMap.get( sAllOccurenceKey ) ).compareToIgnoreCase( "true" ) == 0 )
							{
								String sJDBCDriver = (String) mDBMap.get( sJDBCDriverKey );
								String sDBURL = (String) mDBMap.get( sDBURLKey );
								String sDBUser = (String) mDBMap.get( sDBUserKey );
								String sDBPassword = (String) mDBMap.get( sDBPasswordKey );
								String sQuery = (String) mDBMap.get( sSQLQueryKey );
								Vector vSQLNames = (Vector) mDBMap.get( "SQLNames" );
								Vector vIndexNumbers = (Vector) mDBMap.get( "IndexNumbers" );

								Connection con = null;
								Statement stmt = null;
								try
								{
									if ( sJDBCDriver != null && sJDBCDriver.compareToIgnoreCase( "" ) != 0 )
										Class.forName( sJDBCDriver );
									con = DriverManager.getConnection( sDBURL, sDBUser, sDBPassword );
									stmt = con.createStatement();
									// String sQuery = sSQLQuery;

									// zamiania wartosci $Index w zapytaniu na rzeczywista wartosc indekus
									int nStart = sQuery.indexOf( "'$Index" );
									int nEnd;

									while ( nStart > 0 )
									{
										nEnd = sQuery.indexOf( "'", nStart + 1 );
										if ( nEnd > 0 )
										{
											String sIndex = sQuery.substring( nStart, nEnd );
											sIndex = sIndex.replace( "'$Index", "" );
											sIndex = sIndex.replace( "'", "" );
											Integer nIndex = new Integer( sIndex );
											if ( nIndex > 0 )
											{
												sQuery =
														sQuery.replace( sQuery.substring( nStart, nEnd + 1 ),
																( (Index) vIndexes.get( nIndex - 1 ) ).sIndexValue2 );
											}
										}
										nStart = sQuery.indexOf( "'$Index" );
									}
									// System.out.println(sQuery);
									ResultSet rs = stmt.executeQuery( sQuery );
									boolean bRS = false;
									while ( rs.next() )
									{
										bRS = true;
										for ( int j = 0; j < vSQLNames.size(); j++ )
										{
											String sName = (String) vSQLNames.get( j );
											// System.out.println("sName: " + sName);
											Object oIndexValue = rs.getObject( sName );
											if ( oIndexValue == null )
											{
												oIndexValue = "";
											}
											String sIndexValue = oIndexValue.toString();
											// String sIndexValue = rs.getObject(sName).toString();
											char[] acIndex = sIndexValue.toCharArray();
											// zastapienie znakow specjalnych
											for ( int k = 0; k < acIndex.length; k++ )
											{
												if ( acIndex[k] < 32 )
													acIndex[k] = '?';
											}
											sIndexValue = String.valueOf( acIndex );
											int nIndexNumber = (Integer) vIndexNumbers.get( j );
											Index oIndex = (Index) vIndexes.get( nIndexNumber );
											oIndex.sIndexValue2 = sIndexValue;
											asIndexValues[nIndexNumber] = ( (Index) vIndexes.get( nIndexNumber ) ).GetIndexValue( fRawFile, fXMLFile );
											if (!( (Index) vIndexes.get( nIndexNumber ) ).getIndexEqual())
											{
												log.info("Niepasujacy indeks. Plik " + fRawFile.getAbsolutePath() + " nie przetwarzany.");
												( (Index) vIndexes.get( nIndexNumber ) ).resetIndexEqual();
												return -2;
											}

										}
										nResult = oArchiveTools.AddFileToArchive( sArchiveClass, asIndexValues, fRawFile, sSaveAsNewVersion );
										// nResult = 0;
									}

									// jezeli nie znalazl w bazie zadnych wartosci dodanie z pustymi polami
									if ( !bRS )
									{
										// System.out.println( "Brak rekordow w bazie! Plik nie przetworzony." );
										log.info( "Brak rekordow w bazie! Plik nie przetworzony." );
										nResult = -1;
										// nResult = oArchiveTools.AddFileToArchive( sArchiveClass, asIndexValues, fFile
										// );
									}

									stmt.close();
									con.close();

									// wyczyszczenie vIndexNumbers i vSQLNames
									for ( int j = 0; j < vDB.size(); j++ )
									{
										( (Vector) ( (Map) vDB.get( j ) ).get( "IndexNumbers" ) ).clear();
										( (Vector) ( (Map) vDB.get( j ) ).get( "SQLNames" ) ).clear();
									}

									return nResult;
								}
								catch ( Exception e )
								{
									log.error( e.getLocalizedMessage(), e );
									// e.printStackTrace();
									// wyczyszczenie vIndexNumbers i vSQLNames
									for ( int j = 0; j < vDB.size(); j++ )
									{
										( (Vector) ( (Map) vDB.get( j ) ).get( "IndexNumbers" ) ).clear();
										( (Vector) ( (Map) vDB.get( j ) ).get( "SQLNames" ) ).clear();
									}
									return -1;
								}
								finally
								{
									stmt.close();
									con.close();
								}
							}
						}
						// kod nieosiagalny
						return 0;
					}
					// bez dodawania wszystkich wystapien
					else
					{

						// wyczyszczenie vIndexNumbers i vSQLNames
						for ( int j = 0; j < vDB.size(); j++ )
						{
							( (Vector) ( (Map) vDB.get( j ) ).get( "IndexNumbers" ) ).clear();
							( (Vector) ( (Map) vDB.get( j ) ).get( "SQLNames" ) ).clear();
						}

						return oArchiveTools.AddFileToArchive( sArchiveClass, asIndexValues, fRawFile, sSaveAsNewVersion );
						// return 0;
					}
				}
			}
			else
			{
				log.error( "Brak pliku " + fRawFile.getAbsolutePath() + " na dysku!" );
				return -1;
			}
		}
		catch ( Exception e )
		{
			log.error( e.getLocalizedMessage(), e );
			// e.printStackTrace();
			return -1;
		}
		finally
		{
			// wyczyszczenie vIndexNumbers i vSQLNames
			for ( int j = 0; j < vDB.size(); j++ )
			{
				( (Vector) ( (Map) vDB.get( j ) ).get( "IndexNumbers" ) ).clear();
				( (Vector) ( (Map) vDB.get( j ) ).get( "SQLNames" ) ).clear();
			}
		}
	}

	// Zwraca mape zawierajaca jako klucz nazwy plikow, a jako wartosc int z numerem bledu (0 udane dodanie do archiwum)
	private Map ProcessDirectory( File fFile, Map mResult, String sRawDestination, String sXMLDestination )
	{
		try
		{
			// log.info( "Starting ProcessDirectory. ShareId: " + sShareId + " SharePath: " + fFile.getAbsolutePath()
			// );
			if ( fFile.exists() )
			{
				// log.info( "Directory exist" );
				String[] asFiles = fFile.list();
				
				List<String> fileList = new ArrayList<String>(Arrays.asList(asFiles));
		
				if (getSSortFilesBy() != null) {

    				if( getSSortFilesBy().equals( "name" )  ) 
    				{
                        if( getSSortFilesDirection() != null && getSSortFilesDirection().equals("desc" ) ) 
                        {
                            Collections.sort(fileList, Collections.reverseOrder());
                        }
                        else
                        {
                            fileList.sort(null);
                        }
    				}
    				else if( getSSortFilesBy().equals( "date" )) 
                    {    
                        File[] files = fFile.listFiles();
                        Arrays.sort( files );
                        if( getSSortFilesDirection() != null && getSSortFilesDirection().equals("desc" ) ) 
                        {
                            sortFilesByDateCreated(files, getSSortFilesDirection().toString());
                        }
                        else {
                            sortFilesByDateCreated(files, "asc");   
                        }            
    
                        fileList.clear();
                        for (File file : files)
                        {
                            try 
                            {
                                if (file.isFile() || file.isDirectory())
                                {
                                    fileList.add(file.getName());
                                }
                            }
                            catch ( Exception ex )
                            {
                                log.error( ex.getMessage(), ex );                      
                            }
                        }
                    }
			    }

                for ( String listEl : fileList) 
                {
                    // aktualny przetwarzany plik w katalogu (raw lub xml)
                    String sTempFile = fFile.getAbsolutePath() + File.separator + listEl.toString();
					log.info( "Processing: " + sTempFile );
					File fTempFile = new File( sTempFile );

					// vector plikow raw do przetworzenia (z jednego xml moze byc kilka raw)
					Vector<String> vsRawFiles = new Vector();

                    if ( fTempFile.isFile() )
                    {
                        try
                        {
                            java.util.Date time = new java.util.Date( fTempFile.lastModified() );
                            log.info( "Data ostatniej modyfikacji pliku: " + time );
                            Calendar filecal = Calendar.getInstance();
                            filecal.setTime(time);
                            Calendar cal = Calendar.getInstance();
                            cal.getTime();
                            cal.add(Calendar.MINUTE, -nProcessFilesUnmodifiedBy);
                            if (cal.before(filecal))
                            {
                                log.warn("Plik modyfikowany mniej niz " + nProcessFilesUnmodifiedBy + " minut temu. Przetwarzanie pomijane.");
                                continue;
                            }
                        }
                        catch ( Exception ex )
                        {
                            log.error( ex.getMessage(), ex );
                        }
                        // log.info( "True file" );
                        // jesli ustawiona wartosc FileRegExp sprawdzenie czy plik pasuje do wzorca
                        // log.info("FileRegExp: " + sFileRegExp);
                        // log.info("File: " + fTempFile.getName());
                        if ( sFileRegExp != null && sFileRegExp.compareToIgnoreCase( "" ) != 0 )
                        {
                            // dopasowanie wyrazenia regularnego
                            // log.info( "Sprawdzenie dopasowania" );
                            Pattern myPattern = Pattern.compile( sFileRegExp, Pattern.CANON_EQ );
                            Matcher myMatcher = myPattern.matcher( sTempFile );
                            // jezeli nie znalazl dopasowania to przechodzimy do kolenjego pliku
                            if ( !myMatcher.find() )
                            {
                                log.info( "Plik nie dopasowany do wzorca" );
                                continue;
                            }
                        }
                        if ( sFileNameRegExp != null && sFileNameRegExp.compareToIgnoreCase( "" ) != 0 )
                        {
                            // dopasowanie wyrazenia regularnego
                            // log.info( "Sprawdzenie dopasowania" );
                            Pattern myPattern = Pattern.compile( sFileNameRegExp, Pattern.CANON_EQ );
                            Matcher myMatcher = myPattern.matcher( fTempFile.getName() );
                            // jezeli nie znalazl dopasowania to przechodzimy do kolenjego pliku
                            if ( !myMatcher.find() )
                            {
                                log.info( "Plik nie dopasowany do wzorca" );
                                continue;
                            }
                        }

                        // Sprawdzenie typu pliku

                        // Jesli nie podano typu to ustawienie na RAW natomiast jesli podano inny typ niz obsugiwany to
                        // nie obslugujemy pliku
                        if ( sFileType == null || sFileType.compareToIgnoreCase( "" ) == 0 )
                        {
                            sFileType = "RAW";
                        }
                        // Jesli to jest plik zwykly (raw)
                        if ( sFileType.compareToIgnoreCase( "RAW" ) == 0 )
                        {
                            vsRawFiles.add( sTempFile );
                            log.info( "Typ pliku: RAW" );
                        }
                        // Jesli to jest plik XML
                        if ( sFileType.compareToIgnoreCase( "XML" ) == 0 )
                        {
                            log.info( "Typ pliku: XML" );
                            // Jesli podano parametr XMLRawFileTag
                            if ( sXMLRawFileTag != null && sXMLRawFileTag.compareToIgnoreCase( "" ) != 0 )
                            {
                            	boolean ignoreNamespaces = Boolean.parseBoolean( sXMLRawFileIgnoreNamespaces );

                                // jesli podano wartosc atrybutu pobranie atrubyty z danego tagu
                                if ( sXMLRawFileAttribute != null && sXMLRawFileAttribute.compareToIgnoreCase( "" ) != 0 )
                                {
                                    DirectoryMonitorTools oDirMT = new DirectoryMonitorTools();
                                    vsRawFiles = oDirMT.GetXMLAttributes( sTempFile, ignoreNamespaces, sXMLRawFileTag, sXMLRawFileAttribute );
                                }
                                // jesli nie to pobranie wartosic tagu
                                else
                                {
                                    DirectoryMonitorTools oDirMT = new DirectoryMonitorTools();
                                    vsRawFiles = oDirMT.GetXMLTags( sTempFile, ignoreNamespaces, sXMLRawFileTag );
                                }
                            }
                            else
                            {
                                vsRawFiles.add( sTempFile );
                                log.info( "Raw plik z nazwy pliku xml" );
                            }
                        }
                        // Jesli to plik INI
                        if ( sFileType.compareToIgnoreCase( "INI" ) == 0 )
                        {
                            // TODO
                        }
                        // Jesli podany parametr RawFileRegExp to sprawdzenie dopasowania
                        if ( sRawFileRegExp != null && sRawFileRegExp.compareToIgnoreCase( "" ) != 0 && vsRawFiles != null )
                        {
                            // dopasowanie wyrazenia regularnego do wszystkich nazw w vsRawFiles
                            int j = 0;
                            while ( vsRawFiles.size() > j )
                            {
                                Pattern myPattern = Pattern.compile( sRawFileRegExp, Pattern.CANON_EQ );
                                Matcher myMatcher = myPattern.matcher( vsRawFiles.get( j ) );
                                // jesli znaleziono dopasowanie to podmiania nazwy pliku
                                if ( myMatcher.find() )
                                {
                                    if ( myMatcher.groupCount() > 0 )
                                        vsRawFiles.set( j, myMatcher.group( 1 ) );
                                    else
                                        vsRawFiles.set( j, myMatcher.group() );
                                    if ( sRawFileMask != null && sRawFileMask.compareToIgnoreCase( "" ) != 0 )
                                        vsRawFiles.set( j, myMatcher.replaceAll( sRawFileMask ) );
                                    j++;
                                }
                                // jesli nie znalieziono to usuwamy element
                                else
                                {
                                    vsRawFiles.remove( j );
                                }
                            }
                        }
                        // Czy chociaz jedna porazka. Potrzebne do tego jak przetwarzac plik xml.
                        boolean bOneError = false;
                        boolean bLeaveXML = false;
                        //for ( int j = 0; j < vsRawFiles.size(); j++ )
                        for ( String sRawFile : vsRawFiles)
                        {
                            File fRawFile = new File( sRawFile );
                            log.info( "Processing file: " + fRawFile.getAbsolutePath() );
                            int nAddFileResult = AddFileToArchive( fRawFile, fTempFile );
                            // dodanie do archiwum
                            if ( nAddFileResult == 0 )
                            {
                                mResult.put( fRawFile.getAbsolutePath(), nSUCCEED );
                                if ( bShowInfo )
                                    oTrayIcon.displayMessage( sInfoMessageTitle, sInfoMessagePrefix + fRawFile.getAbsolutePath() + sInfoMessageSufix,
                                            TrayIcon.MessageType.INFO );
                                log.info( "*** " + sInfoMessageTitle + " *** " + sInfoMessagePrefix + fRawFile.getAbsolutePath() + sInfoMessageSufix );
                                // kopiowanie pliku
                                boolean bCopySucc = true;
                                if ( bCopyRawFiles && sRawDestination != null )
                                {
                                    FileChannel inChannel = null;
                                    FileChannel outChannel = null;
                                    try
                                    {
                                        File fTempOutFile = new File( sRawDestination + File.separator + fRawFile.getName() );
                                        inChannel = new FileInputStream( fRawFile ).getChannel();
                                        outChannel = new FileOutputStream( fTempOutFile ).getChannel();
                                        // magic number for Windows, 64Mb - 32Kb)
                                        int maxCount = ( 64 * 1024 * 1024 ) - ( 32 * 1024 );
                                        long size = inChannel.size();
                                        long position = 0;
                                        while ( position < size )
                                        {
                                            position += inChannel.transferTo( position, maxCount, outChannel );
                                        }
                                        outChannel.force(true);
                                        log.info("Skopiowano plik z " + fTempFile.getAbsolutePath() + " do " + fTempOutFile.getAbsolutePath());
                                    }
                                    catch ( IOException e )
                                    {
                                        // e.printStackTrace();
                                        bCopySucc = false;
                                        mResult.put( fRawFile.getAbsolutePath(), nERR_WHILE_COPY );
                                        if ( bShowErr )
                                            oTrayIcon.displayMessage( sErrMessageCopyTitle, sErrMessageCopyPrefix + fRawFile.getAbsolutePath()
                                                    + sErrMessageCopySufix, TrayIcon.MessageType.ERROR );
                                        log.error( "*** " + sErrMessageCopyTitle + " *** " + sErrMessageCopyPrefix + fRawFile.getAbsolutePath()
                                                + sErrMessageCopySufix );
                                    }
                                    finally
                                    {
                                        try
                                        {
                                            if ( inChannel != null )
                                                inChannel.close();
                                            if ( outChannel != null )
                                                outChannel.close();
                                        }
                                        catch ( IOException e )
                                        {
                                            log.error( e.getLocalizedMessage(), e );
                                            // e.printStackTrace();
                                        }
                                    }
                                }
                                // usuwanie pliku
                                if ( bDeleteRawFiles && bCopySucc )
                                {
                                    if ( !fRawFile.delete() )
                                    {
                                        //System.gc();
                                        // powtorzenie usuwania
                                        int nCount = 1;
                                        boolean bSucceed = false;
                                        while ( nCount <= nReDel && bSucceed == false )
                                        {
                                            // log.warn( "Nieudane usuwanie pliku: " + fRawFile.getAbsolutePath() +
                                            // " - proba: " + nCount );
                                            try
                                            {
                                                Thread.sleep( nCount * 100 );
                                            }
                                            catch ( InterruptedException e )
                                            {
                                                log.error( e.getLocalizedMessage(), e );
                                                // e.printStackTrace();
                                            }
                                            nCount++;

											try
											{
												Files.delete( fRawFile.toPath() );
												bSucceed = true;
											}
											catch ( Exception e )
											{
												log.warn( "Failed to delete file " + fRawFile, e );
											}
                                        }
                                        if ( !bSucceed )
                                        {
                                            mResult.put( fRawFile.getAbsolutePath(), nERR_WHILE_DELETE );
                                            if ( bShowErr )
                                                oTrayIcon.displayMessage( sErrMessageDeleteTitle, sErrMessageDeletePrefix
                                                        + fRawFile.getAbsolutePath() + sErrMessageDeleteSufix, TrayIcon.MessageType.ERROR );
                                            log.error( "*** " + sErrMessageDeleteTitle + " *** " + sErrMessageDeletePrefix
                                                    + fRawFile.getAbsolutePath() + sErrMessageDeleteSufix );
                                        }
                                    }
                                    log.info("Udane usuwanie pliku: " + fRawFile.getAbsolutePath());
                                }
                            }
                            else if (nAddFileResult == -2)
                            {
                                log.info("Plik niedopasowany, pozostawiony na miejscu");
                                bLeaveXML = true;
                            }
                            // jesli nieudane dodawanie do archiwum
                            else
                            {
                                bOneError = true;
                                if ( bShowErr )
                                    oTrayIcon.displayMessage( sErrMessageAddFileTitle, sErrMessageAddFilePrefix + fRawFile.getAbsolutePath()
                                            + sErrMessageAddFileSufix, TrayIcon.MessageType.ERROR );
                                log.error( "*** " + sErrMessageAddFileTitle + " *** " + sErrMessageAddFilePrefix + fRawFile.getAbsolutePath()
                                        + sErrMessageAddFileSufix );
                                //
                                if ( sRawFileOnError.equalsIgnoreCase( "Copy" ) || sRawFileOnError.equalsIgnoreCase( "Move" ) )
                                {
                                    if (fRawFile.exists()) {
                                        try {
                                            FileChannel source = null;
                                            FileChannel destination = null;
                                            String sDir = sRawFileErrorDirectory;
                                            sDir = sDir.replace("\\", "/");
                                            if (!sDir.endsWith("/")) {
                                                sDir += "/";
                                            }
                                            File fDir = new File(sDir);
                                            if (!fDir.exists()) {
                                                fDir.mkdirs();
                                            }

                                            String sDestFile = sDir + fRawFile.getName();
                                            File fDest = new File(sDestFile);

                                            if (fDest.exists())
                                            {
                                                String sTempDestFile = sDestFile;
                                                Integer nIndexOfDot = 0;
                                                while (sTempDestFile.contains(".")) {
                                                    nIndexOfDot += sTempDestFile.indexOf(".") + 1;
                                                    sTempDestFile = sTempDestFile.substring(sTempDestFile.indexOf(".") + 1);
                                                }
                                                sTempDestFile = sDestFile.substring(0, nIndexOfDot - 1);
                                                Integer nFileInd = 0;
                                                String sExt = sDestFile.substring(nIndexOfDot - 1);
                                                do {
                                                    nFileInd++;
                                                    sDestFile = sTempDestFile + "_" + nFileInd + sExt;
                                                    fDest = new File(sDestFile);
                                                }
                                                while (fDest.exists());
                                            }

                                            FileInputStream fileInputStream = new FileInputStream(fRawFile);
                                            source = fileInputStream.getChannel();
                                            destination = new FileOutputStream(fDest).getChannel();
                                            destination.transferFrom(source, 0, source.size());
                                            log.error("Skopiowano plik: " + fRawFile.getAbsolutePath() + " do: " + sDestFile);
                                            destination.force(true);
                                            destination.close();
                                            source.close();
                                        } catch (Exception e) {
                                            log.error("Blad przy kopiowaniu pliku", e);
                                        }
                                    }
                                    else
                                    {
                                        log.error("Blad przy kopiowaniu pliku. Plik " + fRawFile.getAbsolutePath() + " nie istnieje!");
                                    }
                                }

                                if ( sRawFileOnError.equalsIgnoreCase( "Move" ) || sRawFileOnError.equalsIgnoreCase( "Delete" ) )
                                {
                                    if (fRawFile.exists()) {
                                        //String sRawFile = fRawFile.getAbsolutePath();
                                        // fRawFile.delete();
                                        // log.info("Usunieto plik: " + sRawFile);
                                        boolean bSucceed = true;
                                        if (!fRawFile.delete()) {
                                            //System.gc();
                                            // powtorzenie usuwania
                                            int nCount = 1;
                                            bSucceed = false;
                                            while (nCount <= nReDel && bSucceed == false) {
                                                // log.warn( "Nieudane usuwanie pliku: " + fRawFile.getAbsolutePath() +
                                                // " - proba: " + nCount );
                                                try {
                                                    Thread.sleep(nCount * 100);
                                                } catch (InterruptedException e) {
                                                    log.error(e.getLocalizedMessage(), e);
                                                    // e.printStackTrace();
                                                }
                                                nCount++;
                                                if (fRawFile.delete()) {
                                                    bSucceed = true;
                                                }
                                            }
                                        }
                                        if (!bSucceed) {
                                            log.error("Nieudane usuwanie pliku " + sRawFile);
                                        } else {
                                            log.info("Usunieto plik: " + sRawFile);
                                        }
                                    }
                                }
                            }
                        }
                        // Skopiowanie i usuniecie pliku XML
                        if ( sFileType.compareToIgnoreCase( "XML" ) == 0 )
                        {
                            if (bLeaveXML)
                            {
                                log.info("Niepasujacy indeks - pominiecie pliku xml");
                            }
                            // jesli chociaz jakis blad to przetwarzamy zgodnie z error
                            else if ( bOneError )
                            {
                                if ( sXMLFileOnError.equalsIgnoreCase( "Copy" ) || sXMLFileOnError.equalsIgnoreCase( "Move" ) )
                                {
                                    if (fTempFile.exists()) {
                                        FileChannel source = null;
                                        FileChannel destination = null;
                                        String sDir = sXMLFileErrorDirectory;
                                        sDir = sDir.replace("\\", "/");
                                        if (!sDir.endsWith("/")) {
                                            sDir += "/";
                                        }
                                        File fDir = new File(sDir);
                                        if (!fDir.exists()) {
                                            fDir.mkdirs();
                                        }

                                        String sDestFile = sDir + fTempFile.getName();
                                        File fDest = new File(sDestFile);

                                        if (fDest.exists()) {
                                            String sTempDestFile = sDestFile;
                                            Integer nIndexOfDot = 0;
                                            while (sTempDestFile.contains(".")) {
                                                nIndexOfDot += sTempDestFile.indexOf(".") + 1;
                                                sTempDestFile = sTempDestFile.substring(sTempDestFile.indexOf(".") + 1);
                                            }
                                            sTempDestFile = sDestFile.substring(0, nIndexOfDot - 1);
                                            Integer nFileInd = 0;
                                            String sExt = sDestFile.substring(nIndexOfDot - 1);
                                            do {
                                                nFileInd++;
                                                sDestFile = sTempDestFile + "_" + nFileInd + sExt;
                                                fDest = new File(sDestFile);
                                            }
                                            while (fDest.exists());
                                        }

                                        FileInputStream fileInputStream = new FileInputStream(fTempFile);
                                        source = fileInputStream.getChannel();
                                        destination = new FileOutputStream(fDest).getChannel();
                                        destination.transferFrom(source, 0, source.size());
                                        log.error("Skopiowano plik: " + fTempFile.getAbsolutePath() + " do: " + sDestFile);
                                        destination.force(true);
                                        destination.close();
                                        source.close();
                                    }
                                    else
                                    {
                                        log.error("Blad przy kopiowaniu pliku. Plik " + fTempFile.getAbsolutePath() + " nie istnieje!");
                                    }
                                }

                                if ( sXMLFileOnError.equalsIgnoreCase( "Move" ) || sXMLFileOnError.equalsIgnoreCase( "Delete" ) )
                                {
                                    if (fTempFile.exists())
                                    {
                                        String sXMLFile = fTempFile.getAbsolutePath();
                                        fTempFile.delete();
                                        log.info( "Usunieto plik: " + sXMLFile );
                                    }
                                }
                            }
                            // jesli nie bylo bledow przy przetwarzaniu
                            else
                            {
                                // kopiowanie pliku
                                boolean bCopySucc = true;
                                boolean bSucceed = true;
                                if ( bCopyXMLFiles && sXMLDestination != null )
                                {
                                    FileChannel inChannel = null;
                                    FileChannel outChannel = null;
                                    try
                                    {
                                        File fTempOutFile = new File( sXMLDestination + File.separator + fTempFile.getName() );
                                        inChannel = new FileInputStream( fTempFile ).getChannel();
                                        outChannel = new FileOutputStream( fTempOutFile ).getChannel();
                                        // magic number for Windows, 64Mb - 32Kb)
                                        int maxCount = ( 64 * 1024 * 1024 ) - ( 32 * 1024 );
                                        long size = inChannel.size();
                                        long position = 0;
                                        while ( position < size )
                                        {
                                            position += inChannel.transferTo( position, maxCount, outChannel );
                                        }
                                        outChannel.force(true);
                                        log.info("Skopiowano plik z " + fTempFile.getAbsolutePath() + " do " + fTempOutFile.getAbsolutePath());
                                    }
                                    catch ( IOException e )
                                    {
                                        // e.printStackTrace();
                                        bCopySucc = false;
                                        mResult.put( fTempFile.getAbsolutePath(), nERR_WHILE_COPY );
                                        if ( bShowErr )
                                            oTrayIcon.displayMessage( sErrMessageCopyTitle, sErrMessageCopyPrefix + fTempFile.getAbsolutePath()
                                                    + sErrMessageCopySufix, TrayIcon.MessageType.ERROR );
                                        log.error( "*** " + sErrMessageCopyTitle + " *** " + sErrMessageCopyPrefix + fTempFile.getAbsolutePath()
                                                + sErrMessageCopySufix );
                                    }
                                    finally
                                    {
                                        try
                                        {
                                            if ( inChannel != null )
                                                inChannel.close();
                                            if ( outChannel != null )
                                                outChannel.close();
                                        }
                                        catch ( IOException e )
                                        {
                                            log.error( e.getLocalizedMessage(), e );
                                            // e.printStackTrace();
                                        }
                                    }
                                }
                                // usuwanie pliku
                                if ( bDeleteXMLFiles && bCopySucc )
                                {
                                    if ( !fTempFile.delete() )
                                    {
                                        //System.gc();
                                        // powtorzenie usuwania
                                        int nCount = 1;
                                        bSucceed = false;
                                        while ( nCount <= nReDel && bSucceed == false )
                                        {
                                            log.warn( "Nieudane usuwanie pliku: " + fTempFile.getAbsolutePath() + " - proba: " + nCount );
                                            try
                                            {
                                                Thread.sleep( nCount * 100 );
                                            }
                                            catch ( InterruptedException e )
                                            {
                                                log.error( e.getLocalizedMessage(), e );
                                                // e.printStackTrace();
                                            }
                                            nCount++;
                                            if ( fTempFile.delete() )
                                            {
                                                bSucceed = true;
                                            }
                                        }
                                        if ( !bSucceed )
                                        {
                                            mResult.put( fTempFile.getAbsolutePath(), nERR_WHILE_DELETE );
                                            if ( bShowErr )
                                                oTrayIcon.displayMessage( sErrMessageDeleteTitle, sErrMessageDeletePrefix
                                                        + fTempFile.getAbsolutePath() + sErrMessageDeleteSufix, TrayIcon.MessageType.ERROR );
                                            log.error( "*** " + sErrMessageDeleteTitle + " *** " + sErrMessageDeletePrefix
                                                    + fTempFile.getAbsolutePath() + sErrMessageDeleteSufix );
                                        }
                                    }
                                    log.info("Udane usuwanie pliku: " +fTempFile.getAbsolutePath());
                                }
                            }
                        }
                    }
                    // jesli to jest katalog
                    else if ( fTempFile.isDirectory() )
                    {
                        // jesli sparwdzamy podkatalogi do wywolanie rekurencyjne
                        if ( bSearchSubDirectory )
                        {
                            // jesli kopiowanie plikow RAW to utworzyc podkatalog w katalogu docelowym
                            if ( bCopyRawFiles )
                            {
                                File fDir = new File( sRawDestination + File.separator + fTempFile.getName() );
                                if ( !fDir.exists() )
                                {
                                    if ( !fDir.mkdir() )
                                    {
                                        mResult.put( fDir.getAbsoluteFile(), nERR_WHILE_MKDIR );
                                        if ( bShowErr )
                                        {
                                            oTrayIcon.displayMessage( sErrMessageMkDirTitle, sErrMessageMkDirPrefix + fTempFile.getAbsolutePath()
                                                    + sErrMessageMkDirSufix, TrayIcon.MessageType.ERROR );
                                            log.error( "*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix
                                                    + fTempFile.getAbsolutePath() + sErrMessageMkDirSufix );
                                            // System.out.println( "*** " + sErrMessageMkDirTitle + " *** " +
                                            // sErrMessageMkDirPrefix
                                            // + fTempFile.getAbsolutePath() + sErrMessageMkDirSufix );
                                        }
                                    }
                                }
                            }
                            // jesli kopiowanie plikow XML to utworzyc podkatalog w katalogu docelowym
                            if ( bCopyXMLFiles )
                            {
                                File fDir = new File( sXMLDestination + File.separator + fTempFile.getName() );
                                if ( !fDir.exists() )
                                {
                                    if ( !fDir.mkdir() )
                                    {
                                        mResult.put( fDir.getAbsoluteFile(), nERR_WHILE_MKDIR );
                                        if ( bShowErr )
                                        {
                                            oTrayIcon.displayMessage( sErrMessageMkDirTitle, sErrMessageMkDirPrefix + fTempFile.getAbsolutePath()
                                                    + sErrMessageMkDirSufix, TrayIcon.MessageType.ERROR );
                                            log.info( "*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix
                                                    + fTempFile.getAbsolutePath() + sErrMessageMkDirSufix );
                                            // System.out.println( "*** " + sErrMessageMkDirTitle + " *** " +
                                            // sErrMessageMkDirPrefix
                                            // + fTempFile.getAbsolutePath() + sErrMessageMkDirSufix );
                                        }
                                    }
                                }
                            }
                            mResult =
                                    ProcessDirectory( fTempFile, mResult, sRawDestination + File.separator + fTempFile.getName(), sXMLDestination
                                            + File.separator + fTempFile.getName() );
                        }
                    }


                    // jesli to jest plik
                }
			}
		}
		catch ( Exception e )
		{
			try
			{
				log.error( e.getLocalizedMessage(), e );
				// throw e;
			}
			catch ( Exception e1 )
			{
				// TODO Auto-generated catch block
				log.error( e1.getLocalizedMessage(), e1 );
			}
		}
		return mResult;
	}

	// Zwraca mape zawierajaca jako klucz nazwy plikow, a jako wartosc int z numerem bledu (0 udane dodanie do archiwum)
	public Map ProcessDirectory()
	{
		log.info( "Processing ShareID: " + sShareId );
		Map mResult = null;
		try
		{
			mResult = new LinkedHashMap();
			File fFile = new File( sSharePath );
			String sRawDest = sRawFileDestinationPath;
			// boolean bMakeFileDestSuccess = true;
			if ( bCopyRawFiles )
			{
				File fRawDestFile = new File( sRawDest );
				if ( !fRawDestFile.exists() && !fRawDestFile.mkdirs() )
				{
					mResult.put( fRawDestFile.getAbsoluteFile(), nERR_WHILE_MKDIR );
					if ( bShowErr )
						oTrayIcon.displayMessage( sErrMessageMkDirTitle, sErrMessageMkDirPrefix + fRawDestFile.getAbsolutePath()
								+ sErrMessageMkDirSufix, TrayIcon.MessageType.ERROR );
					// System.out.println( "*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix +
					// fDestFile.getAbsolutePath()
					// + sErrMessageMkDirSufix );
					log.error( "*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix + fRawDestFile.getAbsolutePath()
							+ sErrMessageMkDirSufix );
					sRawDest = null;
					// bMakeFileDestSuccess = false;
				}
			}
			String sXMLDest = sXMLFileDestinationPath;
			if ( sXMLDest != null )
			{
				File fXMLDestFile = new File( sXMLDest );
				if ( bCopyXMLFiles && !fXMLDestFile.exists() )
				{
					if ( !fXMLDestFile.mkdirs() )
					{
						mResult.put( fXMLDestFile.getAbsoluteFile(), nERR_WHILE_MKDIR );
						if ( bShowErr )
							oTrayIcon.displayMessage( sErrMessageMkDirTitle, sErrMessageMkDirPrefix + fXMLDestFile.getAbsolutePath()
									+ sErrMessageMkDirSufix, TrayIcon.MessageType.ERROR );
						// System.out.println( "*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix +
						// fDestFile.getAbsolutePath()
						// + sErrMessageMkDirSufix );
						log.error( "*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix + fXMLDestFile.getAbsolutePath()
								+ sErrMessageMkDirSufix );
						sXMLDest = null;
						// bMakeFileDestSuccess = false;
					}
				}
			}
			mResult = ProcessDirectory( fFile, mResult, sRawDest, sXMLDest );

		}
		catch ( Exception e )
		{
			log.error( e.getLocalizedMessage(), e );
		}
		return mResult;
	}

	@Override
	public void run()
	{
		ProcessDirectory();
	}
	
	public static void sortFilesByDateCreated (File[] files, String sortDirecion) {
	      Arrays.sort(files, new Comparator<File>() 
	      {
	          public int compare (File f1, File f2) 
	          {
	              long l1 = getFileCreationEpoch(f1);
	              long l2 = getFileCreationEpoch(f2);
	              
	              if(sortDirecion.equals("asc" )) 
	              {
	                  return Long.valueOf(l1).compareTo(l2);
	              }
	              else 
	              {
	                  return Long.valueOf(l2).compareTo(l1); 
	              }
	          }
	      });
	  }

	  public static long getFileCreationEpoch (File file) {
	      try 
	      {
	          BasicFileAttributes attr = Files.readAttributes(file.toPath(),BasicFileAttributes.class);
	          return attr.creationTime().toInstant().toEpochMilli();
	      } 
	      catch (IOException e) 
	      {
	          throw new RuntimeException(file.getAbsolutePath(), e);
	      }
	  }
	  
}
