/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluscustomfilename.hook;

import com.suncode.plugin.pluscustomfilename.configuration.dto.ChangeFileNameConfig;
import com.suncode.plugin.pluscustomfilename.configuration.service.ConfigurationService;
import com.suncode.plugin.pluscustomfilename.hook.enums.PredefinedTag;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.hook.annotation.Hook;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.support.DownloadFileHook;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;

@Hook
public class ChangeFileNameHook
implements DownloadFileHook {
    private static final Pattern TEMPLATE_TAG_PATTERN = Pattern.compile("<([^>]+)>");
    @Autowired
    private ConfigurationService configurationService;

    public OpenedFileContext execute(OpenedFileContext fileContext) {
        if (StringUtils.isBlank((CharSequence)fileContext.getProcessId()) && StringUtils.isBlank((CharSequence)fileContext.getActivityId())) {
            return fileContext;
        }
        ChangeFileNameConfig matchingConfiguration = this.findMatchingConfiguration(fileContext);
        if (matchingConfiguration == null) {
            return fileContext;
        }
        Map<String, Object> variableContext = this.resolveVariableContext(fileContext);
        String changedFileName = this.resolveTemplate(matchingConfiguration.getDocumentName(), variableContext, fileContext);
        String resolvedExtension = FilenameUtils.getExtension((String)changedFileName);
        if (StringUtils.isNotBlank((CharSequence)resolvedExtension)) {
            fileContext.setExtension(resolvedExtension);
            fileContext.setFileName(FilenameUtils.getBaseName((String)changedFileName));
        } else {
            fileContext.setFileName(changedFileName);
        }
        return fileContext;
    }

    private ChangeFileNameConfig findMatchingConfiguration(OpenedFileContext fileContext) {
        List<ChangeFileNameConfig> configurations = this.configurationService.getAllPcmConfigurations();
        return configurations.stream().filter(config -> Boolean.TRUE.equals(config.getActiveConfiguration()) && Objects.equals(config.getProcessId(), fileContext.getProcessId()) && Objects.equals(config.getDocumentClassName(), fileContext.getWfFile().getDocumentClass().getName())).findFirst().orElse(null);
    }

    private Map<String, Object> resolveVariableContext(OpenedFileContext fileContext) {
        String processId = fileContext.getProcessId();
        String activityId = fileContext.getActivityId();
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            return ServiceFactory.getActivityService().getActivityContext(processId, activityId);
        }
        return ServiceFactory.getProcessService().getProcessContext(processId);
    }

    private String resolveTemplate(String template, Map<String, Object> variableContext, OpenedFileContext fileContext) {
        String textWithKeywords = this.updateTextWithKeywords(template, fileContext);
        return TEMPLATE_TAG_PATTERN.matcher(textWithKeywords).replaceAll(match -> {
            String key = match.group(1);
            Object value = variableContext != null ? variableContext.get(key) : null;
            return value != null ? Matcher.quoteReplacement(String.valueOf(value)) : "";
        });
    }

    private String updateTextWithKeywords(String text, OpenedFileContext fileContext) {
        StringBuilder builder = new StringBuilder(text);
        this.replaceAllMatchingStringValues(builder, PredefinedTag.ORIGINAL_FILE_NAME.getKeywordPattern(), FilenameUtils.getBaseName((String)fileContext.getWfFile().getFileName()));
        this.replaceAllMatchingStringValues(builder, PredefinedTag.CURRENT_USERNAME.getKeywordPattern(), UserContext.current().getUser().getUserName());
        this.replaceAllMatchingStringValues(builder, PredefinedTag.CURRENT_DATE.getKeywordPattern(), LocalDate.now().toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd")));
        this.replaceAllMatchingStringValues(builder, PredefinedTag.CURRENT_DATETIME.getKeywordPattern(), LocalDateTime.now().toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH-mm-ss")));
        return builder.toString();
    }

    private void replaceAllMatchingStringValues(StringBuilder builder, String find, String replace) {
        Matcher matcher = Pattern.compile(find).matcher(builder);
        int startIndex = 0;
        while (matcher.find(startIndex)) {
            builder.replace(matcher.start(), matcher.end(), replace);
            startIndex = matcher.start() + replace.length();
        }
    }
}

