/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluscustomfilename.configuration.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.pluscustomfilename.configuration.dto.ChangeFileNameConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConfigurationService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private Plugin plugin;
    @Autowired
    private ConfigurationFileService configurationFileService;

    public List<ChangeFileNameConfig> getAllPcmConfigurations() {
        return Arrays.stream(this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey())).map(this::readConfiguration).peek(this::validateConfiguration).toList();
    }

    private ChangeFileNameConfig readConfiguration(String fileId) {
        ChangeFileNameConfig changeFileNameConfig;
        block8: {
            InputStream inputStream = this.configurationFileService.readFile(this.plugin.getKey(), fileId);
            try {
                changeFileNameConfig = (ChangeFileNameConfig)this.objectMapper.readValue(inputStream, ChangeFileNameConfig.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            inputStream.close();
        }
        return changeFileNameConfig;
    }

    private void validateConfiguration(ChangeFileNameConfig configuration) {
        Assert.notNull((Object)configuration.getActiveConfiguration(), (String)"Parameter activeConfiguration cannot be null");
        Assert.hasText((String)configuration.getDocumentClassName(), (String)"Parameter documentClassName cannot be null or empty");
        Assert.hasText((String)configuration.getProcessId(), (String)"Parameter processId cannot be null or empty");
        Assert.hasText((String)configuration.getDocumentName(), (String)"Parameter documentName cannot be null or empty");
    }
}

