PWE.integrationComponent.registerApplication("plusbnpparibasintegrator.duals.DomesticTransfer", {
    apiVersion: 2,
    buildForm: (form) => buildDomesticTransferForm(form),
    validateForm: (form) => validateDomesticTransferForm(form)
});

function validateDomesticTransferForm(form) {
    if (form.getArraySize('executionDate') === 0 || form.getArraySize('amount') === 0 ||
        form.getArraySize('principalBankBillingNumber') === 0 || form.getArraySize('beneficiaryBankBillingNumber') === 0 ||
        form.getArraySize('beneficiaryNameAndAddress') === 0 || form.getArraySize('paymentDetails') === 0 ||
        form.getArraySize('transferType') === 0 || form.getArraySize('references') === 0 ||
        form.getArraySize('principalAccountNumber') === 0 || form.getArraySize('beneficiaryAccountNumber') === 0) {
        form.showErrorMessage(PLUS_BNPPARIBAS.t('error.emptyArray'));
        return false;
    }
    return true;
}

function buildDomesticTransferForm(form) {
    let fileFieldSet = form.addFieldSet({
        id: "fileFieldSet",
        title: PLUS_BNPPARIBAS.t("fileFieldSet.title")
    });

    let transferFieldSet = form.addFieldSet({
        id: "transferFieldSet",
        title: PLUS_BNPPARIBAS.t("transferFieldSet.title")
    });

    let requiredFieldSet = transferFieldSet.addFieldSet({
        id: "requiredFieldSet",
        title: PLUS_BNPPARIBAS.t("requiredFieldSet.title")
    });

    fileFieldSet.addCombobox({
        id: "documentClassName",
        remote: {
            url: "plugin/com.suncode.plugin-plus-bnpparibas-integrator/api/documents/classes",
            fields: [
                {
                    name: "displayName",
                    type: "string"
                },
                {
                    name: "name",
                    type: "string"
                }
            ],
        },
        valueField: "name",
        displayField: "displayName",
        sort: [
            {
                property: "displayName",
                direction: "ASC"
            }
        ]
    });
    fileFieldSet.addField("documentName");

    requiredFieldSet.addField("executionDate");
    requiredFieldSet.addField("amount");
    requiredFieldSet.addField("principalBankBillingNumber");
    requiredFieldSet.addField("beneficiaryBankBillingNumber");
    requiredFieldSet.addField("beneficiaryNameAndAddress");
    requiredFieldSet.addField("principalAccountNumber");
    requiredFieldSet.addField("beneficiaryAccountNumber");
    requiredFieldSet.addField("principalNameAndAddress");
    requiredFieldSet.addField("paymentDetails");
    requiredFieldSet.addField("transferType");
    requiredFieldSet.addField("references");
}