/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbnpparibasintegrator.functions;

import com.suncode.plugin.plusbnpparibasintegrator.assertions.ElixirAssertions;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.util.Formatter;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import org.apache.commons.lang3.StringUtils;

@Functions
@FunctionsScript(value="/functions/split-payment-details.js")
public class SplitPaymentDetails {
    private final Translator t = Translators.get((String)"com.suncode.plugin-plus-bnpparibas-integrator");

    @Function(value="BNPParibas.splitPaymentDetails")
    public String splitPaymentDetails(Double vat, String taxId, String invoiceNumber, String txt) {
        ElixirAssertions.assertAmount(vat, this.t.getMessage("function.BNPParibas.splitPaymentDetails.param.vat.name"));
        ElixirAssertions.assertNotEmpty(taxId, this.t.getMessage("function.BNPParibas.splitPaymentDetails.param.taxId.name"));
        ElixirAssertions.assertNotEmpty(invoiceNumber, this.t.getMessage("function.BNPParibas.splitPaymentDetails.param.invoiceNumber.name"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/VAT/").append(vat).append("/IDC/").append(Formatter.substringAndReplace(taxId, 14, "A-Za-z", "0-9")).append("/INV/").append(Formatter.substringAndReplace(invoiceNumber, 35, new String[0]));
        if (!StringUtils.isEmpty((CharSequence)txt)) {
            stringBuilder.append("/TXT/").append(Formatter.substringAndReplace(txt, 33, new String[0]));
        }
        return stringBuilder.toString();
    }
}

