/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbnpparibasintegrator.assertions;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class ElixirAssertions {
    private ElixirAssertions() {
    }

    public static void assertAmount(Object amount, String name) {
        if (amount == null || (Double)amount <= 0.0) {
            throw new IllegalArgumentException(name + " must be greater than 0");
        }
    }

    public static void assertVatAmount(Object vatAmount, String name) {
        if (vatAmount == null || (Double)vatAmount < 0.0) {
            throw new IllegalArgumentException(name + " must be greater or equal than 0");
        }
    }

    public static void assertNotEmpty(String param, String name) {
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    public static void assertNotEmpty(Integer param, String name) {
        if (param == null) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    public static void assertNotEmpty(Object value, String name) {
        if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    public static void assertEmpty(Object value, String name) {
        if (StringUtils.isNotBlank((CharSequence)((String)value))) {
            throw new IllegalArgumentException(name + " must be empty");
        }
    }

    public static void assertExecutionDate(Object executionDate, String name) {
        LocalDate date = new LocalDate(executionDate);
        if (date.isBefore((ReadablePartial)LocalDate.now())) {
            throw new IllegalArgumentException(name + " cannot be set in the past");
        }
    }

    public static void assertCountryCode(Object countryCode, String name) {
        String code = (String)countryCode;
        ElixirAssertions.assertNotEmpty(code, name);
        if (!code.matches("^[A-Za-z]{2}$")) {
            throw new IllegalArgumentException("Wrong country code format: " + code);
        }
    }

    public static void assertSwiftCode(Object swiftCode, String name) {
        String code = (String)swiftCode;
        ElixirAssertions.assertNotEmpty(code, name);
        if (!code.matches("^[0-9A-Za-z]{1,11}$")) {
            throw new IllegalArgumentException("Wrong SWIFT code format: " + code);
        }
    }

    public static void assertCurrency(Object currency, String name) {
        String value = (String)currency;
        ElixirAssertions.assertNotEmpty(value, name);
        if (!value.matches("^[A-Z]{3}$")) {
            throw new IllegalArgumentException("Wrong currency format: " + value);
        }
    }

    public static void assertPolishAccountNumber(Object accountNumber, String name) {
        String value = (String)accountNumber;
        ElixirAssertions.assertNotEmpty(value, name);
        if (!value.matches("^[Pp][Ll][0-9]{26}$") && !value.matches("^[0-9]{26}$")) {
            throw new IllegalArgumentException("Wrong account number format: " + value);
        }
    }

    public static void assertIbanAccountNumber(Object accountNumber, String name) {
        String value = (String)accountNumber;
        ElixirAssertions.assertNotEmpty(value, name);
        if (!value.matches("^[A-Za-z0-9]{1,34}$")) {
            throw new IllegalArgumentException("Wrong account number format: " + value);
        }
    }

    public static void assertTransferType(Integer transferType, String name) {
        ElixirAssertions.assertNotEmpty(transferType, name);
        if (transferType != 51 && transferType != 53) {
            throw new IllegalArgumentException("Incorrect transfer type value");
        }
    }
}

