PWE.integrationComponent.registerApplication("plusbnpparibasintegrator.duals.ForeignTransfer", {
    apiVersion: 2,
    buildForm: (form) => buildForeignTransferForm(form)
});

function buildForeignTransferForm(form) {
    let fileFieldSet = form.addFieldSet({
        id: "fileFieldSet",
        title: PLUS_BNPPARIBAS.t("fileFieldSet.title")
    });

    let transferFieldSet = form.addFieldSet({
        id: "transferFieldSet",
        title: PLUS_BNPPARIBAS.t("transferFieldSet.title")
    });

    let requiredFieldSet = transferFieldSet.addFieldSet({
        id: "requiredFieldSet",
        title: PLUS_BNPPARIBAS.t("requiredFieldSet.title")
    });

    fileFieldSet.addCombobox({
        id: "documentClassName",
        remote: {
            url: "plugin/com.suncode.plugin-plus-bnpparibas-integrator/api/documents/classes",
            fields: [
                {
                    name: "displayName",
                    type: "string"
                },
                {
                    name: "name",
                    type: "string"
                }
            ],
        },
        valueField: "name",
        displayField: "displayName",
        sort: [
            {
                property: "displayName",
                direction: "ASC"
            }
        ]
    });
    fileFieldSet.addField("documentName");
    requiredFieldSet.addField("headerReference");

    const requiredArrayParameterIds = ["principalBankSwiftCode", "shipmentNumber", "transferNumber", "beneficiaryBankSwiftCode", "transferType",
        "references", "referralCurrencyDate", "referralCurrencyCode", "referralCurrencyAmount", "principalNameAndAddress", "principalAccountNumber",
        "feesAccountNumber", "referenceCurrencyCode", "referenceCurrencyAmount", "beneficiaryCountryCode", "beneficiaryBankCountryCode",
        "beneficiaryBankNameAndAddress", "beneficiaryAccountNumber", "beneficiaryNameAndAddress", "paymentDetails", "costAccounting"
    ];

    requiredArrayParameterIds.forEach(id =>
        requiredFieldSet.addField({id, optional: false, notEmpty: true})
    );

    transferFieldSet.addField("extraInfoCodes");
    transferFieldSet.addField("extra1");
    transferFieldSet.addField("extra2");
    transferFieldSet.addField("extra3");
    transferFieldSet.addField("extra4");
}