PWE.integrationComponent.registerApplication("plusbnpparibasintegrator.duals.CustomBankTransfer", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form)
});

function buildForm(form) {
    let fileFieldSet = form.addFieldSet({
        id: "fileFieldSet",
        title: PLUS_BNPPARIBAS.t("fileFieldSet.title")
    });

    let transferFieldSet = form.addFieldSet({
        id: "transferFieldSet",
        title: PLUS_BNPPARIBAS.t("transferFieldSet.title")
    });

    fileFieldSet.addCombobox({
        id: "documentClassName",
        remote: {
            url: "plugin/com.suncode.plugin-plus-bnpparibas-integrator/api/documents/classes",
            fields: [
                {
                    name: "displayName",
                    type: "string"
                },
                {
                    name: "name",
                    type: "string"
                }
            ],
        },
        valueField: "name",
        displayField: "displayName",
        sort: [
            {
                property: "displayName",
                direction: "ASC"
            }
        ]
    });
    fileFieldSet.addField("documentName");
    fileFieldSet.addField("fileHeaderLine");

    let table = transferFieldSet.addTable("mappings");
    table.addCombobox({
        id: "key",
        remote: {
            url: "plugin/com.suncode.plugin-plus-bnpparibas-integrator/api/banktransfer/keys",
            fields: [
                {
                    name: "name",
                    type: "string"
                },
                {
                    name: "type",
                    type: "string"
                }
            ]
        },
        template: [
            {
                label: PLUS_BNPPARIBAS.t("transferFieldSet.key.name.label"),
                field: "name"
            },
            {
                label: PLUS_BNPPARIBAS.t("transferFieldSet.key.type.label"),
                field: "type"
            }
        ],
        valueField: "name",
        displayField: "name",
        sort: [
            {
                property: "name",
                direction: "ASC"
            }
        ]
    });
    table.addField("variable");
}