PW.Functions.register("BNPParibas.splitPaymentDetails", "string", ["float", "string", "string", "string"], function (vat, taxId, invoiceNumber, txt) {
    if (vat <= 0) {
        console.error(PLUS_BNPPARIBAS.t("splitPaymentDetails.param.vat.name") + ' should be greater than 0');
        return;
    }

    if (taxId.length === 0) {
        console.error(PLUS_BNPPARIBAS.t("splitPaymentDetails.param.taxId.name") + ' value cannot be empty!');
        return;
    }

    if (invoiceNumber.length === 0) {
        console.error(PLUS_BNPPARIBAS.t("splitPaymentDetails.param.invoiceNumber.name") + ' value cannot be empty!');
        return;
    }

    let result = '';
    result += '/VAT/' + vat;
    result += '/IDC/' + taxId.substring(0, 14);
    result += '/INV/' + invoiceNumber.substring(0, 35);

    if (txt.trim().length !== 0) {
        result += "/TXT/" + txt.substring(0, 33);
    }

    return result;
});