/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbnpparibasintegrator.elixir.util;

import com.suncode.plugin.plusbnpparibasintegrator.elixir.dto.DomesticTransferDto;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.dto.ForeignTransferDto;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.dto.ForeignTransferHeaderDto;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public class Formatter {
    public static final String CHARS = "A-Za-z";
    public static final String NUMERIC_CHARS = "0-9";
    private static final String DOT = ".";
    private static final String COMMA = ",";
    private static final String END_LINE = "\r\n";
    private static final String EMPTY_STRING = "";
    private static final String DOUBLE_QUOTE = "\"";

    public static String substringAndReplace(String value, int length, String ... accept) {
        if (accept.length > 0) {
            value = value.replaceAll("^[^" + String.join((CharSequence)EMPTY_STRING, accept) + "]+", EMPTY_STRING);
        }
        return value.length() > length ? value.substring(0, length) : value;
    }

    public static String writeHeaderLine(List<String> headerLine) {
        return String.join((CharSequence)";", headerLine) + END_LINE;
    }

    public static String bankTransfer(List<String> line) {
        return String.join((CharSequence)";", line) + END_LINE;
    }

    public String domesticTransfer(DomesticTransferDto dto) {
        return "110," + dto.getExecutionDate().toString("yyyyMMdd").toUpperCase(Locale.ROOT) + COMMA + String.valueOf(dto.getAmount()).replace(COMMA, EMPTY_STRING).replace(DOT, EMPTY_STRING).toUpperCase(Locale.ROOT) + COMMA + dto.getPrincipalBankBillingNumber() + COMMA + 0 + COMMA + DOUBLE_QUOTE + dto.getPrincipalAccountNumber().toUpperCase(Locale.ROOT) + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + dto.getBeneficiaryAccountNumber().toUpperCase(Locale.ROOT) + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + this.splitByPipe(Formatter.substringAndReplace(dto.getPrincipalNameAndAddress(), 140, new String[0]), 35).toUpperCase(Locale.ROOT) + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + this.splitByPipe(Formatter.substringAndReplace(dto.getBeneficiaryNameAndAddress(), 140, new String[0]), 35).toUpperCase(Locale.ROOT) + DOUBLE_QUOTE + COMMA + 0 + COMMA + dto.getBeneficiaryBankBillingNumber() + COMMA + DOUBLE_QUOTE + this.splitByPipe(Formatter.substringAndReplace(dto.getPaymentDetails(), 140, new String[0]), 35).toUpperCase(Locale.ROOT) + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + dto.getTransferType() + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + this.splitByPipe(Formatter.substringAndReplace(dto.getReferences(), 210, new String[0]), 35).toUpperCase(Locale.ROOT) + DOUBLE_QUOTE + END_LINE;
    }

    public String foreignTransfer(ForeignTransferDto dto) {
        String beneficiaryBankData = StringUtils.isNotBlank((CharSequence)dto.getBeneficiaryBankSwiftCode()) ? "\r\n:57A:" + Formatter.substringAndReplace(dto.getBeneficiaryBankSwiftCode(), 11, CHARS, NUMERIC_CHARS) : "\r\n:57D:" + this.splitByNewLine(Formatter.substringAndReplace(dto.getBeneficiaryBankNameAndAddress(), 140, new String[0]), 35);
        String extraData = dto.getExtraInfoCodes() + END_LINE + dto.getExtra1() + END_LINE + dto.getExtra2() + END_LINE + dto.getExtra3() + END_LINE + dto.getExtra4();
        return "{:F01" + String.format("%1$-12s", dto.getPrincipalBankSwiftCode()).replace(' ', 'X') + String.format("%04d", dto.getShipmentNumber()) + String.format("%06d", dto.getTransferNumber()) + "}{2:I100" + String.format("%1$-12s", dto.getBeneficiaryBankSwiftCode()).replace(' ', 'X') + dto.getTransferType() + "1}{4:" + END_LINE + ":20:" + Formatter.substringAndReplace(dto.getReference(), 16, CHARS, NUMERIC_CHARS) + END_LINE + ":32A:" + dto.getReferralCurrencyDate().toString("yyMMdd") + dto.getReferralCurrencyCode() + dto.getReferralCurrencyAmount() + END_LINE + ":50:" + this.splitByNewLine(Formatter.substringAndReplace(dto.getPrincipalNameAndAddress(), 140, new String[0]), 35) + END_LINE + ":52D:" + dto.getPrincipalAccountNumber() + END_LINE + dto.getFeesAccountNumber() + END_LINE + dto.getReferenceCurrencyCode() + dto.getReferenceCurrencyAmount() + String.join((CharSequence)EMPTY_STRING, Collections.nCopies(15, " ")) + dto.getBeneficiaryCountryCode() + " " + dto.getBeneficiaryBankCountryCode() + beneficiaryBankData + END_LINE + ":59:/" + dto.getBeneficiaryAccountNumber() + this.splitByNewLine(Formatter.substringAndReplace(dto.getBeneficiaryNameAndAddress(), 140, new String[0]), 35) + END_LINE + ":70:" + this.splitByNewLine(Formatter.substringAndReplace(dto.getPaymentDetails(), 140, new String[0]), 35) + END_LINE + dto.getCostAccounting() + END_LINE + ":72:" + extraData.trim() + "-}$";
    }

    private String splitByNewLine(String text, int chunkSize) {
        StringBuilder sb = new StringBuilder();
        return this.splitString(sb, text, END_LINE, chunkSize, () -> sb.toString().trim());
    }

    private String splitByPipe(String text, int chunkSize) {
        StringBuilder sb = new StringBuilder();
        return this.splitString(sb, text, "|", chunkSize, () -> sb.deleteCharAt(sb.length() - 1).toString());
    }

    private String splitString(StringBuilder sb, String text, String splitChar, int chunkSize, Callable<String> lastCharProcessor) {
        if (text.length() <= chunkSize) {
            return text;
        }
        for (int start = 0; start < text.length(); start += chunkSize) {
            int end = Math.min(start + chunkSize, text.length());
            sb.append(text, start, end).append(splitChar);
        }
        return lastCharProcessor.call();
    }

    public String foreignTransferHeader(ForeignTransferHeaderDto transferHeader) {
        return "\r\n:01:" + Formatter.substringAndReplace(transferHeader.getHeaderReference(), 16, CHARS, NUMERIC_CHARS) + END_LINE + ":02:" + transferHeader.getAmountSum() + END_LINE + ":03:" + transferHeader.getTransferQuantity() + END_LINE + ":04:" + transferHeader.getPrincipalBankSwiftCode() + END_LINE + ":05:" + Formatter.substringAndReplace(this.splitByNewLine(transferHeader.getPrincipalNameAndAddress(), 35), 140, new String[0]) + END_LINE + ":07:" + transferHeader.getFilename() + END_LINE;
    }
}

