/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbnpparibasintegrator.duals;

import com.suncode.plugin.plusbnpparibasintegrator.Categories;
import com.suncode.plugin.plusbnpparibasintegrator.archive.services.DocumentService;
import com.suncode.plugin.plusbnpparibasintegrator.assertions.ElixirAssertions;
import com.suncode.plugin.plusbnpparibasintegrator.assertions.ParameterAssertions;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.dto.ForeignTransferDto;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.dto.ForeignTransferHeaderDto;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.dto.ForeignTransferParametersDto;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.services.ElixirService;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.util.ParamUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="/scripts/dynamic-pwe/foreign-transfer-form.js")
public class ForeignTransfer {
    private static final Logger log = LoggerFactory.getLogger(ForeignTransfer.class);
    private static final String[] stringArrayParams = new String[]{"principalBankSwiftCode", "beneficiaryBankSwiftCode", "transferType", "referralCurrencyCode", "referenceCurrencyCode", "costAccounting"};
    private static final String[] stringArrayParamsWithoutDescription = new String[]{"feesAccountNumber", "references", "principalNameAndAddress", "beneficiaryCountryCode", "beneficiaryBankCountryCode", "beneficiaryBankNameAndAddress", "beneficiaryAccountNumber", "beneficiaryNameAndAddress", "paymentDetails", "principalAccountNumber"};
    private static final String[] integerArrayParams = new String[]{"shipmentNumber", "transferNumber"};
    private static final String[] doubleArrayParams = new String[]{"referenceCurrencyAmount", "referralCurrencyAmount"};
    private static final String[] OPTIONAL_EXTRA_PARAMETERS = new String[]{"extra1", "extra2", "extra3", "extra4"};
    private final Translator t = Translators.get((String)"com.suncode.plugin-plus-bnpparibas-integrator");
    @Autowired
    private DocumentService documentService;
    @Autowired
    private ElixirService elixirService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("plusbnpparibasintegrator.duals.ForeignTransfer")).name("plusbnpparibasintegrator.duals.ForeignTransfer.name")).description("plusbnpparibasintegrator.duals.ForeignTransfer.desc")).icon((Icon)DivanteIcon.MONEY)).category(new Category[]{Categories.PLUS_BNPPARIBAS_INTEGRATOR})).parameter().id("documentClassName").name("plusbnpparibasintegrator.duals.ForeignTransfer.param.documentClassName.name").description("plusbnpparibasintegrator.duals.ForeignTransfer.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("documentName").name("plusbnpparibasintegrator.duals.ForeignTransfer.param.documentName.name").description("plusbnpparibasintegrator.duals.ForeignTransfer.param.documentName.desc").type((Type)Types.STRING).create()).parameter().id("referralCurrencyDate").name("plusbnpparibasintegrator.duals.ForeignTransfer.param.referralCurrencyDate.name").type((Type)Types.DATE_ARRAY).create()).parameter().id("headerReference").name("plusbnpparibasintegrator.duals.ForeignTransfer.param.headerReference.name").type((Type)Types.STRING).create()).parameter().id("extraInfoCodes").name("plusbnpparibasintegrator.duals.ForeignTransfer.param.extraInfoCodes.name").description("plusbnpparibasintegrator.duals.ForeignTransfer.param.extraInfoCodes.desc").type((Type)Types.STRING_ARRAY).optional().create();
        Arrays.stream(OPTIONAL_EXTRA_PARAMETERS).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("plusbnpparibasintegrator.duals.ForeignTransfer.param." + key + ".name").type((Type)Types.STRING_ARRAY).optional().create();
        });
        Arrays.stream(stringArrayParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("plusbnpparibasintegrator.duals.ForeignTransfer.param." + key + ".name").description("plusbnpparibasintegrator.duals.ForeignTransfer.param." + key + ".desc").type((Type)Types.STRING_ARRAY).create();
        });
        Arrays.stream(stringArrayParamsWithoutDescription).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("plusbnpparibasintegrator.duals.ForeignTransfer.param." + key + ".name").type((Type)Types.STRING_ARRAY).create();
        });
        Arrays.stream(integerArrayParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("plusbnpparibasintegrator.duals.ForeignTransfer.param." + key + ".name").type((Type)Types.INTEGER_ARRAY).create();
        });
        Arrays.stream(doubleArrayParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("plusbnpparibasintegrator.duals.ForeignTransfer.param." + key + ".name").type((Type)Types.FLOAT_ARRAY).create();
        });
    }

    public void execute(Parameters parameters, WorkflowContext context) throws AcceptanceException {
        this.run(parameters, context);
    }

    public void set(Parameters parameters, WorkflowContext context) throws AcceptanceException {
        this.run(parameters, context);
    }

    private void run(Parameters parameters, WorkflowContext context) throws AcceptanceException {
        ForeignTransferParametersDto dto = ForeignTransferParametersDto.builder().principalBankSwiftCode((String[])parameters.get("principalBankSwiftCode", String[].class)).shipmentNumber((Integer[])parameters.get("shipmentNumber", Integer[].class)).transferNumber((Integer[])parameters.get("transferNumber", Integer[].class)).beneficiaryBankSwiftCode((String[])parameters.get("beneficiaryBankSwiftCode", String[].class)).transferType((String[])parameters.get("transferType", String[].class)).reference((String[])parameters.get("references", String[].class)).referralCurrencyDate((LocalDate[])parameters.get("referralCurrencyDate", LocalDate[].class)).referralCurrencyCode((String[])parameters.get("referralCurrencyCode", String[].class)).referralCurrencyAmount((Double[])parameters.get("referralCurrencyAmount", Double[].class)).principalNameAndAddress((String[])parameters.get("principalNameAndAddress", String[].class)).principalAccountNumber((String[])parameters.get("principalAccountNumber", String[].class)).feesAccountNumber((String[])parameters.get("feesAccountNumber", String[].class)).referenceCurrencyCode((String[])parameters.get("referenceCurrencyCode", String[].class)).referenceCurrencyAmount((Double[])parameters.get("referenceCurrencyAmount", Double[].class)).beneficiaryCountryCode((String[])parameters.get("beneficiaryCountryCode", String[].class)).beneficiaryBankCountryCode((String[])parameters.get("beneficiaryBankCountryCode", String[].class)).beneficiaryBankNameAndAddress((String[])parameters.get("beneficiaryBankNameAndAddress", String[].class)).beneficiaryAccountNumber((String[])parameters.get("beneficiaryAccountNumber", String[].class)).beneficiaryNameAndAddress((String[])parameters.get("beneficiaryNameAndAddress", String[].class)).paymentDetails((String[])parameters.get("paymentDetails", String[].class)).costAccounting((String[])parameters.get("costAccounting", String[].class)).extraInfoCodes((String[])parameters.get("extraInfoCodes", String[].class)).extra1((String[])parameters.get("extra1", String[].class)).extra2((String[])parameters.get("extra2", String[].class)).extra3((String[])parameters.get("extra3", String[].class)).extra4((String[])parameters.get("extra4", String[].class)).build();
        String documentName = (String)parameters.get("documentName", String.class);
        String headerReference = (String)parameters.get("headerReference", String.class);
        String documentClassName = (String)parameters.get("documentClassName", String.class);
        this.assertParameters(documentName, headerReference, dto);
        TempFile tempFile = new TempFile();
        try (InputStream inputStream = tempFile.getInputStream();){
            ForeignTransferHeaderDto transferHeader = ForeignTransferHeaderDto.builder().headerReference(headerReference).amountSum(Arrays.stream(dto.getReferralCurrencyAmount()).mapToDouble(Double::doubleValue).sum()).transferQuantity(dto.getReferralCurrencyAmount().length).principalBankSwiftCode(dto.getPrincipalBankSwiftCode()[0]).principalNameAndAddress(dto.getPrincipalNameAndAddress()[0]).filename(documentName).build();
            List<ForeignTransferDto> transfers = this.buildForeignTransfers(dto);
            this.elixirService.createForeignTransferFile(transferHeader, transfers, tempFile.getFile());
            this.documentService.addNewDocumentToArchive(documentClassName, documentName, inputStream, context, "admin");
        }
        catch (IOException e) {
            throw new AcceptanceException("IOException occurred!");
        }
        finally {
            tempFile.delete();
        }
    }

    private void assertParameters(String documentName, String headerReference, ForeignTransferParametersDto dto) throws AcceptanceException {
        try {
            ParameterAssertions.assertDocumentName(documentName);
            ElixirAssertions.assertNotEmpty(headerReference, this.t.getMessage("plusbnpparibasintegrator.duals.ForeignTransfer.param.emptyParam"));
            ParameterAssertions.assertEqualArrayLength(dto.getPrincipalBankSwiftCode(), dto.getShipmentNumber(), dto.getTransferNumber(), dto.getBeneficiaryBankSwiftCode(), dto.getTransferType(), dto.getReference(), dto.getReferralCurrencyDate(), dto.getReferralCurrencyCode(), dto.getReferralCurrencyAmount(), dto.getPrincipalNameAndAddress(), dto.getPrincipalAccountNumber(), dto.getFeesAccountNumber(), dto.getReferenceCurrencyCode(), dto.getReferenceCurrencyAmount(), dto.getBeneficiaryCountryCode(), dto.getBeneficiaryBankCountryCode(), dto.getBeneficiaryBankNameAndAddress(), dto.getBeneficiaryAccountNumber(), dto.getBeneficiaryNameAndAddress(), dto.getPaymentDetails(), dto.getCostAccounting(), dto.getExtraInfoCodes(), dto.getExtra1(), dto.getExtra2(), dto.getExtra3(), dto.getExtra4());
        }
        catch (IllegalArgumentException e) {
            throw new AcceptanceException(e.getMessage());
        }
    }

    private List<ForeignTransferDto> buildForeignTransfers(ForeignTransferParametersDto dto) {
        String prefix = "plusbnpparibasintegrator.duals.ForeignTransfer.param.";
        LinkedList<ForeignTransferDto> transfers = new LinkedList<ForeignTransferDto>();
        IntStream.range(0, dto.getReferralCurrencyAmount().length).forEach(index -> {
            ElixirAssertions.assertSwiftCode(dto.getPrincipalBankSwiftCode()[index], this.t.getMessage(prefix + "principalBankSwiftCode.name"));
            ElixirAssertions.assertNotEmpty(dto.getShipmentNumber()[index], this.t.getMessage(prefix + "shipmentNumber.name"));
            ElixirAssertions.assertNotEmpty(dto.getTransferNumber()[index], this.t.getMessage(prefix + "transferNumber.name"));
            ElixirAssertions.assertSwiftCode(dto.getBeneficiaryBankSwiftCode()[index], this.t.getMessage(prefix + "beneficiaryBankSwiftCode.name"));
            ElixirAssertions.assertNotEmpty(dto.getTransferType()[index], this.t.getMessage(prefix + "transferType.name"));
            ElixirAssertions.assertNotEmpty(dto.getReference()[index], this.t.getMessage(prefix + "references.name"));
            ElixirAssertions.assertNotEmpty(dto.getReferralCurrencyDate()[index], this.t.getMessage(prefix + "referralCurrencyDate.name"));
            ElixirAssertions.assertCurrency(dto.getReferralCurrencyCode()[index], this.t.getMessage(prefix + "referralCurrencyCode.name"));
            ElixirAssertions.assertAmount(dto.getReferralCurrencyAmount()[index], this.t.getMessage(prefix + "referralCurrencyAmount.name"));
            ElixirAssertions.assertNotEmpty(dto.getPrincipalNameAndAddress()[index], this.t.getMessage(prefix + "principalNameAndAddress.name"));
            ElixirAssertions.assertIbanAccountNumber(dto.getPrincipalAccountNumber()[index], this.t.getMessage(prefix + "principalAccountNumber.name"));
            ElixirAssertions.assertIbanAccountNumber(dto.getFeesAccountNumber()[index], this.t.getMessage(prefix + "feesAccountNumber.name"));
            ElixirAssertions.assertCurrency(dto.getReferenceCurrencyCode()[index], this.t.getMessage(prefix + "referenceCurrencyCode.name"));
            ElixirAssertions.assertAmount(dto.getReferenceCurrencyAmount()[index], this.t.getMessage(prefix + "referenceCurrencyAmount.name"));
            ElixirAssertions.assertCountryCode(dto.getBeneficiaryCountryCode()[index], this.t.getMessage(prefix + "beneficiaryCountryCode.name"));
            ElixirAssertions.assertCountryCode(dto.getBeneficiaryBankCountryCode()[index], this.t.getMessage(prefix + "beneficiaryBankCountryCode.name"));
            ElixirAssertions.assertNotEmpty(dto.getBeneficiaryBankNameAndAddress()[index], this.t.getMessage(prefix + "beneficiaryBankNameAndAddress.name"));
            ElixirAssertions.assertIbanAccountNumber(dto.getBeneficiaryAccountNumber()[index], this.t.getMessage(prefix + "beneficiaryAccountNumber.name"));
            ElixirAssertions.assertNotEmpty(dto.getBeneficiaryNameAndAddress()[index], this.t.getMessage(prefix + "beneficiaryNameAndAddress.name"));
            ElixirAssertions.assertNotEmpty(dto.getPaymentDetails()[index], this.t.getMessage(prefix + "paymentDetails.name"));
            ElixirAssertions.assertNotEmpty(dto.getCostAccounting()[index], this.t.getMessage(prefix + "costAccounting.name"));
            ElixirAssertions.assertNotEmpty(dto.getExtraInfoCodes()[index], this.t.getMessage(prefix + "extraInfoCodes.name"));
            transfers.add(ForeignTransferDto.builder().principalBankSwiftCode(dto.getPrincipalBankSwiftCode()[index]).shipmentNumber(dto.getShipmentNumber()[index]).transferNumber(dto.getTransferNumber()[index]).beneficiaryBankSwiftCode(dto.getBeneficiaryBankSwiftCode()[index]).transferType(dto.getTransferType()[index]).reference(dto.getReference()[index]).referralCurrencyDate(dto.getReferralCurrencyDate()[index]).referralCurrencyCode(dto.getReferralCurrencyCode()[index]).referralCurrencyAmount(dto.getReferralCurrencyAmount()[index]).principalNameAndAddress(dto.getPrincipalNameAndAddress()[index]).principalAccountNumber(dto.getPrincipalAccountNumber()[index]).feesAccountNumber(dto.getFeesAccountNumber()[index]).referenceCurrencyCode(dto.getReferenceCurrencyCode()[index]).referenceCurrencyAmount(dto.getReferenceCurrencyAmount()[index]).beneficiaryCountryCode(dto.getBeneficiaryCountryCode()[index]).beneficiaryBankCountryCode(dto.getBeneficiaryBankCountryCode()[index]).beneficiaryBankNameAndAddress(dto.getBeneficiaryNameAndAddress()[index]).beneficiaryAccountNumber(dto.getBeneficiaryAccountNumber()[index]).beneficiaryNameAndAddress(dto.getBeneficiaryNameAndAddress()[index]).paymentDetails(dto.getPaymentDetails()[index]).costAccounting(dto.getCostAccounting()[index]).extraInfoCodes(ParamUtils.getStringValue(dto.getExtraInfoCodes(), index)).extra1(ParamUtils.getStringValue(dto.getExtra1(), index)).extra2(ParamUtils.getStringValue(dto.getExtra2(), index)).extra3(ParamUtils.getStringValue(dto.getExtra3(), index)).extra4(ParamUtils.getStringValue(dto.getExtra4(), index)).build());
        });
        return transfers;
    }
}

