/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbnpparibasintegrator.duals;

import com.suncode.plugin.plusbnpparibasintegrator.Categories;
import com.suncode.plugin.plusbnpparibasintegrator.archive.services.DocumentService;
import com.suncode.plugin.plusbnpparibasintegrator.assertions.ElixirAssertions;
import com.suncode.plugin.plusbnpparibasintegrator.assertions.ParameterAssertions;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.dto.DomesticTransferDto;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.dto.DomesticTransferParametersDto;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.services.ElixirService;
import com.suncode.plugin.plusbnpparibasintegrator.elixir.util.ParamUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="/scripts/dynamic-pwe/domestic-transfer-form.js")
public class DomesticTransfer {
    private static final Logger log = LoggerFactory.getLogger(DomesticTransfer.class);
    private static final String[] stringArrayParams = new String[]{"principalAccountNumber", "beneficiaryAccountNumber", "beneficiaryNameAndAddress", "principalNameAndAddress", "paymentDetails", "references"};
    private final Translator t = Translators.get((String)"com.suncode.plugin-plus-bnpparibas-integrator");
    @Autowired
    private DocumentService documentService;
    @Autowired
    private ElixirService elixirService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("plusbnpparibasintegrator.duals.DomesticTransfer")).name("plusbnpparibasintegrator.duals.DomesticTransfer.name")).description("plusbnpparibasintegrator.duals.DomesticTransfer.desc")).category(new Category[]{Categories.PLUS_BNPPARIBAS_INTEGRATOR})).icon((Icon)DivanteIcon.MONEY)).parameter().id("documentClassName").name("plusbnpparibasintegrator.duals.DomesticTransfer.param.documentClassName.name").description("plusbnpparibasintegrator.duals.DomesticTransfer.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("documentName").name("plusbnpparibasintegrator.duals.DomesticTransfer.param.documentName.name").description("plusbnpparibasintegrator.duals.DomesticTransfer.param.documentName.desc").type((Type)Types.STRING).create()).parameter().id("executionDate").name("plusbnpparibasintegrator.duals.DomesticTransfer.param.executionDate.name").description("plusbnpparibasintegrator.duals.DomesticTransfer.param.executionDate.desc").type((Type)Types.DATE_ARRAY).create()).parameter().id("amount").name("plusbnpparibasintegrator.duals.DomesticTransfer.param.amount.name").description("plusbnpparibasintegrator.duals.DomesticTransfer.param.amount.desc").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("principalBankBillingNumber").name("plusbnpparibasintegrator.duals.DomesticTransfer.param.principalBankBillingNumber.name").type((Type)Types.INTEGER_ARRAY).create()).parameter().id("beneficiaryBankBillingNumber").name("plusbnpparibasintegrator.duals.DomesticTransfer.param.beneficiaryBankBillingNumber.name").type((Type)Types.INTEGER_ARRAY).create()).parameter().id("transferType").name("plusbnpparibasintegrator.duals.DomesticTransfer.param.transferType.name").description("plusbnpparibasintegrator.duals.DomesticTransfer.param.transferType.desc").type((Type)Types.INTEGER_ARRAY).create();
        Arrays.stream(stringArrayParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("plusbnpparibasintegrator.duals.DomesticTransfer.param." + key + ".name").type((Type)Types.STRING_ARRAY).create();
        });
    }

    public void execute(Parameters parameters, WorkflowContext context) throws AcceptanceException {
        this.run(parameters, context);
    }

    public void set(Parameters parameters, WorkflowContext context) throws AcceptanceException {
        this.run(parameters, context);
    }

    private void run(Parameters parameters, WorkflowContext context) throws AcceptanceException {
        DomesticTransferParametersDto dto = DomesticTransferParametersDto.builder().executionDate((LocalDate[])parameters.get("executionDate", LocalDate[].class)).amount((Double[])parameters.get("amount", Double[].class)).principalBankBillingNumber((Integer[])parameters.get("principalBankBillingNumber", Integer[].class)).principalAccountNumber((String[])parameters.get("principalAccountNumber", String[].class)).beneficiaryAccountNumber((String[])parameters.get("beneficiaryAccountNumber", String[].class)).principalNameAndAddress((String[])parameters.get("principalNameAndAddress", String[].class)).beneficiaryNameAndAddress((String[])parameters.get("beneficiaryNameAndAddress", String[].class)).beneficiaryBankBillingNumber((Integer[])parameters.get("beneficiaryBankBillingNumber", Integer[].class)).paymentDetails((String[])parameters.get("paymentDetails", String[].class)).transferType((Integer[])parameters.get("transferType", Integer[].class)).references((String[])parameters.get("references", String[].class)).build();
        String documentName = (String)parameters.get("documentName", String.class);
        String documentClassName = (String)parameters.get("documentClassName", String.class);
        this.assertParameters(documentName, dto);
        TempFile tempFile = new TempFile();
        try (InputStream inputStream = tempFile.getInputStream();){
            List<DomesticTransferDto> transfers = this.buildDomesticTransfers(dto);
            this.elixirService.createDomesticTransferFile(transfers, tempFile.getFile());
            this.documentService.addNewDocumentToArchive(documentClassName, documentName, inputStream, context, "admin");
        }
        catch (IOException e) {
            throw new AcceptanceException("IOException occurred!");
        }
        finally {
            tempFile.delete();
        }
    }

    private void assertParameters(String documentName, DomesticTransferParametersDto dto) throws AcceptanceException {
        try {
            ParameterAssertions.assertDocumentName(documentName);
            ParameterAssertions.assertEqualArrayLength(dto.getExecutionDate(), dto.getAmount(), dto.getPrincipalBankBillingNumber(), dto.getPrincipalAccountNumber(), dto.getBeneficiaryAccountNumber(), dto.getPrincipalNameAndAddress(), dto.getBeneficiaryNameAndAddress(), dto.getBeneficiaryBankBillingNumber(), dto.getPaymentDetails(), dto.getTransferType(), dto.getReferences());
        }
        catch (IllegalArgumentException e) {
            throw new AcceptanceException(e.getMessage());
        }
    }

    private List<DomesticTransferDto> buildDomesticTransfers(DomesticTransferParametersDto dto) {
        String prefix = "plusbnpparibasintegrator.duals.DomesticTransfer.param.";
        LinkedList<DomesticTransferDto> transfers = new LinkedList<DomesticTransferDto>();
        IntStream.range(0, dto.getAmount().length).forEach(index -> {
            ElixirAssertions.assertExecutionDate(dto.getExecutionDate()[index], this.t.getMessage(prefix + "executionDate.name"));
            ElixirAssertions.assertAmount(dto.getAmount()[index], this.t.getMessage(prefix + "amount.name"));
            ElixirAssertions.assertNotEmpty(dto.getPrincipalBankBillingNumber()[index], this.t.getMessage(prefix + "principalBankBillingNumber.name"));
            ElixirAssertions.assertPolishAccountNumber(dto.getPrincipalAccountNumber()[index], this.t.getMessage(prefix + "principalAccountNumber.name"));
            ElixirAssertions.assertPolishAccountNumber(dto.getBeneficiaryAccountNumber()[index], this.t.getMessage(prefix + "beneficiaryAccountNumber.name"));
            ElixirAssertions.assertNotEmpty(dto.getPrincipalNameAndAddress()[index], this.t.getMessage(prefix + "principalNameAndAddress.name"));
            ElixirAssertions.assertNotEmpty(dto.getBeneficiaryNameAndAddress()[index], this.t.getMessage(prefix + "beneficiaryNameAndAddress.name"));
            ElixirAssertions.assertNotEmpty(dto.getBeneficiaryBankBillingNumber()[index], this.t.getMessage(prefix + "beneficiaryBankBillingNumber.name"));
            ElixirAssertions.assertNotEmpty(dto.getPaymentDetails()[index], this.t.getMessage(prefix + "paymentDetails.name"));
            ElixirAssertions.assertTransferType(dto.getTransferType()[index], this.t.getMessage(prefix + "transferType.name"));
            transfers.add(DomesticTransferDto.builder().executionDate(dto.getExecutionDate()[index]).amount(dto.getAmount()[index]).principalBankBillingNumber(dto.getPrincipalBankBillingNumber()[index]).principalAccountNumber(dto.getPrincipalAccountNumber()[index]).beneficiaryAccountNumber(dto.getBeneficiaryAccountNumber()[index]).principalNameAndAddress(dto.getPrincipalNameAndAddress()[index]).beneficiaryNameAndAddress(dto.getBeneficiaryNameAndAddress()[index]).beneficiaryBankBillingNumber(dto.getBeneficiaryBankBillingNumber()[index]).paymentDetails(dto.getPaymentDetails()[index]).transferType(dto.getTransferType()[index]).references(ParamUtils.getStringValue(dto.getReferences(), index)).build());
        });
        return transfers;
    }
}

