/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbnpparibasintegrator.assertions;

import java.lang.reflect.Array;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class ParameterAssertions {
    private ParameterAssertions() {
    }

    public static void assertEqualArrayLength(Object ... arrays) {
        if (arrays.length <= 1) {
            return;
        }
        int length = Array.getLength(arrays[0]);
        IntStream.range(1, arrays.length).forEach(i -> {
            if (Array.getLength(arrays[i]) != length) {
                throw new IllegalArgumentException("Array parameters don't have the same length");
            }
        });
    }

    public static void assertDocumentName(String documentName) {
        if (StringUtils.isBlank((CharSequence)documentName)) {
            throw new IllegalArgumentException("Document name is empty");
        }
        if (StringUtils.isBlank((CharSequence)documentName.replace(".", ""))) {
            throw new IllegalArgumentException("Wrong document name: " + documentName);
        }
    }
}

