/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbnpparibasintegrator.archive.services;

import com.suncode.plugin.plusbnpparibasintegrator.archive.dto.DocumentClassDto;
import com.suncode.plugin.plusbnpparibasintegrator.archive.services.DocumentService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.workflow.WorkflowContext;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DocumentServiceImpl
implements DocumentService {
    @Autowired
    private com.suncode.pwfl.archive.DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;

    @Override
    public void addNewDocumentToArchive(String documentClassName, String documentName, InputStream inputStream, WorkflowContext workflowContext, String username) {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(documentClassName, new String[0]);
        Assert.notNull((Object)documentClass, (String)("Document Class: '" + documentClassName + "' doesn't exist"));
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(documentClass.getId());
        documentDefinition.setProcessId(workflowContext.getProcessId());
        documentDefinition.setInputStream(inputStream);
        documentDefinition.setUserName(username);
        documentDefinition.setFileName(documentName);
        documentDefinition.setActivityId(workflowContext.getActivityId());
        this.documentService.addDocument(documentDefinition);
    }

    @Override
    public CountedResult<DocumentClassDto> getDocumentClasses(String query, Integer start, Integer limit) {
        List classes = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((CharSequence)documentClass.getName(), (CharSequence)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        if (classes.size() >= start) {
            result.setData(classes.subList(start, Integer.min(start + limit, classes.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        result.setTotal((long)classes.size());
        return this.convertDocClassToDto((CountedResult<DocumentClass>)result);
    }

    private CountedResult<DocumentClassDto> convertDocClassToDto(CountedResult<DocumentClass> documentClasses) {
        List data = documentClasses.getData().stream().map(DocumentClassDto::fromEntity).collect(Collectors.toList());
        return new CountedResult(documentClasses.getTotal(), data);
    }
}

