/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbiometricsignature.signature.service;

import com.suncode.pdfutils.PdfUtils;
import com.suncode.pdfutils.support.ElementAlignment;
import com.suncode.pdfutils.support.ElementAnchor;
import com.suncode.pdfutils.support.TemporaryFile;
import com.suncode.pdfutils.watermark.WatermarkImage;
import com.suncode.plugin.plusbiometricsignature.pcm.configuration.InsertingSignatureImageSettings;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignatureImageService {
    private static final Logger log = LoggerFactory.getLogger(SignatureImageService.class);

    public InputStream getDocumentWithAddedImage(String base64Signature, InsertingSignatureImageSettings insertingSignatureSettings, InputStream fileStream, String fileName) throws Exception {
        String signatureImagePath = this.createSignatureImageOnDisk(base64Signature);
        log.debug("Temporary biometric signature image has been created and is stored in: " + signatureImagePath);
        WatermarkImage watermarkImage = this.createWatermarkImage(insertingSignatureSettings, signatureImagePath);
        byte[] bytes = IOUtils.toByteArray((InputStream)fileStream);
        InputStream modifiedDocumentStream = this.addSignatureImage(new ByteArrayInputStream(bytes), watermarkImage, fileName, insertingSignatureSettings.getPageNumber());
        log.debug("Biometric signature image has been added to the PDF document");
        return modifiedDocumentStream;
    }

    private String createSignatureImageOnDisk(String base64Signature) throws IOException {
        byte[] signatureBytes = this.decodeBase64String(base64Signature.split(",")[1]);
        String homePath = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        Path signatureImagePath = Paths.get(homePath, UUID.randomUUID() + ".png");
        BufferedImage signatureImage = ImageIO.read(new ByteArrayInputStream(signatureBytes));
        ImageIO.write((RenderedImage)signatureImage, "png", signatureImagePath.toFile());
        return signatureImagePath.toFile().getAbsolutePath();
    }

    private byte[] decodeBase64String(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    private WatermarkImage createWatermarkImage(InsertingSignatureImageSettings insertingSignatureSettings, String imagePath) {
        WatermarkImage watermarkImage = new WatermarkImage(imagePath);
        watermarkImage.setOpacity(insertingSignatureSettings.getOpacity());
        watermarkImage.setPercentagePositionX(insertingSignatureSettings.getPositionX());
        watermarkImage.setPercentagePositionY(insertingSignatureSettings.getPositionY());
        watermarkImage.setAlignment(ElementAlignment.valueOf((String)insertingSignatureSettings.getAlignment().name()));
        watermarkImage.setRotation(Float.valueOf(0.0f));
        watermarkImage.setAnchor(ElementAnchor.valueOf((String)insertingSignatureSettings.getAnchor().name()));
        watermarkImage.setRemovePDFSecurity(insertingSignatureSettings.getRemovePDFSecurity());
        return watermarkImage;
    }

    private InputStream addSignatureImage(InputStream stream, WatermarkImage watermark, String fileName, Integer pageNumber) throws Exception {
        String temporaryFileName = "temp_" + DateTime.now().getMillis() + "_" + fileName;
        TemporaryFile temporaryFile = new TemporaryFile(SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY), temporaryFileName);
        return PdfUtils.addWatermarkAsImageOnSpecifiedPage((InputStream)stream, (WatermarkImage)watermark, (TemporaryFile)temporaryFile, (Integer)pageNumber);
    }
}

