/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbiometricsignature.document.service;

import com.suncode.plugin.plusbiometricsignature.configuration.dto.ActionConfigurationDto;
import com.suncode.plugin.plusbiometricsignature.document.dto.DocumentClassDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BiometricSignatureDocumentService {
    private static final String SIGNED_FILE_SUFFIX_NAME = "_signed";
    private final DocumentClassService documentClassService;
    private final DocumentFinder documentFinder;
    private final FileService fileService;
    private final DocumentService documentService;

    @Autowired
    public BiometricSignatureDocumentService(DocumentClassService documentClassService, DocumentFinder documentFinder, FileService fileService, DocumentService documentService) {
        this.documentClassService = documentClassService;
        this.documentFinder = documentFinder;
        this.fileService = fileService;
        this.documentService = documentService;
    }

    public CountedResult<DocumentClassDto> getDocumentClasses(String query, Integer start, Integer limit) {
        if (StringUtils.isNumeric((CharSequence)query)) {
            DocumentClass documentClass2 = (DocumentClass)this.documentClassService.get((Serializable)Long.valueOf(Long.parseLong(query)));
            if (documentClass2 != null) {
                DocumentClassDto documentClassDto = DocumentClassDto.builder().id(documentClass2.getId()).name(documentClass2.getName()).build();
                return new CountedResult(1L, Collections.singletonList(documentClassDto));
            }
            return new CountedResult();
        }
        List documentClasses = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((CharSequence)documentClass.getName(), (CharSequence)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        List documentClassesDto = documentClasses.stream().map(documentClass -> new DocumentClassDto(documentClass.getId(), documentClass.getName())).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        if (documentClassesDto.size() >= start) {
            result.setData(documentClassesDto.subList(start, Integer.min(start + limit, documentClassesDto.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        result.setTotal((long)documentClassesDto.size());
        return result;
    }

    public InputStream getFileInputStream(Long fileId) {
        return this.fileService.getFileInputStream(fileId);
    }

    public WfFile readFileFromSystem(String documentSource, String processId, String documentClass, Integer fileId) {
        switch (documentSource) {
            case "DOCUMENT_FROM_DOCUMENT_CLASS": {
                return this.readFileFromProcess(processId, documentClass);
            }
            case "FILE_ID": {
                return this.readFileById(fileId);
            }
        }
        throw new IllegalArgumentException("Invalid document source parameter");
    }

    public WfDocument addSignedFileToArchive(ActionConfigurationDto actionConfiguration, WfFile wfFile, InputStream fileStream) throws Exception {
        switch (actionConfiguration.getSignedFileSavingMode()) {
            case "VERSION_SOURCE_DOCUMENT": {
                Long newestFileVersionId = this.addFileAsNewVersion(actionConfiguration, wfFile, fileStream);
                return this.documentService.getDocument(newestFileVersionId);
            }
            case "SAVE_AS_NEW_DOCUMENT": {
                return this.addFileAsNewDocument(actionConfiguration, wfFile, fileStream);
            }
        }
        throw new IllegalArgumentException("Invalid signed file saving mode parameter");
    }

    public DocumentClassDto getDocumentClassDto(String documentClassName) {
        if (StringUtils.isNumeric((CharSequence)documentClassName)) {
            Optional<Object> documentClass = Optional.of(this.documentClassService.get((Serializable)Long.valueOf(Long.parseLong(documentClassName))));
            return DocumentClassDto.builder().id(((DocumentClass)documentClass.get()).getId()).name(((DocumentClass)documentClass.get()).getName()).build();
        }
        DocumentClass documentClass = this.documentClassService.getAll(new String[0]).stream().filter(documentClassElement -> StringUtils.equalsIgnoreCase((CharSequence)documentClassElement.getName(), (CharSequence)documentClassName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid document class name parameter"));
        return DocumentClassDto.builder().id(documentClass.getId()).name(documentClass.getName()).build();
    }

    private WfFile readFileFromProcess(String processId, String documentClass) {
        WfDocument wfDocument = (WfDocument)this.documentFinder.getDocumentsFromProcessAndClass(processId, documentClass, new String[]{"documentClass"}).get(0);
        return wfDocument.getFile();
    }

    private WfFile readFileById(Integer fileId) {
        WfFile file = this.fileService.getFile(Long.valueOf(fileId.intValue()), new String[0]);
        if (file == null) {
            throw new RuntimeException("A file with id '" + fileId + "' does not exist in the archive");
        }
        return file;
    }

    private Long addFileAsNewVersion(ActionConfigurationDto actionConfiguration, WfFile wfFile, InputStream fileStream) throws Exception {
        DocumentDefinition documentDefinition = this.createDocumentDefinition(actionConfiguration, wfFile.getFileName(), fileStream);
        String currentDocState = this.fileService.getVersionForFile(Long.valueOf(wfFile.getId())).getState();
        if (currentDocState.equals(WfFileVersion.State.STATE_EDIT.toString())) {
            this.fileService.cancelCheckOut(Long.valueOf(wfFile.getId()));
        }
        this.fileService.checkOut(Long.valueOf(wfFile.getId()), actionConfiguration.getUserName());
        return this.fileService.checkIn(documentDefinition, Long.valueOf(wfFile.getId()), "");
    }

    private WfDocument addFileAsNewDocument(ActionConfigurationDto actionConfiguration, WfFile wfFile, InputStream fileStream) {
        DocumentDefinition documentDefinition = this.createDocumentDefinition(actionConfiguration, wfFile.getFileName(), fileStream);
        WfDocument wfDocument = this.documentService.addDocument(documentDefinition);
        if (Boolean.TRUE.equals(actionConfiguration.getAttachDocumentToProcess())) {
            this.documentService.attachDocumentToProcess(wfDocument, actionConfiguration.getUserName(), actionConfiguration.getProcessId(), actionConfiguration.getActivityId());
        }
        return wfDocument;
    }

    private DocumentDefinition createDocumentDefinition(ActionConfigurationDto actionConfiguration, String fileName, InputStream fileStream) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setFileName(this.resolveSignedFileName(fileName));
        documentDefinition.setUserName(actionConfiguration.getUserName());
        if (actionConfiguration.getSignedFileSavingMode().equals("SAVE_AS_NEW_DOCUMENT")) {
            documentDefinition.setDocumentClassId(this.getDocumentClassId(actionConfiguration.getDestinationDocumentClass()));
        }
        documentDefinition.setInputStream(fileStream);
        return documentDefinition;
    }

    private String resolveSignedFileName(String fileName) {
        if (FilenameUtils.removeExtension((String)fileName).toLowerCase().endsWith(SIGNED_FILE_SUFFIX_NAME)) {
            return fileName;
        }
        return FilenameUtils.removeExtension((String)fileName) + SIGNED_FILE_SUFFIX_NAME + "." + FilenameUtils.getExtension((String)fileName);
    }

    private Long getDocumentClassId(String documentClassName) {
        Long documentClassId = this.documentClassService.getDocumentClass(documentClassName, new String[0]).getId();
        Assert.notNull((Object)documentClassId, (String)("Document class name " + documentClassName + " does not exist in the archive"));
        return documentClassId;
    }
}

