/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbiometricsignature.configuration.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusbiometricsignature.configuration.dto.ActionConfigurationDto;
import com.suncode.plugin.plusbiometricsignature.configuration.dto.PCMConfigurationFileDto;
import com.suncode.plugin.plusbiometricsignature.document.service.BiometricSignatureDocumentService;
import com.suncode.plugin.plusbiometricsignature.pcm.configuration.InsertingSignatureImageSettings;
import com.suncode.plugin.plusbiometricsignature.signature.service.SignatureImageService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.CountedResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConfigurationService {
    private static final String DEFAULT_WACOM_SERVICE_PORT_NUMBER = "9000";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final BiometricSignatureDocumentService biometricSignatureDocumentService;
    private final SignatureImageService signatureImageService;
    private final ConfigurationFileService configurationFileService;
    private final Plugin plugin;

    @Autowired
    public ConfigurationService(BiometricSignatureDocumentService biometricSignatureDocumentService, SignatureImageService signatureImageService, ConfigurationFileService configurationFileService, Plugin plugin) {
        this.biometricSignatureDocumentService = biometricSignatureDocumentService;
        this.signatureImageService = signatureImageService;
        this.configurationFileService = configurationFileService;
        this.plugin = plugin;
    }

    public CountedResult<PCMConfigurationFileDto> getPCMConfigurationNames(String query, Integer start, Integer limit) {
        String[] configurationFiles = this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey());
        List resultList = Arrays.stream(configurationFiles).filter(file -> file.toLowerCase().contains(query.toLowerCase())).map(PCMConfigurationFileDto::new).collect(Collectors.toList());
        List resultsOnPage = resultList.subList(start, Math.min(resultList.size(), start + limit));
        return new CountedResult((long)resultList.size(), resultsOnPage);
    }

    /*
     * Exception decompiling
     */
    public WfDocument insertImageOnDocument(ActionConfigurationDto actionConfiguration) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getServicePortNumberFromPCM(String configurationName) throws IOException {
        InsertingSignatureImageSettings insertingSignatureSettings = this.readPCMInsertingSignatureConfiguration(configurationName);
        return Optional.ofNullable(insertingSignatureSettings.getPortNumber()).map(Object::toString).orElse(DEFAULT_WACOM_SERVICE_PORT_NUMBER);
    }

    private InsertingSignatureImageSettings readPCMInsertingSignatureConfiguration(String configurationName) throws IOException {
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configurationName);){
            String signatureConfiguration = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            InsertingSignatureImageSettings insertingSignatureImageSettings = (InsertingSignatureImageSettings)this.objectMapper.readValue(signatureConfiguration, InsertingSignatureImageSettings.class);
            return insertingSignatureImageSettings;
        }
    }

    private void validatePCMConfiguration(InsertingSignatureImageSettings configuration) {
        Assert.notNull((Object)((Object)configuration.getAlignment()), (String)"alignment cannot be null");
        Assert.notNull((Object)((Object)configuration.getAnchor()), (String)"anchor cannot be null");
        Assert.notNull((Object)configuration.getPageNumber(), (String)"pageNumber cannot be null");
        Assert.isTrue((configuration.getPageNumber() != 0 ? 1 : 0) != 0, (String)"pageNumber cannot be 0");
        Assert.notNull((Object)configuration.getPositionX(), (String)"positionX% cannot be null");
        Assert.isTrue((configuration.getPositionX() >= 0 && configuration.getPositionX() <= 100 ? 1 : 0) != 0, (String)"positionX% value must be between 0 and 100");
        Assert.notNull((Object)configuration.getPositionY(), (String)"positionY% cannot be null");
        Assert.isTrue((configuration.getPositionY() >= 0 && configuration.getPositionY() <= 100 ? 1 : 0) != 0, (String)"Parameter positionY% value must be between 0 and 100");
        Assert.notNull((Object)configuration.getOpacity(), (String)"opacity cannot be null");
        Assert.notNull((Object)configuration.getRemovePDFSecurity(), (String)"removePDFSecurity cannot be null");
    }
}

