/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusbiometricsignature.configuration.controller;

import com.suncode.plugin.plusbiometricsignature.configuration.dto.ActionConfigurationDto;
import com.suncode.plugin.plusbiometricsignature.configuration.dto.PCMConfigurationFileDto;
import com.suncode.plugin.plusbiometricsignature.configuration.service.ConfigurationService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/configuration"})
public class ConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationController.class);
    private final ConfigurationService configurationService;

    @Autowired
    public ConfigurationController(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @ResponseBody
    @RequestMapping(value={"PCMConfigurationFiles"}, method={RequestMethod.GET})
    public CountedResult<PCMConfigurationFileDto> getConfigurationFileNamesList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.configurationService.getPCMConfigurationNames(query, start, limit);
    }

    @ResponseBody
    @RequestMapping(value={"saveSignatureOnDocument"}, method={RequestMethod.POST}, consumes={"application/json"})
    public RestResult insertSignature(@RequestBody ActionConfigurationDto actionConfiguration) throws Exception {
        WfDocument wfDocument = this.configurationService.insertImageOnDocument(actionConfiguration);
        log.debug("A signed file '" + wfDocument.getFile().getFileName() + "' was added to the archive with document id " + wfDocument.getId() + " and file id " + wfDocument.getFile().getId());
        return new RestResult(true, "A file has been signed and successfully added to the archive");
    }

    @ResponseBody
    @RequestMapping(value={"wacomServicePortNumber"}, method={RequestMethod.GET})
    public String getServicePortNumber(@RequestParam String configurationName) throws IOException {
        return this.configurationService.getServicePortNumberFromPCM(configurationName);
    }
}

