/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautologin;

import com.suncode.plugin.plusautologin.pcm.ConfigurationDto;
import com.suncode.plugin.plusautologin.pcm.ConfigurationService;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.security.AuthenticationButton;
import com.suncode.pwfl.security.AuthenticationResult;
import com.suncode.pwfl.security.Authenticator;
import com.suncode.pwfl.security.SSOLogoutStatusCode;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AutologinAuthenticator
implements Authenticator {
    private static final String TOKEN_PARAM = "token";
    private static final String CONFIG_ID_PARAM = "configId";
    private static final String AUTHENTICATOR_ID = "autologin";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private UserService userService;

    public String getName() {
        return AUTHENTICATOR_ID;
    }

    public AuthenticationResult authenticate(HttpServletRequest request) {
        String token = request.getParameter(TOKEN_PARAM);
        String configId = request.getParameter(CONFIG_ID_PARAM);
        Optional<String> username = this.getUsername(configId, token);
        return username.map(name -> new AuthenticationResult(true, name)).orElseGet(() -> new AuthenticationResult(false, null));
    }

    private Optional<String> getUsername(String configId, String token) {
        try {
            ConfigurationDto configurationDto = this.configurationService.readConfiguration(configId);
            String configurationToken = configurationDto.getToken();
            String username = configurationDto.getUsername();
            if (StringUtils.isBlank((CharSequence)username) || !StringUtils.equals((CharSequence)configurationToken, (CharSequence)token) || !this.userService.isActive(username)) {
                return Optional.empty();
            }
            return Optional.of(username);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public AuthenticationButton authenticationButtonDefinition() {
        return null;
    }

    public String getLogoutRequest(HttpServletRequest request) {
        return null;
    }

    public boolean validLogoutRequest(HttpServletRequest request, HttpServletResponse response, String encodedRequest, String userName) throws Exception {
        return false;
    }

    public String getLogoutResponse(HttpServletRequest request) {
        return null;
    }

    public boolean validLogoutResponse(HttpServletRequest request, HttpServletResponse response, String logoutResponse) throws Exception {
        return false;
    }

    public void sendLogoutResponse(HttpServletRequest request, HttpServletResponse response, String logoutRequest, SSOLogoutStatusCode status) throws Exception {
    }

    public boolean sendLogoutRequest(HttpServletRequest request, HttpServletResponse response, String userName) throws Exception {
        return false;
    }
}

