/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.scheduledtasks;

import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusautenti.Categories;
import com.suncode.plugin.plusautenti.clientapi.service.AutentiApiService;
import com.suncode.plugin.plusautenti.configuration.dto.AutentiConnectionConfig;
import com.suncode.plugin.plusautenti.configuration.service.AutentiPCMConfig;
import com.suncode.plugin.plusautenti.scheduledtasks.dto.AutentiDocumentInfo;
import com.suncode.plugin.plusautenti.scheduledtasks.dto.CheckStatusDocumentsParameters;
import com.suncode.plugin.plusautenti.scheduledtasks.dto.CheckStatusDocumentsReturnData;
import com.suncode.plugin.plusautenti.scheduledtasks.enums.DocumentStatus;
import com.suncode.plugin.plusautenti.scheduledtasks.service.CheckDocumentService;
import com.suncode.plugin.plusautenti.scheduledtasks.util.ScheduledTaskUtil;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="scripts/scheduledtasks/CheckAutentiDocumentsStatus/scheduled_task_script.js")
public class CheckAutentiDocumentsStatus
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(CheckAutentiDocumentsStatus.class);
    private static final String SCHEDULED_TASK_ID = "plusautenti.scheduledTask.CheckAutentiDocumentsStatus";
    private static final String ROW_SEPARATOR = ";";
    private static final long RECONNECT_INTERVAL_MS = 1200000L;
    private static final long TIME_BETWEEN_REQUESTS_MS = 8000L;
    @Autowired
    CheckDocumentService checkDocumentTools;
    @Autowired
    ActivityService activityService;
    @Autowired
    ProcessService processService;
    @Autowired
    DocumentClassService documentClassService;
    @Autowired
    AutentiApiService autentiApiService;
    @Autowired
    AutentiPCMConfig autentiPCMConfiguration;
    private org.apache.log4j.Logger taskLog;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(SCHEDULED_TASK_ID)).name("plusautenti.scheduledTask.CheckAutentiDocumentsStatus.name")).description("plusautenti.scheduledTask.CheckAutentiDocumentsStatus.desc")).category(new Category[]{Categories.PLUS_AUTENTI})).cancelable();
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "pcmConfigurationId", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "processDefId", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "activityDefId", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "actionId", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "moreThanOneAutentiIdInProcess", (Type)Types.BOOLEAN);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "autentiDocIdVariable", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "documentStatusVariable", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "emailsVariableId", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "emailsOutVariableId", (Type)Types.STRING, true, true);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "autentiDocIdOutVariable", (Type)Types.STRING, true, true);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "userStatusVariableId", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "rejectionCommentVariableId", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "signedDocumentClassName", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "documentClassAutentiIdIdxName", (Type)Types.STRING);
        ScheduledTaskUtil.addNewParameter(builder, SCHEDULED_TASK_ID, "saveAsNewVersionIfAutentiIdExist", (Type)Types.BOOLEAN);
    }

    public String execute(Parameters parameters, org.apache.log4j.Logger taskLog) throws Exception {
        this.taskLog = taskLog;
        this.debug("Start scheduledTask: plusautenti.scheduledTask.CheckAutentiDocumentsStatus");
        int processedActivities = 0;
        int errorCount = 0;
        StringBuilder errorSummary = new StringBuilder();
        CheckStatusDocumentsParameters appParameters = this.checkDocumentTools.buildParametersObject(parameters);
        List<Activity> openActivities = this.checkDocumentTools.findOpenActivities(appParameters.getProcessDefId(), appParameters.getActivityDefId());
        this.debug("Found " + openActivities.size() + " tasks.");
        if (!openActivities.isEmpty()) {
            AutentiConnectionConfig autentiConfig = this.autentiPCMConfiguration.getAutentiConfig(appParameters.getPcmConfigurationId());
            this.autentiApiService.connect(autentiConfig);
            long lastConnectTime = System.currentTimeMillis();
            for (int i = 0; i < openActivities.size(); ++i) {
                Activity activity = openActivities.get(i);
                try {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastConnectTime >= 1200000L) {
                        this.debug("Reconnect");
                        this.autentiApiService.connect(autentiConfig);
                        lastConnectTime = currentTime;
                    }
                    this.debug("Update activity: " + activity.getActivityId());
                    DocumentStatus documentStatus = appParameters.isMoreThanOneAutentiIdInProcess() ? this.updateActivityWithManyAutentiDocuments(activity, appParameters, autentiConfig) : this.updateActivityWithOneAutentiDocument(activity, appParameters, autentiConfig);
                    ++processedActivities;
                    Thread.sleep(documentStatus == DocumentStatus.COMPLETED ? 16000L : 8000L);
                    continue;
                }
                catch (Exception e) {
                    ++errorCount;
                    String msg = "Error while processing activity " + activity.getActivityId() + ": " + e.getClass().getSimpleName() + " - " + e.getMessage();
                    taskLog.error((Object)msg, (Throwable)e);
                    log.error(msg, (Throwable)e);
                    errorSummary.append(msg).append("\n");
                }
            }
        }
        StringBuilder result = new StringBuilder();
        result.append(processedActivities).append(" activity processed");
        if (errorCount > 0) {
            result.append(", ").append(errorCount).append(" errors\n").append("Errors:\n").append((CharSequence)errorSummary);
        } else {
            result.append(" without errors");
        }
        return result.toString();
    }

    private DocumentStatus updateActivityWithManyAutentiDocuments(Activity activity, CheckStatusDocumentsParameters appParameters, AutentiConnectionConfig autentiConfig) throws Exception {
        Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        List<String> autentiDocIds = Arrays.asList(activityContext.get(appParameters.getAutentiDocIdVariable()).toString().split(ROW_SEPARATOR, -1));
        CheckStatusDocumentsReturnData checkStatusDocumentsReturnData = new CheckStatusDocumentsReturnData();
        for (int i = 0; i < autentiDocIds.size(); ++i) {
            String autentiDocId = autentiDocIds.get(i);
            if (StringUtils.isBlank((CharSequence)autentiDocId)) continue;
            List<String> signerEmails = Arrays.asList(activityContext.get(appParameters.getEmailsVariableId()).toString().split(ROW_SEPARATOR, -1));
            AutentiDocumentInfo autentiDocumentInfo = this.checkDocumentTools.getAutentiDocumentInfo(autentiDocId, autentiConfig, signerEmails);
            this.debug(activity.getActivityId() + ", AutentiDocId: " + autentiDocId + ", STATUS: " + autentiDocumentInfo.getDocumentStatus());
            checkStatusDocumentsReturnData.getDocumentStatusList().add(i, autentiDocumentInfo.getDocumentStatus());
            checkStatusDocumentsReturnData.getEmailOut().addAll(signerEmails);
            checkStatusDocumentsReturnData.getAutentiDocIdsOut().addAll(Collections.nCopies(signerEmails.size(), autentiDocId));
            checkStatusDocumentsReturnData.getSignStatusList().addAll(autentiDocumentInfo.getSignerStatusArray());
            checkStatusDocumentsReturnData.getRejectionComment().addAll(autentiDocumentInfo.getRejectionCommentArray());
            if (!autentiDocumentInfo.getDocumentStatus().equals(DocumentStatus.COMPLETED.name())) continue;
            this.checkDocumentTools.addSignedDocumentToActivity(activity, appParameters.getSignedDocumentClassName(), appParameters.getDocumentClassAutentiIdIdxName(), appParameters.isSaveAsNewVersionIfAutentiIdExist(), autentiConfig, autentiDocId);
            this.debug("The signed document has been added to the task");
        }
        this.updateContext(appParameters, (Map<String, Object>)activityContext, checkStatusDocumentsReturnData);
        return this.checkDocumentTools.acceptOrUpdateActivity(activity, appParameters.getActionId(), (Map<String, Object>)activityContext, checkStatusDocumentsReturnData.getDocumentStatusList());
    }

    private void updateContext(CheckStatusDocumentsParameters appParameters, Map<String, Object> activityContext, CheckStatusDocumentsReturnData checkStatusDocumentsReturnData) {
        this.setValueInContext(activityContext, appParameters.getUserStatusVariableId(), String.join((CharSequence)ROW_SEPARATOR, checkStatusDocumentsReturnData.getSignStatusList()));
        this.setValueInContext(activityContext, appParameters.getRejectionCommentVariableId(), String.join((CharSequence)ROW_SEPARATOR, checkStatusDocumentsReturnData.getRejectionComment()));
        this.setValueInContext(activityContext, appParameters.getDocumentStatusVariable(), String.join((CharSequence)ROW_SEPARATOR, checkStatusDocumentsReturnData.getDocumentStatusList()));
        this.setValueInContext(activityContext, appParameters.getAutentiDocIdOutVariable(), String.join((CharSequence)ROW_SEPARATOR, checkStatusDocumentsReturnData.getAutentiDocIdsOut()));
        this.setValueInContext(activityContext, appParameters.getEmailsOutVariableId(), String.join((CharSequence)ROW_SEPARATOR, checkStatusDocumentsReturnData.getEmailOut()));
    }

    private void setValueInContext(Map<String, Object> activityContext, String key, Object value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (activityContext.containsKey(key)) {
            activityContext.put(key, value);
        } else {
            this.taskLog.warn((Object)("Variable " + key + " does not exist in the task context\n"));
        }
    }

    private DocumentStatus updateActivityWithOneAutentiDocument(Activity activity, CheckStatusDocumentsParameters appParameters, AutentiConnectionConfig autentiConfig) throws Exception {
        Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        String autentiDocId = (String)activityContext.get(appParameters.getAutentiDocIdVariable());
        if (autentiDocId.isEmpty()) {
            this.debug("No autentiId in process: " + activity.getProcessId());
            return null;
        }
        List<String> signerEmails = Arrays.asList(activityContext.get(appParameters.getEmailsVariableId()).toString().split(ROW_SEPARATOR, -1));
        AutentiDocumentInfo autentiDocumentInfo = this.checkDocumentTools.getAutentiDocumentInfo(autentiDocId, autentiConfig, signerEmails);
        this.debug(activity.getActivityId() + ", AutentiDocId: " + autentiDocId + ", STATUS: " + autentiDocumentInfo.getDocumentStatus());
        if (autentiDocumentInfo.getDocumentStatus().equals(DocumentStatus.COMPLETED.name())) {
            this.checkDocumentTools.addSignedDocumentToActivity(activity, appParameters.getSignedDocumentClassName(), appParameters.getDocumentClassAutentiIdIdxName(), appParameters.isSaveAsNewVersionIfAutentiIdExist(), autentiConfig, autentiDocId);
            this.debug("The signed document has been added to the task");
        }
        this.updateContext(appParameters, (Map<String, Object>)activityContext, autentiDocumentInfo);
        return this.checkDocumentTools.acceptOrUpdateActivity(activity, appParameters.getActionId(), (Map<String, Object>)activityContext, autentiDocumentInfo.getDocumentStatus());
    }

    private void updateContext(CheckStatusDocumentsParameters appParameters, Map<String, Object> activityContext, AutentiDocumentInfo autentiDocumentInfo) {
        this.setValueInContext(activityContext, appParameters.getEmailsVariableId(), String.join((CharSequence)ROW_SEPARATOR, autentiDocumentInfo.getSignerEmailsArray()));
        this.setValueInContext(activityContext, appParameters.getUserStatusVariableId(), String.join((CharSequence)ROW_SEPARATOR, autentiDocumentInfo.getSignerStatusArray()));
        this.setValueInContext(activityContext, appParameters.getRejectionCommentVariableId(), String.join((CharSequence)ROW_SEPARATOR, autentiDocumentInfo.getRejectionCommentArray()));
        this.setValueInContext(activityContext, appParameters.getDocumentStatusVariable(), String.join((CharSequence)ROW_SEPARATOR, autentiDocumentInfo.getDocumentStatus()));
    }

    private void debug(String msg) {
        log.debug(msg);
        this.taskLog.debug((Object)msg);
    }
}

