/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.document.controller;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.search.CountedResult;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/documents"})
public class DocumentController {
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    @Autowired
    DocumentClassService documentClassService;

    @ResponseBody
    @RequestMapping(value={"classes"}, method={RequestMethod.GET})
    public CountedResult<Map<String, String>> getAllProcessType() {
        List documentClasses = this.documentClassService.getAll(new String[0]);
        CountedResult result = new CountedResult();
        result.setTotal((long)documentClasses.size());
        result.setData(documentClasses.stream().map(documentClass -> ImmutableMap.of((Object)"name", (Object)documentClass.getName())).collect(Collectors.toList()));
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"indexes"}, method={RequestMethod.GET})
    public CountedResult<Map<String, String>> getActivitiesFromProcess(@RequestParam String documentClassName) {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(documentClassName, new String[]{"indexes"});
        CountedResult result = new CountedResult();
        if (documentClass != null && documentClass.getIndexes() != null) {
            result.setTotal((long)documentClass.getIndexes().size());
            result.setData(documentClass.getIndexes().stream().map(index -> ImmutableMap.of((Object)"name", (Object)index.getName())).collect(Collectors.toList()));
        }
        return result;
    }
}

