/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.applications;

import com.suncode.plugin.plusautenti.Categories;
import com.suncode.plugin.plusautenti.clientapi.exception.AutentiClientApiException;
import com.suncode.plugin.plusautenti.clientapi.service.AutentiApiService;
import com.suncode.plugin.plusautenti.configuration.dto.AutentiConnectionConfig;
import com.suncode.plugin.plusautenti.configuration.service.AutentiPCMConfig;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Application
@Transactional
@ComponentsFormScript(value="scripts/applications/WithdrawDocument/pwe_dynamic_form.js")
public class WithdrawDocument {
    private static final Logger log = LoggerFactory.getLogger(WithdrawDocument.class);
    @Autowired
    private AutentiApiService autentiApiService;
    @Autowired
    private AutentiPCMConfig autentiPCMConfiguration;
    private static final String ID = "plusautenti.applications.WithdrawDocument";

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).icon((Icon)DivanteIcon.DELETE)).category(new Category[]{Categories.PLUS_AUTENTI})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}withdraw-document")).parameter().id("pcmConfigurationId").name(ID.concat(".param.pcmConfigurationId.name")).description(ID.concat(".param.pcmConfigurationId.desc")).type((Type)Types.STRING).create()).parameter().id("documentId").name(ID.concat(".param.documentId.name")).description(ID.concat(".param.documentId.desc")).type((Type)Types.STRING).create();
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            log.info("[PlusAutenti] Withdrawing document");
            String pcmConfigurationId = (String)parameters.get("pcmConfigurationId", String.class);
            String documentId = (String)parameters.get("documentId", String.class);
            AutentiConnectionConfig autentiConnectionConfig = this.autentiPCMConfiguration.getAutentiConfig(pcmConfigurationId);
            this.autentiApiService.connect(autentiConnectionConfig);
            this.autentiApiService.withdrawDocument(autentiConnectionConfig, documentId);
            log.info("[PlusAutenti] Document withdrawn successfully: " + documentId);
        }
        catch (AutentiClientApiException | IOException e) {
            log.error("[PlusAutenti] Error while withdrawing document: ", (Throwable)e);
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

