PW.ScheduledTasks.register('plusautenti.scheduledTask.CheckAutentiDocumentsStatus', {

    API_URL: Suncode.getAbsolutePath('plugin/com.suncode.plugin-plus-autenti/'),
    t: PW.I18N.createT("com.suncode.plugin-plus-autenti"),
    buildParams: function (form) {
        try {
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'pcmConfigurationId'), {}));
            form.addCombobox(this.getComboboxDefinitionProcessDefId(form));
            form.addCombobox(this.getComboboxDefinitionActivityDefId(form));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'actionId'), {}));
            form.addField(this.getComboboxDefinitionMoreThanOneAutentiIdInProcess(form));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'autentiDocIdVariable'), {}));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'documentStatusVariable'), {}));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'emailsVariableId'), {}));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'emailsOutVariableId'), {}));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'autentiDocIdOutVariable'), {}));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'userStatusVariableId'), {}));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'rejectionCommentVariableId'), {}));
            form.addCombobox(this.getComboboxDefinitionDocumentClasses(form));
            form.addCombobox(this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'documentClassAutentiIdIdxName'), {}));
            form.addField('saveAsNewVersionIfAutentiIdExist');
        } catch (e) {
            console.log(e);
        }
    },
    getComboboxDefinitionMoreThanOneAutentiIdInProcess: function (form) {
        return {
            id: 'moreThanOneAutentiIdInProcess',
            listeners: {
                select: function (field, newValue) {
                    if (newValue === true) {
                        form.hide('emailsOutVariableId');
                        form.hide('autentiDocIdOutVariable');
                    } else {
                        form.show('emailsOutVariableId');
                        form.show('autentiDocIdOutVariable');
                    }
                }
            }
        }
    },

    getComboboxDefinitionProcessDefId: function (form) {
        let listeners = {
            change: () => {
                this.clearAndReloadCombobox(form, ['activityDefId', 'actionId', 'autentiDocIdVariable', 'documentStatusVariable', 'emailsVariableId',
                    'emailsOutVariableId', 'autentiDocIdOutVariable', 'userStatusVariableId', 'rejectionCommentVariableId', 'signedDocumentClassName',
                    'documentClassAutentiIdIdxName']);
            }
        }
        return this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'processDefId'), listeners);
    },
    getComboboxDefinitionActivityDefId: function (form) {
        let listeners = {
            change: () => {
                this.clearAndReloadCombobox(form, ['actionId']);
            }
        }
        return this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'activityDefId'), listeners);
    },

    getComboboxDefinitionDocumentClasses: function (form) {
        let listeners = {
            change: () => {
                this.clearAndReloadCombobox(form, ['documentClassAutentiIdIdxName']);
            }
        }
        return this.buildConfigGetRequestToServer(this.urlInfoForCombobox(form, 'signedDocumentClassName'), listeners);
    },

    reloadCombobox: function (form, id) {
        let combobox = Ext.getCmp(id);
        combobox.store.proxy.setUrl(this.urlInfoForCombobox(form, id).url, true);
        combobox.store.load();
    },

    clearAndReloadCombobox: function (form, variableIds) {
        variableIds.forEach(id => {
            form.setValue(id, '');
            this.reloadCombobox(form, id);
        });
    },

    urlInfoForCombobox: function (form, id) {

        switch (id) {
            case 'pcmConfigurationId':
                return {
                    id: id,
                    url: this.API_URL + 'pcm/configurations',
                    valueField: 'key',
                    displayField: 'key'
                };
            case 'processDefId':
                return {
                    id: id,
                    url: this.API_URL + 'scheduledtask/processes',
                    valueField: 'processDefId',
                    displayField: 'name'
                }
            case 'activityDefId':
                return {
                    id: id,
                    url: this.API_URL + 'scheduledtask/activities?processDefId=' + form.getValue('processDefId'),
                    valueField: 'activityDefId',
                    displayField: 'name'
                }
            case 'actionId':
                return {
                    id: id,
                    url: this.API_URL + 'scheduledtask/activityActions?' + 'processDefId=' + form.getValue('processDefId') +
                        '&activityDefId=' + form.getValue('activityDefId'),
                    valueField: 'actionName',
                    displayField: 'buttonName'
                }

            case 'autentiDocIdVariable':
            case 'documentStatusVariable':
            case 'emailsVariableId':
            case 'emailsOutVariableId':
            case 'autentiDocIdOutVariable':
            case 'userStatusVariableId':
            case 'rejectionCommentVariableId':
                return {
                    id: id,
                    url: this.API_URL + 'scheduledtask/activityVariables?' +
                        'processDefId=' + form.getValue('processDefId') +
                        '&indexType=' + 'STRING' +
                        '&isTabular=' + 'false',
                    valueField: 'id',
                    displayField: 'name'
                }
            case 'signedDocumentClassName':
                return {
                    id: id,
                    url: this.API_URL + 'documents/classes',
                    valueField: 'name',
                    displayField: 'name'
                }
            case 'documentClassAutentiIdIdxName':
                return {
                    id: id,
                    url: this.API_URL + 'documents/indexes?documentClassName=' + form.getValue('signedDocumentClassName'),
                    valueField: 'name',
                    displayField: 'name'
                }
            default:
                return '';
        }
    },

    buildConfigGetRequestToServer: function (urlInfo, listeners) {
        return {
            id: urlInfo.id,
            valueField: urlInfo.valueField,
            displayField: urlInfo.displayField,
            remote: {
                url: urlInfo.url,
                remoteSort: false,
                pageSize: 20,
                batch: true
            },
            sort: {
                field: urlInfo.valueField,
                direction: 'ASC'
            },
            listeners: listeners
        };
    }
});