/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.scheduledtasks.service;

import com.suncode.plugin.plusautenti.clientapi.dto.ParticipantsStatus;
import com.suncode.plugin.plusautenti.clientapi.exception.AutentiClientApiException;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocument;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentPartiesEvent;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentPartiesPartyContact;
import com.suncode.plugin.plusautenti.clientapi.service.AutentiApiService;
import com.suncode.plugin.plusautenti.configuration.dto.AutentiConnectionConfig;
import com.suncode.plugin.plusautenti.document.service.AutentiDocumentService;
import com.suncode.plugin.plusautenti.scheduledtasks.dto.AutentiDocumentInfo;
import com.suncode.plugin.plusautenti.scheduledtasks.dto.CheckStatusDocumentsParameters;
import com.suncode.plugin.plusautenti.scheduledtasks.enums.DocumentStatus;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.UserIsNotAssignedToActivityException;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.FileSystemUtils;

@Service
public class CheckDocumentService {
    private static final String BUFOR_USERNAME_KEY = "Bufor.username";
    @Autowired
    ActivityFinder activityFinder;
    @Autowired
    ActivityService activityService;
    @Autowired
    DocumentClassService documentClassService;
    @Autowired
    DocumentService documentService;
    @Autowired
    DocumentFinder documentFinder;
    @Autowired
    FileService fileService;
    @Autowired
    AutentiApiService autentiApiService;
    @Autowired
    AutentiDocumentService autentiDocumentService;
    @Autowired
    ProcessFinder processFinder;

    public CheckStatusDocumentsParameters buildParametersObject(Parameters parameters) {
        CheckStatusDocumentsParameters.CheckStatusDocumentsParametersBuilder checkStatusDocumentsParametersBuilder = CheckStatusDocumentsParameters.builder().processDefId((String)parameters.get("processDefId", String.class)).activityDefId((String)parameters.get("activityDefId", String.class)).actionId((String)parameters.get("actionId", String.class)).moreThanOneAutentiIdInProcess((Boolean)parameters.get("moreThanOneAutentiIdInProcess", Boolean.class)).autentiDocIdVariable((String)parameters.get("autentiDocIdVariable", String.class)).documentStatusVariable((String)parameters.get("documentStatusVariable", String.class)).emailsVariableId((String)parameters.get("emailsVariableId", String.class)).userStatusVariableId((String)parameters.get("userStatusVariableId", String.class)).rejectionCommentVariableId((String)parameters.get("rejectionCommentVariableId", String.class)).signedDocumentClassName((String)parameters.get("signedDocumentClassName", String.class)).documentClassAutentiIdIdxName((String)parameters.get("documentClassAutentiIdIdxName", String.class)).saveAsNewVersionIfAutentiIdExist((Boolean)parameters.get("saveAsNewVersionIfAutentiIdExist", Boolean.class)).pcmConfigurationId((String)parameters.get("pcmConfigurationId", String.class));
        if (parameters.exists("emailsOutVariableId")) {
            checkStatusDocumentsParametersBuilder.emailsOutVariableId((String)parameters.get("emailsOutVariableId", String.class));
        }
        if (parameters.exists("autentiDocIdOutVariable")) {
            checkStatusDocumentsParametersBuilder.autentiDocIdOutVariable((String)parameters.get("autentiDocIdOutVariable", String.class));
        }
        return checkStatusDocumentsParametersBuilder.build();
    }

    public List<Activity> findOpenActivities(String processDefinitionId, String activityDefinitionId) {
        return this.activityFinder.findActivities(processDefinitionId, activityDefinitionId, Arrays.asList(ActivityState.RUNNING, ActivityState.NOT_STARTED), new String[0]);
    }

    @Transactional
    public DocumentStatus acceptOrUpdateActivity(Activity activity, String actionId, Map<String, Object> activityContext, String documentStatusList) throws ActivityIsSuspendedException, UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException {
        return this.acceptOrUpdateActivity(activity, actionId, activityContext, Arrays.asList(documentStatusList));
    }

    @Transactional
    public DocumentStatus acceptOrUpdateActivity(Activity activity, String actionId, Map<String, Object> activityContext, List<String> documentStatusList) throws ActivityIsSuspendedException, UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException {
        if (documentStatusList.contains(DocumentStatus.PROCESSING.name())) {
            this.activityService.setActivityContext(activity.getProcessId(), activity.getActivityId(), activityContext);
            return DocumentStatus.PROCESSING;
        }
        this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
        return DocumentStatus.COMPLETED;
    }

    private void acceptActivity(String processId, String activityId, Map<String, Object> contextMap, String actionName) {
        String executor = SystemProperties.getString((String)BUFOR_USERNAME_KEY);
        AcceptationDefinition acceptationDefinition = new AcceptationDefinition(processId, activityId, executor, actionName, contextMap, true);
        acceptationDefinition.setIgnoreValidators(Boolean.valueOf(false));
        this.activityService.acceptActivity(acceptationDefinition);
    }

    public void attachNewDocument(Path filePath, Activity activity, Long classId, String autentiIdIdxName, String autentiDocId, boolean saveAsNewVersionIfAutentiIdExist, String user) throws Exception {
        DocumentDefinition definition = this.autentiDocumentService.buildDocumentDefinition(activity, filePath, classId, user);
        long orgDocumentId = -1L;
        if (saveAsNewVersionIfAutentiIdExist) {
            orgDocumentId = this.findAutentiDocumentInArchive(classId, autentiIdIdxName, autentiDocId);
        }
        if (orgDocumentId > -1L) {
            this.autentiDocumentService.addDocumentAsNewVersion(definition, orgDocumentId, user);
        } else {
            WfDocument wfDocument = this.documentService.addDocument(definition);
            if (!autentiIdIdxName.isEmpty()) {
                wfDocument.setIndexValue(autentiIdIdxName, (Object)autentiDocId);
            }
            this.documentService.attachDocumentToProcess(wfDocument, user, activity.getProcessId(), activity.getActivityId());
        }
    }

    private long findAutentiDocumentInArchive(Long classId, String autentiIdIdxName, String autentiDocId) {
        DocumentClass docClass = (DocumentClass)this.documentClassService.get((Serializable)classId, new String[]{"indexes"});
        Optional<Long> idxId = docClass.getIndexes().stream().filter(d -> d.getName().equals(autentiIdIdxName)).map(DocumentClassIndex::getId).findFirst();
        Assert.isTrue((boolean)idxId.isPresent(), (String)String.format("Index %s does not exist in the document class id: %o", autentiIdIdxName, classId));
        HashMap<Long, String> idx = new HashMap<Long, String>();
        idx.put(idxId.get(), autentiDocId);
        CountedResult result = this.documentFinder.findByIndexes(classId, idx, new LinkedList(), Integer.valueOf(0), Integer.valueOf(1), new String[0]);
        if (result.getTotal() == 1L) {
            return ((WfDocument)result.getData().get(0)).getFile().getId();
        }
        return -1L;
    }

    public void addSignedDocumentToActivity(Activity activity, String className, String autentiIdIndexName, boolean saveAsNewVersion, AutentiConnectionConfig autentiConfig, String autentiDocId) throws Exception {
        Path signedFilePath = this.autentiApiService.downloadSignedDocument(autentiConfig, autentiDocId);
        long docClassId = this.documentClassService.getDocumentClass(className, new String[0]).getId();
        this.attachNewDocument(signedFilePath, activity, docClassId, autentiIdIndexName, autentiDocId, saveAsNewVersion, SystemProperties.getString((String)BUFOR_USERNAME_KEY));
        FileSystemUtils.deleteRecursively((File)signedFilePath.toFile());
    }

    public AutentiDocumentInfo getAutentiDocumentInfo(String autentiDocId, AutentiConnectionConfig autentiConfig, List<String> signerEmails) throws IOException, AutentiClientApiException {
        AutentiDocument autentiDocument = this.autentiApiService.getAutentiDocument(autentiConfig, autentiDocId);
        AutentiDocumentInfo autentiDocumentInfo = new AutentiDocumentInfo();
        autentiDocumentInfo.setAutentiId(autentiDocId);
        autentiDocumentInfo.setDocumentStatus(autentiDocument.getStatus());
        List<ParticipantsStatus> participantsStatuses = this.getParticipantsStatuses(autentiDocument);
        Map participantsStatusByEmail = participantsStatuses.stream().collect(Collectors.toMap(ParticipantsStatus::getEmail, Function.identity(), (first, last) -> first));
        List<ParticipantsStatus> sortedPartiesStatus = signerEmails.stream().map(email -> participantsStatusByEmail.getOrDefault(email, this.addMissingEmailStatus((String)email))).collect(Collectors.toList());
        autentiDocumentInfo.setParticipantsStatuses(sortedPartiesStatus);
        return autentiDocumentInfo;
    }

    private ParticipantsStatus addMissingEmailStatus(String email) {
        return ParticipantsStatus.builder().status("EMAIL_NOT_FOUND").email(email).rejectionComment("Missing e-mail address").build();
    }

    private List<ParticipantsStatus> getParticipantsStatuses(AutentiDocument autentiDocument) {
        return autentiDocument.getParties().stream().map(part -> {
            Optional<AutentiDocumentPartiesPartyContact> firstPartyContact = part.getParty().getContacts().stream().filter(c -> c.getType().equals("CONTACT-TYPE:EMAIL")).findFirst();
            String email = firstPartyContact.isPresent() ? firstPartyContact.get().getAttributes().getEmail() : "";
            Optional<AutentiDocumentPartiesEvent> signatureRejection = part.getEvents().stream().filter(event -> event.getEventType().contains("SIGNATURE_REJECTION")).findFirst();
            String rejectComment = signatureRejection.isPresent() ? signatureRejection.get().getAttributes().getComment() : "";
            return ParticipantsStatus.builder().status(part.getParticipationStatus()).email(email).rejectionComment(rejectComment).build();
        }).collect(Collectors.toList());
    }
}

