/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.scheduledtasks.controller;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.workflow.activity.ActivityType;
import com.suncode.pwfl.workflow.form.AcceptButton;
import com.suncode.pwfl.workflow.form.FormService;
import com.suncode.pwfl.workflow.process.IndexType;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scheduledtask"})
public class ScheduledTaskController {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskController.class);
    @Autowired
    ConfigurationFileService configurationFileService;
    @Autowired
    ProcessService processService;
    @Autowired
    FormService formService;

    @ResponseBody
    @RequestMapping(value={"processes"}, method={RequestMethod.GET})
    public CountedResult<ProcessType> getAllProcessType(@RequestParam int start, @RequestParam int limit, @RequestParam String query) {
        List allProcessTypes = this.processService.getAllProcessTypes(false).stream().filter(processType -> processType.getName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        return this.getCountedResult(start, limit, allProcessTypes);
    }

    @ResponseBody
    @RequestMapping(value={"activities"}, method={RequestMethod.GET})
    public CountedResult<ActivityType> getActivitiesFromProcess(@RequestParam String processDefId, @RequestParam int start, @RequestParam int limit, @RequestParam String query) {
        if (StringUtils.isEmpty((CharSequence)processDefId)) {
            return new CountedResult();
        }
        List activityTypes = this.processService.getActivityTypes(processDefId).stream().filter(activityType -> activityType.getName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        return this.getCountedResult(start, limit, activityTypes);
    }

    @ResponseBody
    @RequestMapping(value={"activityActions"}, method={RequestMethod.GET})
    public CountedResult<AcceptButton> getActionsListFromActivity(@RequestParam String processDefId, @RequestParam String activityDefId, @RequestParam int start, @RequestParam int limit, @RequestParam String query) {
        if (StringUtils.isEmpty((CharSequence)processDefId) || StringUtils.isEmpty((CharSequence)activityDefId)) {
            return new CountedResult();
        }
        List buttons = this.formService.getForm(processDefId, activityDefId).getButtons().stream().filter(acceptButton -> !acceptButton.getActionName().isEmpty() && acceptButton.getActionName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        return this.getCountedResult(start, limit, buttons);
    }

    @ResponseBody
    @RequestMapping(value={"activityVariables"}, method={RequestMethod.GET})
    public CountedResult<ProcessIndex> getActivityVariables(@RequestParam String processDefId, @RequestParam String indexType, @RequestParam boolean isTabular, @RequestParam int start, @RequestParam int limit, @RequestParam String query) {
        IndexType indexToFind = IndexType.valueOf((String)indexType);
        List processIndices = this.processService.getProcessIndexes(processDefId).stream().filter(processIndex -> processIndex.getType() == indexToFind && processIndex.isTabular() == isTabular && processIndex.getName().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        return this.getCountedResult(start, limit, processIndices);
    }

    @NotNull
    private <T> CountedResult<T> getCountedResult(int start, int limit, List<T> processIndices) {
        int toIndex = Math.min(start + limit, processIndices.size());
        CountedResult result = new CountedResult();
        result.setTotal((long)processIndices.size());
        result.setData(processIndices.subList(start, toIndex));
        return result;
    }
}

