/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.clientapi.dto;

import com.suncode.plugin.plusautenti.clientapi.dto.DraftDocumentSignerDto;
import com.suncode.pwfl.archive.WfFile;
import java.beans.ConstructorProperties;
import java.util.List;

public class DraftDocument {
    private List<DraftDocumentSignerDto> signers;
    private String documentTitle;
    private String documentDescription;
    private String documentLang;
    private List<WfFile> files;
    private Boolean allowDocumentReSigning;

    @ConstructorProperties(value={"signers", "documentTitle", "documentDescription", "documentLang", "files", "allowDocumentReSigning"})
    DraftDocument(List<DraftDocumentSignerDto> signers, String documentTitle, String documentDescription, String documentLang, List<WfFile> files, Boolean allowDocumentReSigning) {
        this.signers = signers;
        this.documentTitle = documentTitle;
        this.documentDescription = documentDescription;
        this.documentLang = documentLang;
        this.files = files;
        this.allowDocumentReSigning = allowDocumentReSigning;
    }

    public static DraftDocumentBuilder builder() {
        return new DraftDocumentBuilder();
    }

    public List<DraftDocumentSignerDto> getSigners() {
        return this.signers;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public String getDocumentDescription() {
        return this.documentDescription;
    }

    public String getDocumentLang() {
        return this.documentLang;
    }

    public List<WfFile> getFiles() {
        return this.files;
    }

    public Boolean getAllowDocumentReSigning() {
        return this.allowDocumentReSigning;
    }

    public void setSigners(List<DraftDocumentSignerDto> signers) {
        this.signers = signers;
    }

    public static class DraftDocumentBuilder {
        private List<DraftDocumentSignerDto> signers;
        private String documentTitle;
        private String documentDescription;
        private String documentLang;
        private List<WfFile> files;
        private Boolean allowDocumentReSigning;

        DraftDocumentBuilder() {
        }

        public DraftDocumentBuilder signers(List<DraftDocumentSignerDto> signers) {
            this.signers = signers;
            return this;
        }

        public DraftDocumentBuilder documentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public DraftDocumentBuilder documentDescription(String documentDescription) {
            this.documentDescription = documentDescription;
            return this;
        }

        public DraftDocumentBuilder documentLang(String documentLang) {
            this.documentLang = documentLang;
            return this;
        }

        public DraftDocumentBuilder files(List<WfFile> files) {
            this.files = files;
            return this;
        }

        public DraftDocumentBuilder allowDocumentReSigning(Boolean allowDocumentReSigning) {
            this.allowDocumentReSigning = allowDocumentReSigning;
            return this;
        }

        public DraftDocument build() {
            return new DraftDocument(this.signers, this.documentTitle, this.documentDescription, this.documentLang, this.files, this.allowDocumentReSigning);
        }

        public String toString() {
            return "DraftDocument.DraftDocumentBuilder(signers=" + this.signers + ", documentTitle=" + this.documentTitle + ", documentDescription=" + this.documentDescription + ", documentLang=" + this.documentLang + ", files=" + this.files + ", allowDocumentReSigning=" + this.allowDocumentReSigning + ")";
        }
    }
}

