/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.applications;

import com.suncode.plugin.plusautenti.Categories;
import com.suncode.plugin.plusautenti.applications.assertions.ParameterAssertions;
import com.suncode.plugin.plusautenti.applications.dto.SendDocumentParamsDto;
import com.suncode.plugin.plusautenti.applications.enums.DocumentsSource;
import com.suncode.plugin.plusautenti.applications.util.ApplicationUtil;
import com.suncode.plugin.plusautenti.clientapi.dto.DraftDocument;
import com.suncode.plugin.plusautenti.clientapi.dto.DraftDocumentSignerDto;
import com.suncode.plugin.plusautenti.clientapi.enums.AuthorizationType;
import com.suncode.plugin.plusautenti.clientapi.enums.DocumentProcessPartyRole;
import com.suncode.plugin.plusautenti.clientapi.enums.SignType;
import com.suncode.plugin.plusautenti.clientapi.service.AutentiApiService;
import com.suncode.plugin.plusautenti.configuration.dto.AutentiConnectionConfig;
import com.suncode.plugin.plusautenti.configuration.service.AutentiPCMConfig;
import com.suncode.plugin.plusautenti.document.service.AutentiDocumentService;
import com.suncode.plugin.plusautenti.exception.AutentiException;
import com.suncode.plugin.plusautenti.exception.message.ErrorMessage;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Application
@Transactional
@ComponentsFormScript(value="scripts/applications/SendDocument/pwe_dynamic_form.js")
public class SendDocument {
    private static final Logger log = LoggerFactory.getLogger(SendDocument.class);
    @Autowired
    AutentiApiService autentiApiService;
    @Autowired
    AutentiDocumentService autentiDocumentService;
    @Autowired
    AutentiPCMConfig autentiPCMConfiguration;
    private static final String APPLICATION_ID = "plusautenti.applications.SendDocument";

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(APPLICATION_ID)).name("plusautenti.applications.SendDocument.name")).description("plusautenti.applications.SendDocument.desc")).icon((Icon)DivanteIcon.RENAME2)).category(new Category[]{Categories.PLUS_AUTENTI});
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "pcmConfigurationId", (Type)Types.STRING);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "documentSrc", (Type)Types.STRING);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "documentClasses", (Type)Types.STRING_ARRAY, false, true, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "fileIds", (Type)Types.INTEGER_ARRAY, false, true, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "documentIdxName", (Type)Types.STRING, false, true, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "documentLang", (Type)Types.STRING);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "signersFirstName", (Type)Types.STRING_ARRAY, false, false, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "signersLastName", (Type)Types.STRING_ARRAY, false, false, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "signersEmail", (Type)Types.STRING_ARRAY, false, false, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "signersPhoneNo", (Type)Types.STRING_ARRAY);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "signersRole", (Type)Types.STRING_ARRAY);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "signType", (Type)Types.STRING_ARRAY);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "authorizationType", (Type)Types.STRING_ARRAY);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "documentTitle", (Type)Types.STRING, false, false, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "documentDescription", (Type)Types.STRING, false, true, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "autentiDocId", (Type)Types.VARIABLE, false, false, null);
        ApplicationUtil.addNewParameter(builder, APPLICATION_ID, "reSigningDocument", (Type)Types.BOOLEAN, true, false, false);
    }

    public void execute(Parameters parameters, @Param Variable autentiDocId, ActivityContextMap activityCtxMap) throws AcceptanceException {
        try {
            log.info("[PlusAutenti] Send document to Autenti");
            SendDocumentParamsDto sendDocumentParams = this.buildSendDocumentParamsDto(parameters);
            this.validateParams(sendDocumentParams);
            List<DraftDocumentSignerDto> signers = this.getDocumentSigners(sendDocumentParams);
            if (signers.isEmpty()) {
                log.debug("Signers list is empty. Send skipped.");
                return;
            }
            List<WfFile> filesToSend = this.getFilesToSend(sendDocumentParams, activityCtxMap.getProcessId());
            if (filesToSend.isEmpty()) {
                log.debug("File list is empty. Nothing to send.");
                return;
            }
            DraftDocument draftDocument = DraftDocument.builder().documentTitle(sendDocumentParams.getDocumentTitle()).documentDescription(sendDocumentParams.getDocumentDescription()).documentLang(sendDocumentParams.getDocumentLang()).signers(signers).files(filesToSend).allowDocumentReSigning(sendDocumentParams.getReSigningDocument()).build();
            AutentiConnectionConfig autentiConnectionConfig = this.autentiPCMConfiguration.getAutentiConfig(sendDocumentParams.getPcmConfigurationId());
            this.autentiApiService.connect(autentiConnectionConfig);
            String documentId = this.autentiApiService.sendDraftDocument(autentiConnectionConfig, draftDocument);
            Assert.isTrue((!documentId.isEmpty() ? 1 : 0) != 0, (String)"Problem with generating Autenti document id");
            log.info("[PlusAutenti] Returned autentiDocId: " + documentId);
            this.autentiDocumentService.setDocumentIdx(filesToSend, sendDocumentParams.getDocumentIdxName(), documentId);
            autentiDocId.setValue((Object)documentId);
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private void validateParams(SendDocumentParamsDto sendDocumentParams) {
        ParameterAssertions.assertEqualArrayLength(sendDocumentParams.getSignersFirstName(), sendDocumentParams.getSignersLastName(), sendDocumentParams.getSignersEmail(), sendDocumentParams.getSignersRole(), sendDocumentParams.getSignType(), sendDocumentParams.getAuthorizationType(), sendDocumentParams.getSignersPhoneNo());
        ParameterAssertions.assertDocumentClassName(Arrays.asList(sendDocumentParams.getDocumentClasses()));
    }

    private SendDocumentParamsDto buildSendDocumentParamsDto(Parameters parameters) {
        return SendDocumentParamsDto.builder().pcmConfigurationId((String)parameters.get("pcmConfigurationId", String.class)).documentSrc((String)parameters.get("documentSrc", String.class)).documentClasses((String[])parameters.get("documentClasses", String[].class)).fileIds((int[])parameters.get("fileIds", int[].class)).documentIdxName((String)parameters.get("documentIdxName", String.class)).signersRole((String[])parameters.get("signersRole", String[].class)).documentLang((String)parameters.get("documentLang", String.class)).signersFirstName((String[])parameters.get("signersFirstName", String[].class)).signersLastName((String[])parameters.get("signersLastName", String[].class)).signersEmail((String[])parameters.get("signersEmail", String[].class)).signType((String[])parameters.get("signType", String[].class)).authorizationType((String[])parameters.get("authorizationType", String[].class)).documentTitle((String)parameters.get("documentTitle", String.class)).documentDescription((String)parameters.get("documentDescription", String.class)).signersPhoneNo((String[])parameters.get("signersPhoneNo", String[].class)).reSigningDocument((Boolean)parameters.get("reSigningDocument", Boolean.class)).build();
    }

    private List<DraftDocumentSignerDto> getDocumentSigners(SendDocumentParamsDto params) {
        return IntStream.range(0, params.getSignersRole().length).mapToObj(i -> DraftDocumentSignerDto.builder().role(DocumentProcessPartyRole.fromString(params.getSignersRole()[i])).firstName(params.getSignersFirstName()[i]).lastName(params.getSignersLastName()[i]).email(params.getSignersEmail()[i]).signType(SignType.fromString(params.getSignType()[i])).authorizationType(AuthorizationType.fromString(params.getAuthorizationType()[i])).phoneNo(params.getSignersPhoneNo()[i]).build()).collect(Collectors.toList());
    }

    private List<WfFile> getFilesToSend(SendDocumentParamsDto params, String processId) throws AutentiException {
        List<WfFile> files;
        switch (DocumentsSource.valueOf(params.getDocumentSrc())) {
            case ALL_DOCUMENTS_FROM_PROCESS: {
                files = this.autentiDocumentService.getLatestProcessFiles(processId);
                break;
            }
            case DOCUMENTS_FROM_CLASS: {
                files = this.autentiDocumentService.readFilesFromProcess(processId, params.getDocumentClasses());
                break;
            }
            case DOCUMENTS_BY_FILE_ID: {
                files = this.autentiDocumentService.getFilesByFileIds(Arrays.stream(params.getFileIds()).asLongStream().toArray());
                break;
            }
            default: {
                throw new AutentiException(ErrorMessage.INCORRECT_DOC_SRC, "Unrecognized document source:" + params.getDocumentSrc());
            }
        }
        return files.stream().filter(file -> this.autentiApiService.isSupportedExtension(FilenameUtils.getExtension((String)file.getFileName()))).collect(Collectors.toList());
    }
}

