const PlusAutenti = {
    t: PW.I18N.createT("com.suncode.plugin-plus-autenti")
};

PWE.integrationComponent.registerApplication("plusautenti.applications.SendDocument", {
    apiVersion: 2,
    buildForm: (form) => buildForm(form),
});

function buildForm(form) {

    form.addCombobox({
        id: "documentSrc",
        listeners: {
            change: function (value) {
                if (value == "DOCUMENTS_FROM_CLASS") {
                    form.show("documentClasses");
                    form.setNotEmpty("documentClasses", true);
                } else {
                    form.resetArray("documentClasses");
                    form.hide("documentClasses");
                    form.setNotEmpty("documentClasses", false);
                }

                if (value == "DOCUMENTS_BY_FILE_ID") {
                    form.show("fileIds");
                    form.setNotEmpty("fileIds", true);
                } else {
                    form.resetArray("fileIds");
                    form.hide("fileIds");
                    form.setNotEmpty("fileIds", false);
                }
            }
        },
        values: [
            {display: PlusAutenti.t("plusautenti.applications.SendDocument.allDocuments"), id: "ALL_DOCUMENTS_FROM_PROCESS"},
            {display: PlusAutenti.t("plusautenti.applications.SendDocument.documentsFromClasses"), id: "DOCUMENTS_FROM_CLASS"},
            {display: PlusAutenti.t("plusautenti.applications.SendDocument.documentsByFileIds"), id: "DOCUMENTS_BY_FILE_ID"}
        ]
    })

    CufComp.addComboboxClassList("documentClasses", {}, form);

    if (form.getValue("documentSrc") != "DOCUMENTS_FROM_CLASS") {
        form.hide("documentClasses");
        form.setNotEmpty("documentClasses", false);
    }

    form.addField("fileIds");
    if (form.getValue("documentSrc") != "DOCUMENTS_BY_FILE_ID") {
        form.hide("fileIds");
        form.setNotEmpty("fileIds", false);
    }

    form.addField("documentTitle");
    form.addField("documentDescription");

    form.addCombobox({
        id: "documentLang",
        value: "pl",
        values: [
            {display: "PL", id: "pl"},
            {display: "EN", id: "en"}
        ]
    })

    form.addField("reSigningDocument");

    let companySignersTable = form.addTable({
        tableId: "companySignersTable",
        name: PlusAutenti.t("plusautenti.applications.SendDocument.signers.name"),
    });
    companySignersTable.addField("signersFirstName");
    companySignersTable.addField("signersLastName");
    companySignersTable.addField("signersEmail");
    companySignersTable.addField("signersRole");
    companySignersTable.addField("signType");
    companySignersTable.addField("authorizationType");
    companySignersTable.addField("signersPhoneNo");

    form.addCombobox({
        id: "pcmConfigurationId",
        remote: {
            url: "plugin/com.suncode.plugin-plus-autenti/pcm/configurations",
            fields: [
                {
                    name: "key",
                    type: "string"
                }
            ]
        },
        valueField: "key",
        displayField: "key",
        sort: [{
            property: "key",
            direction: "ASC"
        }]
    });
    form.addField("autentiDocId");
    form.addField("documentIdxName");
}