﻿window.vfgFileSchema = {
    fields: [
        {
            type: "select",
            inputType: "text",
            label: "plusautenti.pcm.schema.params.connectionType.name",
            model: "connectionType",
            required: true,
            values: [
                {name: "plusautenti.pcm.schema.params.url.password.name", id: "password"},
                {name: "plusautenti.pcm.schema.params.url.clientCredentials.name", id: "client_credentials"}
            ]
        },
        {
            type: "input",
            inputType: "text",
            label: "plusautenti.pcm.schema.params.clientId.name",
            help: "plusautenti.pcm.schema.params.clientId.desc",
            model: "clientId",
            required: true,
            validator: "string"
        },
        {
            type: "input",
            inputType: "password",
            label: "plusautenti.pcm.schema.params.clientSecret.name",
            help: "plusautenti.pcm.schema.params.clientSecret.desc",
            model: "clientSecret",
            required: true,
            validator: "string"
        },
        {
            type: "input",
            inputType: "text",
            label: "plusautenti.pcm.schema.params.apiUrl.name",
            model: "apiUrl",
            required: true,
            validator: "string"
        },
        {
            type: "input",
            inputType: "text",
            label: "plusautenti.pcm.schema.params.userName.name",
            model: "userName",
            required: true,
            validator: "string",
            visible: function(model) {
                if (model && model.connectionType === "password") {
                    return true;
                }
                model.userName = "";
                return false;
            }
        },
        {
            type: "input",
            inputType: "password",
            label: "plusautenti.pcm.schema.params.pass.name",
            model: "pass",
            required: true,
            validator: "string",
            visible: function(model) {
                if (model && model.connectionType === "password") {
                    return true;
                }
                model.pass = "";
                return false;
            }
        }
    ]
}