/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.document.service;

import com.suncode.plugin.plusautenti.exception.AutentiException;
import com.suncode.plugin.plusautenti.exception.message.ErrorMessage;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.workflow.activity.Activity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutentiDocumentService {
    private static final Logger log = LoggerFactory.getLogger(AutentiDocumentService.class);
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private FileService fileService;

    public List<WfFile> getLatestProcessFiles(String processId) {
        return this.documentFinder.getDocumentsFromProcess(processId, new String[0]).stream().map(WfDocument::getFile).collect(Collectors.toList());
    }

    public List<WfFile> getFilesByFileIds(long[] filesIds) throws AutentiException {
        LinkedList<WfFile> files = new LinkedList<WfFile>();
        for (long fileId : filesIds) {
            WfFile document = this.fileService.getFile(Long.valueOf(fileId), new String[0]);
            if (document == null) {
                throw new AutentiException(ErrorMessage.FILE_NOT_EXIST_IN_ARCHIVE, "No file with id: " + fileId);
            }
            files.add(document);
        }
        return files;
    }

    public List<WfFile> readFilesFromProcess(String processId, String[] documentClassNames) {
        if (documentClassNames.length == 0) {
            return this.getLatestProcessFiles(processId);
        }
        HashSet<String> distinctDocumentClasses = new HashSet<String>(Arrays.asList(documentClassNames));
        return distinctDocumentClasses.stream().flatMap(documentClass -> {
            List documents = this.documentFinder.getDocumentsFromProcessAndClass(processId, documentClass, new String[]{"documentClass"});
            return documents.stream().map(WfDocument::getFile);
        }).collect(Collectors.toList());
    }

    public void setDocumentIdx(List<WfFile> files, String indexName, String value) {
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return;
        }
        files.forEach(file -> {
            WfDocument document = this.documentFinder.findByFileId(Long.valueOf(file.getId()), file.getDocumentClass().getId());
            document.setIndexValue(indexName, (Object)value);
            this.documentService.updateDocument(document);
        });
    }

    public void addDocumentAsNewVersion(DocumentDefinition docDefinition, Long originalFileId, String user) throws Exception {
        if (this.fileService.getVersionForFile(originalFileId).getState().equals(WfFileVersion.State.STATE_EDIT.toString())) {
            this.fileService.cancelCheckOut(originalFileId);
        }
        this.fileService.checkOut(originalFileId, user);
        this.fileService.checkIn(docDefinition, originalFileId, "");
    }

    public DocumentDefinition buildDocumentDefinition(Activity activity, Path path, Long classId, String user) throws IOException {
        DocumentDefinition definition = new DocumentDefinition();
        definition.setActivityId(activity.getActivityId());
        definition.setProcessId(activity.getProcessId());
        definition.setFileName(path.getFileName().toString());
        definition.setUserName(user);
        definition.setDocumentClassId(classId);
        try (ByteArrayInputStream targetStream = new ByteArrayInputStream(Files.readAllBytes(path));){
            definition.setInputStream((InputStream)targetStream);
        }
        return definition;
    }
}

