/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.clientapi.service;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.suncode.plugin.plusautenti.clientapi.dto.DraftDocument;
import com.suncode.plugin.plusautenti.clientapi.dto.DraftDocumentSignerDto;
import com.suncode.plugin.plusautenti.clientapi.enums.AuthGrantType;
import com.suncode.plugin.plusautenti.clientapi.enums.AuthorizationType;
import com.suncode.plugin.plusautenti.clientapi.enums.DocumentProcessPartyRole;
import com.suncode.plugin.plusautenti.clientapi.enums.SignType;
import com.suncode.plugin.plusautenti.clientapi.enums.SupportedExtensions;
import com.suncode.plugin.plusautenti.clientapi.exception.AutentiClientApiException;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiActionChallenge;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiAuthorizationRequestResponse;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiClientCredentialsAuthorizationRequest;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocument;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentFileEntityResponse;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentParties;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentPartiesConstraint;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentPartiesConstraintAttributes;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentPartiesParty;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentPartiesPartyContact;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentPartiesPartyContactAttributes;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiDocumentProcessResponse;
import com.suncode.plugin.plusautenti.clientapi.model.AutentiPasswordAuthorizationRequest;
import com.suncode.plugin.plusautenti.clientapi.model.ExceptionResponse;
import com.suncode.plugin.plusautenti.clientapi.service.AutentiApiService;
import com.suncode.plugin.plusautenti.configuration.dto.AutentiConnectionConfig;
import com.suncode.plugin.plusautenti.exception.AutentiException;
import com.suncode.plugin.plusautenti.exception.message.ErrorMessage;
import com.suncode.pwfl.archive.WfFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AutentiApiServiceImpl
implements AutentiApiService {
    private static final Logger log = LoggerFactory.getLogger(AutentiApiServiceImpl.class);
    public static final String UNSUCCESSFUL_RESPONSE_MSG = "Unsuccessful response from Autenti";
    public static final String APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "accept";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONSTRAINT_UNIQUE_TYPE_SIGNATURE_TYPE = "CONSTRAINT-UNIQUE_TYPE:SIGNATURE_TYPE";
    public static final String CONSTRAINT_UNIQUE_TYPE_VISUALISATION = "CONSTRAINT-UNIQUE_TYPE:VISUALISATION";
    public static final String VISUALISATION_AUTENTI_SIGNATURE_CARD = "VISUALISATION:AUTENTI_SIGNATURE_CARD";
    public static final String VISUALISATION_MANUAL = "VISUALISATION:MANUAL";
    public static final String ACTION_SIGNATURE_APPLICATION = "ACTION:SIGNATURE_APPLICATION";
    public static final String SIGNATURE_PROVIDER_SIGNATURE_TYPE_BASIC = "SIGNATURE_PROVIDER-SIGNATURE_TYPE:BASIC";
    public static final String SIGNATURE_PROVIDER_SIGNATURE_TYPE_QUALIFIED = "SIGNATURE_PROVIDER-SIGNATURE_TYPE:QUALIFIED";
    public static final String CONTACT_TYPE_EMAIL = "CONTACT-TYPE:EMAIL";
    public static final String CONSTRAINT_UNIQUE_TYPE_PHONE_NUMBER_VERIFICATION_REQUIRED = "CONSTRAINT-UNIQUE_TYPE:PHONE_NUMBER_VERIFICATION_REQUIRED";
    public static final String CONSTRAINT_UNIQUE_TYPE_PARTICIPATION_PRIORITY = "CONSTRAINT-UNIQUE_TYPE:PARTICIPATION_PRIORITY";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String X_ASSERTION = "X-ASSERTION";
    public static final String SIGNED_CONTENT_FILE = "SIGNED_CONTENT_FILE";
    public static final String CHALLENGE_CLASSIFIER_ACTION_SELECTION = "CHALLENGE_CLASSIFIER-UNIQUE_TYPE:ACTION_SELECTION";
    public static final String CHALLENGE_CLASSIFIER_REMINDER_PARTY_SELECTION = "CHALLENGE_CLASSIFIER-UNIQUE_TYPE:DOCUMENT_REMINDER_PARTY_SELECTION";
    public static final String EVENT_CLASSIFIER_DOCUMENT_SENT = "EVENT_CLASSIFIER-UNIQUE_TYPE:DOCUMENT_SENT";
    public static final String EVENT_CLASSIFIER_DOCUMENT_REMINDER_SENT = "EVENT_CLASSIFIER-UNIQUE_TYPE:DOCUMENT_REMINDER_SENT";
    public static final String EVENT_CLASSIFIER_DOCUMENT_WITHDRAWAL = "EVENT_CLASSIFIER-UNIQUE_TYPE:DOCUMENT_WITHDRAWAL";
    private static final Pattern TOKEN_MASK_PATTERN = Pattern.compile("(\"(access_token|refresh_token)\"\\s*:\\s*\")([^\"]+)(\")");
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(40L, TimeUnit.SECONDS).readTimeout(40L, TimeUnit.SECONDS).build();
    private final Gson gson = new Gson();

    @Override
    public void connect(AutentiConnectionConfig autentiConnectionConfig) throws IOException, AutentiClientApiException {
        if (autentiConnectionConfig.getConnectionType() == AuthGrantType.PASSWORD) {
            String token = this.generateBasicAuthToken(autentiConnectionConfig);
            autentiConnectionConfig.setToken(token);
        } else if (autentiConnectionConfig.getConnectionType() == AuthGrantType.CLIENT_CREDENTIALS) {
            String token = this.generateClientCredentialsToken(autentiConnectionConfig);
            autentiConnectionConfig.setToken(token);
        }
    }

    private String generateBasicAuthToken(AutentiConnectionConfig config) throws IOException, AutentiClientApiException {
        AutentiPasswordAuthorizationRequest autentiPasswordAuthorizationRequest = this.buildPasswordAutentiAuthRequest(config);
        Request request = new Request.Builder().url(config.getApiUrl() + "/auth/token").method("POST", this.jsonRequestBody(autentiPasswordAuthorizationRequest)).build();
        AutentiAuthorizationRequestResponse tokenEntity = this.executeRequest(request, AutentiAuthorizationRequestResponse.class);
        return tokenEntity.getAccess_token();
    }

    private String generateClientCredentialsToken(AutentiConnectionConfig config) throws IOException, AutentiClientApiException {
        AutentiClientCredentialsAuthorizationRequest autentiClientCredentialsAuthorizationRequest = this.buildClientCredentialsAutentiAuthRequest(config);
        Request request = new Request.Builder().url(config.getApiUrl() + "/auth/token").method("POST", this.jsonRequestBody(autentiClientCredentialsAuthorizationRequest)).build();
        AutentiAuthorizationRequestResponse tokenEntity = this.executeRequest(request, AutentiAuthorizationRequestResponse.class);
        return tokenEntity.getAccess_token();
    }

    private AutentiPasswordAuthorizationRequest buildPasswordAutentiAuthRequest(AutentiConnectionConfig config) {
        return AutentiPasswordAuthorizationRequest.builder().client_id(config.getClientId()).client_secret(config.getClientSecret()).grant_type(config.getConnectionType().toString()).username(config.getUserName()).password(config.getPass()).build();
    }

    private AutentiClientCredentialsAuthorizationRequest buildClientCredentialsAutentiAuthRequest(AutentiConnectionConfig config) {
        return AutentiClientCredentialsAuthorizationRequest.builder().client_id(config.getClientId()).client_secret(config.getClientSecret()).grant_type(config.getConnectionType().toString()).build();
    }

    @Override
    public String sendDraftDocument(AutentiConnectionConfig config, DraftDocument draftDocument) throws IOException, AutentiClientApiException {
        log.debug("Send draft document to Autenti");
        AutentiDocument documentDraft = new AutentiDocument(draftDocument.getDocumentTitle(), draftDocument.getDocumentDescription(), draftDocument.getDocumentLang().toLowerCase(), this.getDocumentsParties(draftDocument));
        if (Boolean.TRUE.equals(draftDocument.getAllowDocumentReSigning())) {
            AutentiDocumentPartiesConstraint visualisationConstraint = this.getDocumentVisualisationConstraint();
            documentDraft.setConstraints(Arrays.asList(visualisationConstraint));
        }
        String documentProcessId = this.createDocument(config, documentDraft).getId();
        for (WfFile file : draftDocument.getFiles()) {
            this.sendFileToSign(config, documentProcessId, file);
        }
        this.sendDocumentToSign(config, documentProcessId);
        log.debug("The document was sent correctly. Document ID: " + documentProcessId);
        return documentProcessId;
    }

    private List<AutentiDocumentParties> getDocumentsParties(DraftDocument draftConfig) {
        return draftConfig.getSigners().stream().map(signer -> {
            AutentiDocumentPartiesParty documentDraftPartiesParty = this.getDocumentDraftPartiesParty(signer.getFirstName(), signer.getLastName(), signer.getEmail());
            List<AutentiDocumentPartiesConstraint> constraints = null;
            if (signer.getRole() == DocumentProcessPartyRole.SIGNER) {
                constraints = this.getSignerDocumentsPartiesConstraint((DraftDocumentSignerDto)signer);
            } else if (signer.getRole() == DocumentProcessPartyRole.APPROVER) {
                constraints = this.getApproverDocumentsPartiesConstraint();
            }
            return AutentiDocumentParties.builder().role(signer.getRole().name()).party(documentDraftPartiesParty).constraints(constraints).build();
        }).collect(Collectors.toList());
    }

    private AutentiDocumentPartiesParty getDocumentDraftPartiesParty(String firstName, String lastName, String email) {
        AutentiDocumentPartiesParty documentDraftPartiesParty = new AutentiDocumentPartiesParty();
        documentDraftPartiesParty.setFirstName(firstName);
        documentDraftPartiesParty.setLastName(lastName);
        AutentiDocumentPartiesPartyContact contact = new AutentiDocumentPartiesPartyContact(CONTACT_TYPE_EMAIL, new AutentiDocumentPartiesPartyContactAttributes(email));
        documentDraftPartiesParty.setContacts(new LinkedList<AutentiDocumentPartiesPartyContact>());
        documentDraftPartiesParty.getContacts().add(contact);
        return documentDraftPartiesParty;
    }

    private List<AutentiDocumentPartiesConstraint> getSignerDocumentsPartiesConstraint(DraftDocumentSignerDto signer) {
        LinkedList<AutentiDocumentPartiesConstraint> partConstraintList = new LinkedList<AutentiDocumentPartiesConstraint>();
        partConstraintList.add(this.getSignatureTypeConstraint(signer.getSignType()));
        if (signer.getAuthorizationType() == AuthorizationType.EMAIL_AND_SMS) {
            partConstraintList.add(this.getPhoneNumberConstraint(signer.getPhoneNo()));
        }
        partConstraintList.add(this.getPriorityConstraint(1));
        return partConstraintList;
    }

    private AutentiDocumentPartiesConstraint getSignatureTypeConstraint(SignType signType) {
        AutentiDocumentPartiesConstraint signatureType = new AutentiDocumentPartiesConstraint();
        signatureType.setClassifiers(Arrays.asList(CONSTRAINT_UNIQUE_TYPE_SIGNATURE_TYPE));
        signatureType.setConstrainedActions(Arrays.asList(ACTION_SIGNATURE_APPLICATION));
        if (signType == SignType.AUTENTI_QUALIFIED_SIGNATURE) {
            signatureType.setAttributes(AutentiDocumentPartiesConstraintAttributes.builder().requiredClassifiers(Arrays.asList(SIGNATURE_PROVIDER_SIGNATURE_TYPE_BASIC)).build());
        } else {
            signatureType.setAttributes(AutentiDocumentPartiesConstraintAttributes.builder().requiredClassifiers(Arrays.asList(SIGNATURE_PROVIDER_SIGNATURE_TYPE_QUALIFIED)).build());
        }
        return signatureType;
    }

    private AutentiDocumentPartiesConstraint getPhoneNumberConstraint(String phoneNo) {
        AutentiDocumentPartiesConstraint phoneNumberConstraint = new AutentiDocumentPartiesConstraint();
        phoneNumberConstraint.setClassifiers(Arrays.asList(CONSTRAINT_UNIQUE_TYPE_PHONE_NUMBER_VERIFICATION_REQUIRED));
        phoneNumberConstraint.setConstrainedActions(Arrays.asList(ACTION_SIGNATURE_APPLICATION));
        phoneNumberConstraint.setAttributes(AutentiDocumentPartiesConstraintAttributes.builder().phoneNumber(phoneNo).build());
        return phoneNumberConstraint;
    }

    private AutentiDocumentPartiesConstraint getPriorityConstraint(int priority) {
        AutentiDocumentPartiesConstraint priorityConstraint = new AutentiDocumentPartiesConstraint();
        priorityConstraint.setClassifiers(Arrays.asList(CONSTRAINT_UNIQUE_TYPE_PARTICIPATION_PRIORITY));
        priorityConstraint.setAttributes(AutentiDocumentPartiesConstraintAttributes.builder().priority(priority).build());
        return priorityConstraint;
    }

    private AutentiDocumentPartiesConstraint getDocumentVisualisationConstraint() {
        AutentiDocumentPartiesConstraint visualisationConstraint = new AutentiDocumentPartiesConstraint();
        visualisationConstraint.setConstrainedActions(Arrays.asList(ACTION_SIGNATURE_APPLICATION));
        visualisationConstraint.setClassifiers(Arrays.asList(CONSTRAINT_UNIQUE_TYPE_VISUALISATION));
        visualisationConstraint.setAttributes(AutentiDocumentPartiesConstraintAttributes.builder().visualisationId(VISUALISATION_MANUAL).build());
        return visualisationConstraint;
    }

    private List<AutentiDocumentPartiesConstraint> getApproverDocumentsPartiesConstraint() {
        ArrayList<AutentiDocumentPartiesConstraint> partConstraintList = new ArrayList<AutentiDocumentPartiesConstraint>();
        AutentiDocumentPartiesConstraint partConstraintStandard = new AutentiDocumentPartiesConstraint();
        partConstraintStandard.setClassifiers(Arrays.asList(CONSTRAINT_UNIQUE_TYPE_PARTICIPATION_PRIORITY));
        partConstraintStandard.setAttributes(AutentiDocumentPartiesConstraintAttributes.builder().priority(1).build());
        partConstraintList.add(partConstraintStandard);
        return partConstraintList;
    }

    private AutentiDocumentProcessResponse createDocument(AutentiConnectionConfig config, AutentiDocument documentDraft) throws IOException, AutentiClientApiException {
        log.debug("Create document in Autenti");
        Request request = this.createPOSTJSONRequest(config, "/document-processes", this.jsonRequestBody(documentDraft));
        return this.executeRequest(request, AutentiDocumentProcessResponse.class);
    }

    private AutentiDocumentProcessResponse sendFileToSign(AutentiConnectionConfig config, String documentProcessId, WfFile wfFile) throws IOException, AutentiClientApiException {
        String fileName = wfFile.getFileName();
        String filePath = wfFile.getFullPath();
        File file = new File(filePath);
        String mimeType = Files.probeContentType(file.toPath());
        log.debug("Send document: " + fileName);
        String fileMeta = "{\"filename\": \"" + fileName + "\", \"filePurpose\": \"SOURCE_FILE\", \"mimeType\": \"" + mimeType + "\"}";
        MediaType fileMediaType = MediaType.parse((String)mimeType);
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("fileMeta", "fileMeta", RequestBody.create((String)fileMeta, (MediaType)MediaType.parse((String)APPLICATION_JSON))).addFormDataPart("file", fileName, RequestBody.create((File)file, (MediaType)fileMediaType)).build();
        String url = config.getApiUrl() + "/document-processes/" + documentProcessId + "/files";
        Request request = new Request.Builder().url(url).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).addHeader(ACCEPT, APPLICATION_JSON).addHeader(CONTENT_TYPE, MULTIPART_FORM_DATA).post((RequestBody)body).build();
        return this.executeRequest(request, AutentiDocumentProcessResponse.class);
    }

    private boolean sendDocumentToSign(AutentiConnectionConfig config, String documentProcessId) throws IOException, AutentiClientApiException {
        log.debug("Send Document to Sign. Document ID: " + documentProcessId);
        String assertion = "{\"classifiers\":[\"CHALLENGE_CLASSIFIER-UNIQUE_TYPE:ACTION_SELECTION\"],\"attributes\": {\"selectedIds\": [\"EVENT_CLASSIFIER-UNIQUE_TYPE:DOCUMENT_SENT\"]}}";
        byte[] encodedBytes = Base64.getEncoder().encode(assertion.getBytes());
        String assertionBase64 = new String(encodedBytes);
        log.debug("encodedBytes " + assertionBase64);
        Request request = new Request.Builder().url(config.getApiUrl() + "/document-processes/" + documentProcessId + "/actions").method("POST", this.jsonRequestBody("")).addHeader(CONTENT_TYPE, APPLICATION_JSON).addHeader(X_ASSERTION, assertionBase64).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).build();
        this.executeRequest(request, Object.class);
        return true;
    }

    @Override
    public Path downloadSignedDocument(AutentiConnectionConfig config, String documentProcessId) throws AutentiException, IOException, AutentiClientApiException {
        List<AutentiDocumentFileEntityResponse> fileEntities = this.getAllFiles(config, documentProcessId);
        Optional<AutentiDocumentFileEntityResponse> signedContentFile = fileEntities.stream().filter(fileEntity -> fileEntity.getFilePurpose().equals(SIGNED_CONTENT_FILE)).findFirst();
        Assert.isTrue((boolean)signedContentFile.isPresent(), (String)"No signed file in document");
        String docId = signedContentFile.get().getId();
        docId = URLEncoder.encode(docId, "UTF-8");
        return this.getFileContent(config, documentProcessId, docId, System.getProperty("java.io.tmpdir") + signedContentFile.get().getFilename());
    }

    private Path getFileContent(AutentiConnectionConfig config, String documentProcessId, String fileId, String savePath) throws AutentiException, AutentiClientApiException {
        log.debug(String.format("Get file content from Autenti. DocumentId: %s, FileId: %s", documentProcessId, fileId));
        Request request = this.createGETJSONRequest(config, "/document-processes/" + documentProcessId + "/files/" + fileId + "/content");
        byte[] documentByteArray = this.getDocumentByteArray(request);
        try (FileOutputStream fos = new FileOutputStream(savePath);){
            fos.write(documentByteArray);
        }
        catch (IOException ex) {
            throw new AutentiException(ErrorMessage.SAVE_ON_DISK_ERROR, "Failed to save file on disk", ex);
        }
        return Paths.get(savePath, new String[0]);
    }

    private List<AutentiDocumentFileEntityResponse> getAllFiles(AutentiConnectionConfig config, String documentProcessId) throws IOException, AutentiClientApiException {
        log.debug("Get files for document " + documentProcessId);
        Request request = new Request.Builder().url(config.getApiUrl() + "/document-processes/" + documentProcessId + "/files").method("GET", null).addHeader(ACCEPT, APPLICATION_JSON).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).build();
        return Arrays.asList((Object[])this.executeRequest(request, AutentiDocumentFileEntityResponse[].class));
    }

    @Override
    public AutentiDocument getAutentiDocument(AutentiConnectionConfig config, String documentProcessId) throws IOException, AutentiClientApiException {
        Request request = this.createGETJSONRequest(config, "/document-processes/" + documentProcessId);
        return this.executeRequest(request, AutentiDocument.class);
    }

    @Override
    public boolean isSupportedExtension(String extension) {
        return Arrays.stream(SupportedExtensions.values()).map(Enum::name).anyMatch(supportedExtension -> supportedExtension.equalsIgnoreCase(extension));
    }

    private <T> RequestBody jsonRequestBody(T body) {
        return RequestBody.create((String)this.gson.toJson(body), (MediaType)MediaType.parse((String)APPLICATION_JSON));
    }

    private Request createGETJSONRequest(AutentiConnectionConfig config, String url) {
        return new Request.Builder().url(config.getApiUrl() + url).method("GET", null).addHeader(CONTENT_TYPE, APPLICATION_JSON).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).build();
    }

    private Request createPOSTJSONRequest(AutentiConnectionConfig config, String url, RequestBody body) {
        Request request = new Request.Builder().url(config.getApiUrl() + url).method("POST", body).addHeader(CONTENT_TYPE, APPLICATION_JSON).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).build();
        log.debug("Request json: " + this.gson.toJson((Object)request));
        return request;
    }

    @NotNull
    private <T> T executeRequest(Request request, Class<T> classOfResponse) throws AutentiClientApiException, IOException {
        log.debug("Request json: " + this.gson.toJson((Object)request));
        try (Response response = client.newCall(request).execute();){
            String responseStr = response.body().string();
            String maskedResponse = this.maskSensitiveData(responseStr);
            if (!response.isSuccessful()) {
                log.warn("ResponseBody string: " + maskedResponse);
                this.handleErrorResponse(response, maskedResponse);
            }
            log.debug("ResponseBody string: " + maskedResponse);
            Object object = this.gson.fromJson(responseStr, classOfResponse);
            return (T)object;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private byte[] getDocumentByteArray(Request request) throws AutentiClientApiException {
        block31: {
            try {
                Throwable throwable = null;
                try (Response response = client.newCall(request).execute();){
                    if (!response.isSuccessful()) {
                        throw new AutentiClientApiException(UNSUCCESSFUL_RESPONSE_MSG, response.code(), response.message());
                    }
                    if (response.body() != null) {
                        try (InputStream is = response.body().byteStream();){
                            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
                            return byArray;
                        }
                    }
                    break block31;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new AutentiClientApiException(ex);
            }
        }
        return new byte[0];
    }

    private boolean isReminderActionAvailable(AutentiConnectionConfig config, String documentId) throws IOException, AutentiClientApiException {
        log.debug("[PlusAutenti] Checking if reminder action is available for document: {}", (Object)documentId);
        Request request = new Request.Builder().url(config.getApiUrl() + "/document-processes/" + documentId + "/actions").method("POST", this.jsonRequestBody("")).addHeader(CONTENT_TYPE, APPLICATION_JSON).addHeader(ACCEPT, APPLICATION_JSON).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 403) {
                byte[] decodedBytes;
                String decodedChallenge;
                AutentiActionChallenge challenge;
                String xChallenge = response.header("x-challenge");
                if (xChallenge != null && (challenge = (AutentiActionChallenge)this.gson.fromJson(decodedChallenge = new String(decodedBytes = Base64.getDecoder().decode(xChallenge)), AutentiActionChallenge.class)).getClassifiers() != null && challenge.getClassifiers().contains(CHALLENGE_CLASSIFIER_ACTION_SELECTION) && challenge.getAttributes() != null && challenge.getAttributes().getOptions() != null) {
                    boolean bl = challenge.getAttributes().getOptions().stream().anyMatch(option -> EVENT_CLASSIFIER_DOCUMENT_REMINDER_SENT.equals(option.getId()) && "AVAILABLE".equals(option.getAvailability()));
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            String responseStr = response.body().string();
            this.handleErrorResponse(response, responseStr);
            boolean bl = false;
            return bl;
        }
    }

    private List<String> getAvailableReminderRecipients(AutentiConnectionConfig config, String documentId) throws IOException, AutentiClientApiException {
        log.debug("[PlusAutenti] Getting available reminder recipients for document: {}", (Object)documentId);
        String encodedAssertion = this.createEncodedAssertion(CHALLENGE_CLASSIFIER_ACTION_SELECTION, EVENT_CLASSIFIER_DOCUMENT_REMINDER_SENT);
        Request request = new Request.Builder().url(config.getApiUrl() + "/document-processes/" + documentId + "/actions").addHeader(CONTENT_TYPE, APPLICATION_JSON).addHeader(ACCEPT, APPLICATION_JSON).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).addHeader(X_ASSERTION, encodedAssertion).post(this.jsonRequestBody("{}")).build();
        try (Response response = client.newCall(request).execute();){
            String xChallenge;
            if (response.code() != 403) {
                String responseStr = response.body().string();
                this.handleErrorResponse(response, responseStr);
            }
            if ((xChallenge = response.header("x-challenge")) == null) {
                throw new AutentiClientApiException("Missing x-challenge in response", response.code(), "Challenge required for recipient selection");
            }
            byte[] decodedBytes = Base64.getDecoder().decode(xChallenge);
            String decodedChallenge = new String(decodedBytes);
            AutentiActionChallenge challenge = (AutentiActionChallenge)this.gson.fromJson(decodedChallenge, AutentiActionChallenge.class);
            if (challenge.getClassifiers() == null || !challenge.getClassifiers().contains(CHALLENGE_CLASSIFIER_REMINDER_PARTY_SELECTION)) {
                throw new AutentiClientApiException("Unexpected challenge type", response.code(), "Expected reminder party selection challenge");
            }
            if (challenge.getAttributes() == null || !"multi".equals(challenge.getAttributes().getMode())) {
                throw new AutentiClientApiException("Unexpected selection mode", response.code(), "Expected multi selection mode");
            }
            if (challenge.getAttributes().getOptions() != null) {
                List<String> list = challenge.getAttributes().getOptions().stream().filter(option -> "AVAILABLE".equals(option.getAvailability())).map(AutentiActionChallenge.AutentiActionOption::getId).collect(Collectors.toList());
                return list;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
    }

    @Override
    public void sendDocumentReminder(AutentiConnectionConfig config, String documentId) throws IOException, AutentiClientApiException {
        log.debug("[PlusAutenti] Sending reminder for document: {}", (Object)documentId);
        if (!this.isReminderActionAvailable(config, documentId)) {
            throw new AutentiClientApiException("Reminder action is not available for this document", 400, "Action not available");
        }
        List<String> availableRecipients = this.getAvailableReminderRecipients(config, documentId);
        if (availableRecipients.isEmpty()) {
            throw new AutentiClientApiException("No available recipients for reminder", 400, "No recipients");
        }
        String encodedActionAssertion = this.createEncodedAssertion(CHALLENGE_CLASSIFIER_ACTION_SELECTION, EVENT_CLASSIFIER_DOCUMENT_REMINDER_SENT);
        HashMap<String, Object> recipientsAssertion = new HashMap<String, Object>();
        recipientsAssertion.put("classifiers", Arrays.asList(CHALLENGE_CLASSIFIER_REMINDER_PARTY_SELECTION));
        HashMap<String, List<String>> recipientsAttributes = new HashMap<String, List<String>>();
        recipientsAttributes.put("selectedIds", availableRecipients);
        recipientsAssertion.put("attributes", recipientsAttributes);
        String recipientsAssertionJson = this.gson.toJson(recipientsAssertion);
        String encodedRecipientsAssertion = Base64.getEncoder().encodeToString(recipientsAssertionJson.getBytes());
        Request request = new Request.Builder().url(config.getApiUrl() + "/document-processes/" + documentId + "/actions").addHeader(CONTENT_TYPE, APPLICATION_JSON).addHeader(ACCEPT, APPLICATION_JSON).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).addHeader(X_ASSERTION, encodedActionAssertion).addHeader(X_ASSERTION, encodedRecipientsAssertion).post(this.jsonRequestBody("{}")).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String responseStr = response.body().string();
                this.handleErrorResponse(response, responseStr);
            }
        }
        log.debug("[PlusAutenti] Reminder sent successfully for document: {}", (Object)documentId);
    }

    @Override
    public void withdrawDocument(AutentiConnectionConfig config, String documentId) throws IOException, AutentiClientApiException {
        log.debug("[PlusAutenti] Withdrawing document: {}", (Object)documentId);
        String encodedActionAssertion = this.createEncodedAssertion(CHALLENGE_CLASSIFIER_ACTION_SELECTION, EVENT_CLASSIFIER_DOCUMENT_WITHDRAWAL);
        Request request = new Request.Builder().url(config.getApiUrl() + "/document-processes/" + documentId + "/actions").addHeader(CONTENT_TYPE, APPLICATION_JSON).addHeader(ACCEPT, APPLICATION_JSON).addHeader(AUTHORIZATION, "Bearer " + config.getToken()).addHeader(X_ASSERTION, encodedActionAssertion).post(this.jsonRequestBody("{}")).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String responseStr = response.body().string();
                this.handleErrorResponse(response, responseStr);
            }
            log.debug("[PlusAutenti] Document withdrawn successfully: {}", (Object)documentId);
        }
    }

    private void handleErrorResponse(Response response, String responseStr) throws AutentiClientApiException {
        ExceptionResponse exceptionResponse = (ExceptionResponse)this.gson.fromJson(responseStr, ExceptionResponse.class);
        String responseMessage = response.code() == 403 ? exceptionResponse.getTitle() : exceptionResponse.getDetail();
        throw new AutentiClientApiException(UNSUCCESSFUL_RESPONSE_MSG, response.code(), Optional.ofNullable(responseMessage).orElse(responseStr));
    }

    private String createEncodedAssertion(String classifier, String selectedId) {
        HashMap<String, Object> assertion = new HashMap<String, Object>();
        assertion.put("classifiers", Arrays.asList(classifier));
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("selectedIds", Arrays.asList(selectedId));
        assertion.put("attributes", attributes);
        String assertionJson = this.gson.toJson(assertion);
        return Base64.getEncoder().encodeToString(assertionJson.getBytes());
    }

    private String maskSensitiveData(String responseStr) {
        return TOKEN_MASK_PATTERN.matcher(responseStr).replaceAll("$1[MASKED]$4");
    }
}

