/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.scheduledtasks.dto;

import com.suncode.plugin.plusautenti.clientapi.dto.ParticipantsStatus;
import com.suncode.plugin.plusautenti.scheduledtasks.enums.DocumentStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;

public class AutentiDocumentInfo {
    private String autentiId;
    private String documentStatus;
    private List<ParticipantsStatus> participantsStatuses;

    public List<String> getSignerEmailsArray() {
        return this.participantsStatuses.stream().map(ParticipantsStatus::getEmail).collect(Collectors.toList());
    }

    public List<String> getSignerStatusArray() {
        return this.participantsStatuses.stream().map(p -> p.getRejectionComment().isEmpty() ? p.getStatus() : DocumentStatus.REJECTED.name()).collect(Collectors.toList());
    }

    public List<String> getRejectionCommentArray() {
        return this.participantsStatuses.stream().map(ParticipantsStatus::getRejectionComment).collect(Collectors.toList());
    }

    public static AutentiDocumentInfoBuilder builder() {
        return new AutentiDocumentInfoBuilder();
    }

    public String getAutentiId() {
        return this.autentiId;
    }

    public String getDocumentStatus() {
        return this.documentStatus;
    }

    public List<ParticipantsStatus> getParticipantsStatuses() {
        return this.participantsStatuses;
    }

    public void setAutentiId(String autentiId) {
        this.autentiId = autentiId;
    }

    public void setDocumentStatus(String documentStatus) {
        this.documentStatus = documentStatus;
    }

    public void setParticipantsStatuses(List<ParticipantsStatus> participantsStatuses) {
        this.participantsStatuses = participantsStatuses;
    }

    @ConstructorProperties(value={"autentiId", "documentStatus", "participantsStatuses"})
    public AutentiDocumentInfo(String autentiId, String documentStatus, List<ParticipantsStatus> participantsStatuses) {
        this.autentiId = autentiId;
        this.documentStatus = documentStatus;
        this.participantsStatuses = participantsStatuses;
    }

    public AutentiDocumentInfo() {
    }

    public static class AutentiDocumentInfoBuilder {
        private String autentiId;
        private String documentStatus;
        private List<ParticipantsStatus> participantsStatuses;

        AutentiDocumentInfoBuilder() {
        }

        public AutentiDocumentInfoBuilder autentiId(String autentiId) {
            this.autentiId = autentiId;
            return this;
        }

        public AutentiDocumentInfoBuilder documentStatus(String documentStatus) {
            this.documentStatus = documentStatus;
            return this;
        }

        public AutentiDocumentInfoBuilder participantsStatuses(List<ParticipantsStatus> participantsStatuses) {
            this.participantsStatuses = participantsStatuses;
            return this;
        }

        public AutentiDocumentInfo build() {
            return new AutentiDocumentInfo(this.autentiId, this.documentStatus, this.participantsStatuses);
        }

        public String toString() {
            return "AutentiDocumentInfo.AutentiDocumentInfoBuilder(autentiId=" + this.autentiId + ", documentStatus=" + this.documentStatus + ", participantsStatuses=" + this.participantsStatuses + ")";
        }
    }
}

