/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusautenti.applications.assertions;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.util.ServiceFactory;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;

public class ParameterAssertions {
    private ParameterAssertions() {
    }

    public static void assertEqualArrayLength(Object ... arrays) {
        if (arrays.length <= 1) {
            return;
        }
        int length = Array.getLength(arrays[0]);
        IntStream.range(1, arrays.length).forEach(i -> {
            if (Array.getLength(arrays[i]) != length) {
                throw new IllegalArgumentException("Array parameters don't have the same length");
            }
        });
    }

    public static void assertDocumentClassName(List<String> documentClassNames) {
        DocumentClassService documentService = ServiceFactory.getDocumentClassService();
        LinkedList incorrectDocumentClassNames = new LinkedList();
        documentClassNames.stream().forEach(documentClassName -> {
            DocumentClass documentClass = documentService.getDocumentClass(documentClassName, new String[0]);
            if (documentClass == null) {
                incorrectDocumentClassNames.add(documentClassName);
            }
        });
        if (!incorrectDocumentClassNames.isEmpty()) {
            throw new IllegalArgumentException("Document classes not found: " + String.join((CharSequence)", ", incorrectDocumentClassNames));
        }
    }
}

