/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusai.prompt.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.plusai.pcm.dto.PlusAiConfigurationDto;
import com.suncode.plugin.plusai.prompt.dto.GetCompletionRequestDto;
import com.suncode.plugin.plusai.prompt.dto.ResponseFormat;
import com.suncode.plugin.plusai.prompt.dto.response.ChatCompletionResponse;
import com.suncode.plugin.plusai.prompt.exception.ResponseFailedException;
import com.suncode.plugin.plusai.prompt.service.PromptService;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PromptServiceImpl
implements PromptService {
    private static final Logger log = LoggerFactory.getLogger(PromptServiceImpl.class);
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String KEY_HEADER_NAME = "Ocp-Apim-Subscription-Key";
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public PromptServiceImpl() {
        this.httpClient = new OkHttpClient.Builder().readTimeout(120L, TimeUnit.SECONDS).writeTimeout(120L, TimeUnit.SECONDS).connectTimeout(120L, TimeUnit.SECONDS).build();
    }

    @Override
    public ChatCompletionResponse getChatCompletion(PlusAiConfigurationDto configurationDto, String systemMessage, String userMessage, ResponseFormat responseFormat, String jsonSchema, List<String> attachments) throws ResponseFailedException, IOException {
        String apiKey = configurationDto.getKey();
        String endpoint = StringUtils.stripEnd((String)configurationDto.getUrl(), (String)"/");
        GetCompletionRequestDto requestDto = GetCompletionRequestDto.builder().systemMessage(systemMessage).userMessage(userMessage).responseFormat(responseFormat).jsonSchema(jsonSchema).attachments(attachments).build();
        RequestBody requestBody = RequestBody.create((String)this.objectMapper.writeValueAsString((Object)requestDto), (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(endpoint + "/v1/chat/completions").addHeader(CONTENT_TYPE_HEADER_NAME, "application/json").addHeader(KEY_HEADER_NAME, apiKey).post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new ResponseFailedException(String.format("Response failed! Code: %s. Message: %s", response.code(), this.getErrorMessage(response)));
            }
            ChatCompletionResponse chatCompletionResponse = (ChatCompletionResponse)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), (TypeReference)new TypeReference<ChatCompletionResponse>(){});
            return chatCompletionResponse;
        }
    }

    private String getErrorMessage(Response response) throws IOException {
        String message = response.message();
        ResponseBody body = response.body();
        if (body != null) {
            message = body.string();
        }
        return message;
    }
}

