/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusai.prompt.dual;

import com.suncode.pdfutils.PdfUtils;
import com.suncode.plugin.plusai.Categories;
import com.suncode.plugin.plusai.pcm.dto.PlusAiConfigurationDto;
import com.suncode.plugin.plusai.pcm.service.ConfigurationService;
import com.suncode.plugin.plusai.prompt.dto.ResponseFormat;
import com.suncode.plugin.plusai.prompt.dto.response.ChatCompletionResponse;
import com.suncode.plugin.plusai.prompt.exception.ResponseFailedException;
import com.suncode.plugin.plusai.prompt.service.PromptService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="/dist/prompt/dual/Prompt/pwe_dynamic_form.js")
public class Prompt {
    private static final Logger log = LoggerFactory.getLogger(Prompt.class);
    private static final String COMPONENT_ID = "plusai.dual.Prompt";
    private static final String[] ALLOWED_MIME_TYPES = new String[]{"image/jpeg", "image/png", "image/webp", "image/gif", "application/pdf"};
    @Autowired
    private FileFinder fileFinder;
    @Autowired
    private PromptService promptService;
    @Autowired
    private ConfigurationService configurationService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id(COMPONENT_ID)).name(COMPONENT_ID.concat(".name"))).description(COMPONENT_ID.concat(".desc"))).category(new Category[]{Categories.PLUS_AI})).icon((Icon)DivanteIcon.CPU)).parameter().id("configurationId").name(COMPONENT_ID.concat(".param.configurationId.name")).description(COMPONENT_ID.concat(".param.configurationId.desc")).type((Type)Types.STRING).create()).parameter().id("systemMessage").name(COMPONENT_ID.concat(".param.systemMessage.name")).description(COMPONENT_ID.concat(".param.systemMessage.desc")).type((Type)Types.STRING).create()).parameter().id("userMessage").name(COMPONENT_ID.concat(".param.userMessage.name")).description(COMPONENT_ID.concat(".param.userMessage.desc")).type((Type)Types.STRING).create()).parameter().id("responseFormat").name(COMPONENT_ID.concat(".param.responseFormat.name")).description(COMPONENT_ID.concat(".param.responseFormat.desc")).type((Type)Types.STRING).create()).parameter().id("jsonSchema").name(COMPONENT_ID.concat(".param.jsonSchema.name")).description(COMPONENT_ID.concat(".param.jsonSchema.desc")).type((Type)Types.STRING).optional().create()).parameter().id("fileId").name(COMPONENT_ID.concat(".param.fileId.name")).description(COMPONENT_ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER_ARRAY).create()).parameter().id("response").name(COMPONENT_ID.concat(".param.response.name")).description(COMPONENT_ID.concat(".param.response.desc")).type((Type)Types.VARIABLE).create();
    }

    public void set(@Param String configurationId, @Param String systemMessage, @Param String userMessage, @Param String responseFormat, @Param String jsonSchema, @Param String[] fileId, @Param Variable response) throws AcceptanceException {
        this.run(configurationId, systemMessage, userMessage, responseFormat, jsonSchema, fileId, response);
    }

    public void execute(@Param String configurationId, @Param String systemMessage, @Param String userMessage, @Param String responseFormat, @Param String jsonSchema, @Param String[] fileId, @Param Variable response) throws AcceptanceException {
        this.run(configurationId, systemMessage, userMessage, responseFormat, jsonSchema, fileId, response);
    }

    private void run(String configurationId, String systemMessage, String userMessage, String responseFormat, String jsonSchema, String[] fileId, Variable chatResponse) throws AcceptanceException {
        try {
            ResponseFormat format = ResponseFormat.valueOf(responseFormat.toUpperCase(Locale.ROOT));
            if (format.equals((Object)ResponseFormat.JSON_SCHEMA) && StringUtils.isBlank((CharSequence)jsonSchema)) {
                throw new AcceptanceException("JSON schema is required for selected response format!");
            }
            PlusAiConfigurationDto configurationDto = this.configurationService.readConfigurationFromPCM(configurationId);
            List<String> attachments = this.getBase64Attachments(fileId);
            ChatCompletionResponse chatCompletion = this.promptService.getChatCompletion(configurationDto, systemMessage, userMessage, format, jsonSchema, attachments);
            Optional<String> chatCompletionContent = this.extractChatResponseMessage(chatCompletion);
            chatCompletionContent.ifPresent(arg_0 -> ((Variable)chatResponse).setValue(arg_0));
        }
        catch (ResponseFailedException | IOException e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private Optional<String> extractChatResponseMessage(ChatCompletionResponse chatCompletionResponse) {
        return chatCompletionResponse.getChoices().stream().findFirst().map(choice -> choice.getMessage().getContent());
    }

    private List<String> getBase64Attachments(String[] fileId) {
        Tika tika = new Tika();
        ArrayList<String> encodedFiles = new ArrayList<String>();
        Arrays.stream(fileId).filter(Objects::nonNull).forEach(id -> {
            try {
                WfFile wfFile = (WfFile)this.fileFinder.get((Serializable)Long.valueOf(Long.parseLong(id)));
                Path path = Paths.get(wfFile.getFullPath(), new String[0]);
                byte[] bytes = Files.readAllBytes(path);
                String mimeType = tika.detect(bytes);
                if (Arrays.stream(ALLOWED_MIME_TYPES).noneMatch(type -> type.equalsIgnoreCase(mimeType))) {
                    log.warn("Unsupported MIME type: {} ({})", (Object)mimeType, (Object)wfFile.getFileName());
                    return;
                }
                if (mimeType.equalsIgnoreCase("application/pdf")) {
                    List pages = PdfUtils.convertPdfToImagesAsync((byte[])bytes, (String)"png", (int)300);
                    pages.forEach(page -> encodedFiles.add("data:image/png;base64," + Base64.getEncoder().encodeToString((byte[])page)));
                } else {
                    encodedFiles.add("data:" + mimeType + ";base64," + Base64.getEncoder().encodeToString(bytes));
                }
            }
            catch (Exception e) {
                log.warn("Error reading file (File ID: {}", id);
            }
        });
        return encodedFiles;
    }
}

