/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusai.pcm.service;

import com.google.gson.Gson;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusai.pcm.dto.PlusAiConfigurationDto;
import com.suncode.plugin.plusai.pcm.service.ConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private final Gson gson = new Gson();
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    @Override
    public PlusAiConfigurationDto readConfigurationFromPCM(String configId) throws IOException {
        Assert.isTrue((boolean)this.configExist(configId), (String)String.format("Config \"%s\" does not exist", configId));
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configId);){
            String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            PlusAiConfigurationDto plusAiConfigurationDto = (PlusAiConfigurationDto)this.gson.fromJson(content, PlusAiConfigurationDto.class);
            return plusAiConfigurationDto;
        }
    }

    private boolean configExist(String configId) {
        return this.configurationFileService.doesFileExist(this.plugin.getKey(), configId);
    }
}

