PWE.integrationComponent.registerApplication('remove-user-from-group', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    },
    validateForm: function (form) {
        return validateForm(form);
    }
});

PWE.integrationComponent.registerVariablesSetter('remove-user-from-group', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    },
    validateForm: function (form) {
        return validateForm(form);
    }
});

function buildForm(form) {

    form.addField('login');

    form.addField({
        id: "userLogins",
        optional: false
    });
    form.addField({
        id: "groupNames",
        optional: false
    });

    if (!form.getValue('login'))
        form.removeField('login');
}

function validateForm(form) {

    if (form.getArraySize('userLogins') == 0) {
        form.markError('userLogins');
        return false;
    }
    if (form.getArraySize('groupNames') == 0) {
        form.markError('groupNames');
        return false;
    }
    if (form.getValue('login')) {
        form.showErrorMessage(PLUGIN_ADMINISTRATION_TOOLS.t("add-remove-user-to-group.dynamic_form.clear_login.msg"));
        return false;
    }
    return true;
}