PWE.integrationComponent.registerApplication('create-calendar-resource', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

PWE.integrationComponent.registerVariablesSetter('create-calendar-resource', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

function buildForm(form) {
    let resourceTable = form.addTable();
    resourceTable.addField({
        id: 'names'
    });

    resourceTable.addField({
        id: 'descriptions'
    });

    const responseData = [];
    jQuery.ajax({
        url: PW.getAbsolutePath('api/calendar/resource/group'),
        contentType: "application/json",
        async: false,
        method: 'GET',
        success: function (response) {
            for (let i = 0; i < response.length; i++) {
                responseData[i] = {id: response[i].id, display: response[i].name, description: response[i].description};
            }
        },
        error: function() {
            Logger.error("Failed to retrieve the list of calendar resource groups.");
        },
        complete: function() {
            resourceTable.addCombobox({
                id: "resourceGroupIds",
                values: responseData,
                displayField: "display",
                valueField: "id",
                name: PLUGIN_ADMINISTRATION_TOOLS.t("application.create-calendar-resource.param.resource-group-id.name"),
                description: PLUGIN_ADMINISTRATION_TOOLS.t("application.create-calendar-resource.param.resource-group-id.desc")
            });
        }
    });

    resourceTable.addCombobox({
        id: 'allowOverlappingEvents',
        values: [
            { id: 'ALWAYS', display: PLUGIN_ADMINISTRATION_TOOLS.t('application.create-calendar-resource.param.allow-overlapping-events.value.always') },
            { id: 'NEVER', display: PLUGIN_ADMINISTRATION_TOOLS.t('application.create-calendar-resource.param.allow-overlapping-events.value.never') },
            { id: 'WARNING', display: PLUGIN_ADMINISTRATION_TOOLS.t('application.create-calendar-resource.param.allow-overlapping-events.value.warning') }
        ]
    });

    let outputFieldSet = form.addFieldSet({
        id: 'outputFields',
        title: PLUGIN_ADMINISTRATION_TOOLS.t("application.create-calendar-resource.output-fieldset.title"),
        collapsible: false,
        collapsed: false
    });

    outputFieldSet.addField({
        id: 'targetVariable'
    });

    outputFieldSet.addField({
        id: 'value'
    });
}