PWE.integrationComponent.registerApplication('create-calendar-resource-group', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

PWE.integrationComponent.registerVariablesSetter('create-calendar-resource-group', {
    apiVersion: 2,
    buildForm: function (form) {
        buildForm(form);
    }
});

function buildForm(form) {
    let resourceGroupTable = form.addTable();
    resourceGroupTable.addField({
        id: 'names'
    });
    resourceGroupTable.addField({
        id: 'descriptions'
    });

    const responseData = [];
    jQuery.ajax({
        url: PW.getAbsolutePath('api/calendar/resource/group'),
        contentType: "application/json",
        async: false,
        method: 'GET',
        success: function (response) {
            for (let i = 0; i < response.length; i++) {
                responseData[i] = {id: response[i].id, display: response[i].name, description: response[i].description};
            }
        },
        error: function() {
            Logger.error("Failed to retrieve the list of calendar resource groups.");
        },
        complete: function() {
            resourceGroupTable.addCombobox({
                id: "parentResourceGroupId",
                values: responseData,
                displayField: "display",
                valueField: "id",
                name: PLUGIN_ADMINISTRATION_TOOLS.t("application.create-calendar-resource-group.param.parent-resource-group-id.name"),
                description: PLUGIN_ADMINISTRATION_TOOLS.t("application.create-calendar-resource-group.param.parent-resource-group-id.desc")
            });
        }
    });

    let outputFieldSet = form.addFieldSet({
        id: 'outputFields',
        title: PLUGIN_ADMINISTRATION_TOOLS.t("application.create-calendar-resource-group.output-fieldset.title"),
        collapsible: false,
        collapsed: false
    });

    outputFieldSet.addField({
        id: 'targetVariable'
    });

    outputFieldSet.addField({
        id: 'value'
    });
}