/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.pwfl.calendar.resource.CalendarResourceFacade;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/remove-calendar-resource-permission.js")
public class RemoveCalendarResourcePermission {
    private static final Logger log = LoggerFactory.getLogger(RemoveCalendarResourcePermission.class);
    @Autowired
    private CalendarResourceFacade calendarResourceFacade;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("remove-calendar-resource-permission")).name("application.remove-calendar-resource-permission.name")).description("application.remove-calendar-resource-permission.desc")).category(new Category[]{Categories.TOOLS_CALENDAR})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}removing-resource-permissions")).icon((Icon)DivanteIcon.DELETE)).parameter().id("shareIds").name("application.remove-calendar-resource-permission.param.share-ids.name").description("application.remove-calendar-resource-permission.param.share-ids.desc").type((Type)Types.INTEGER_ARRAY).create();
    }

    public void execute(@Param Long[] shareIds) {
        this.run(shareIds);
    }

    public void set(@Param Long[] shareIds) {
        this.run(shareIds);
    }

    private void run(Long[] shareIds) {
        Assert.notEmpty((Object[])shareIds, (String)"Share IDs parameter is required");
        for (Long shareId : shareIds) {
            try {
                log.debug("Removing calendar resource share with ID: {}", (Object)shareId);
                this.calendarResourceFacade.deleteCalendarResourceShare(shareId.longValue());
                log.debug("Calendar resource share removed successfully with ID: {}", (Object)shareId);
            }
            catch (Exception e) {
                log.error("Error removing calendar resource share with ID {}: {}", new Object[]{shareId, e.getMessage(), e});
            }
        }
    }
}

