/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.pwfl.calendar.resource.CalendarResourceGroupFacade;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/remove-calendar-resource-group-permission.js")
public class RemoveCalendarResourceGroupPermission {
    private static final Logger log = LoggerFactory.getLogger(RemoveCalendarResourceGroupPermission.class);
    @Autowired
    private CalendarResourceGroupFacade calendarResourceGroupFacade;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("remove-calendar-resource-group-permission")).name("application.remove-calendar-resource-group-permission.name")).description("application.remove-calendar-resource-group-permission.desc")).category(new Category[]{Categories.TOOLS_CALENDAR})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}removing-permissions-for-resource-groups")).icon((Icon)DivanteIcon.DELETE)).parameter().id("shareIds").name("application.remove-calendar-resource-group-permission.param.share-ids.name").description("application.remove-calendar-resource-group-permission.param.share-ids.desc").type((Type)Types.INTEGER_ARRAY).create();
    }

    public void execute(@Param Long[] shareIds) {
        this.run(shareIds);
    }

    public void set(@Param Long[] shareIds) {
        this.run(shareIds);
    }

    private void run(Long[] shareIds) {
        Assert.notEmpty((Object[])shareIds, (String)"Share IDs parameter is required");
        for (Long shareId : shareIds) {
            try {
                log.debug("Removing calendar resource group share with ID: {}", (Object)shareId);
                this.calendarResourceGroupFacade.deleteCalendarResourceGroupShare(shareId.longValue());
                log.debug("Calendar resource group share removed successfully with ID: {}", (Object)shareId);
            }
            catch (Exception e) {
                log.error("Error removing calendar resource group share with ID {}: {}", new Object[]{shareId, e.getMessage(), e});
            }
        }
    }
}

