/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.administrationtools.autotask;

import com.suncode.plugin.administrationtools.Categories;
import com.suncode.pwfl.calendar.resource.CalendarResourceGroupFacade;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/remove-calendar-resource-group.js")
public class RemoveCalendarResourceGroup {
    private static final Logger log = LoggerFactory.getLogger(RemoveCalendarResourceGroup.class);
    @Autowired
    private CalendarResourceGroupFacade calendarResourceGroupFacade;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("remove-calendar-resource-group")).name("application.remove-calendar-resource-group.name")).description("application.remove-calendar-resource-group.desc")).category(new Category[]{Categories.TOOLS_CALENDAR})).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}deleting-resource-groups")).icon((Icon)DivanteIcon.DELETE)).parameter().id("ids").name("application.remove-calendar-resource-group.param.ids.name").description("application.remove-calendar-resource-group.param.ids.desc").type((Type)Types.INTEGER_ARRAY).create();
    }

    public void execute(@Param Long[] ids) {
        this.run(ids);
    }

    public void set(@Param Long[] ids) {
        this.run(ids);
    }

    private void run(Long[] ids) {
        Assert.notEmpty((Object[])ids, (String)"IDs parameter is required");
        for (Long id : ids) {
            try {
                log.debug("Removing calendar resource group with ID: {}", (Object)id);
                this.calendarResourceGroupFacade.deleteCalendarResourceGroup(id.longValue());
                log.debug("Calendar resource group removed successfully with ID: {}", (Object)id);
            }
            catch (Exception e) {
                log.error("Error removing calendar resource group with ID {}: {}", new Object[]{id, e.getMessage(), e});
            }
        }
    }
}

